/*
 * @(#)MacComboBoxMenuItemUI.java	1.4 98/02/02
 *
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing.plaf.mac;


import java.awt.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;


/**
 * MacComboBoxMenuItemUI implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacComboBoxMenuItemUI.java	1.0 01/20/98
 * @author Symantec
 */
public class MacComboBoxMenuItemUI extends MacMenuItemUI
{
	MacComboBoxUI.ComboBoxMenuItem comboBoxMenuItem = null;
	CellRendererPane menuItemPane = new CellRendererPane();

	public MacComboBoxMenuItemUI(MacComboBoxUI.ComboBoxMenuItem c) {
		comboBoxMenuItem = c;
	}
	
	public static ComponentUI createUI(JComponent c) {
		return new MacComboBoxMenuItemUI((MacComboBoxUI.ComboBoxMenuItem) c);
	}
	
	public void installUI(JComponent c) {
		super.installUI(c);
		c.add(menuItemPane);
	}
	
	public void uninstallUI(JComponent c) {
		c.remove(menuItemPane);
		super.uninstallUI(c);
	}

    
	public Dimension getPreferredSize(JComponent c) {
		Component rendererComponent = getRendererComponent();
		if (rendererComponent != null) {
			menuItemPane.add(rendererComponent);
			Dimension size =  rendererComponent.getPreferredSize();
			menuItemPane.remove(rendererComponent);

			Insets insets = comboBoxMenuItem.getInsets();
			size.width += (insets.left + insets.right);
			size.height += (insets.top + insets.bottom);
			return size;
		}

		return new Dimension(0, 0);
	}

	public synchronized void paint(Graphics g, JComponent c) {
		Component rendererComponent = getRendererComponent();
		if (rendererComponent != null) {
			Rectangle bounds = new Rectangle(comboBoxMenuItem.getSize());
			menuItemPane.setBounds(bounds);
			
			ButtonModel model = comboBoxMenuItem.getModel();
			
			Color fgColor = null;
			Color bgColor = null;
			
			if (!model.isEnabled())
			{
				fgColor = disabledForeground;
			}
			else if (model.isArmed())
			{
				fgColor = pressedForeground;
				bgColor = pressedBackground;
			}

			rendererComponent.setForeground(fgColor == null ? menuItemPane.getForeground() : fgColor);
			rendererComponent.setBackground(bgColor == null ? menuItemPane.getBackground() : bgColor);

			menuItemPane.paintComponent(g, rendererComponent, comboBoxMenuItem.getParent(), bounds);
		}
    }

	Component getRendererComponent() {
		JComboBox comboBox = comboBoxMenuItem.getComboBox();
		ListCellRenderer listCellRenderer = comboBox.getRenderer();
		if (listCellRenderer == null)
			return null;

		return listCellRenderer.getListCellRendererComponent(
												comboBox.getUI().getList(),
												comboBox.getModel().getElementAt(comboBoxMenuItem.itemIndex), 
												comboBoxMenuItem.itemIndex, 
												comboBoxMenuItem.getModel().isArmed(), 
												false);
	}
}
