/*
 * @(#)MacButtonUI.java	1.6 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.*;

/**
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacButtonUI.java	1.0 11/24/97
 * @author Symantec
 * @author Levi Brown
 */

public class MacButtonUI extends BasicButtonUI
{
	/**
	* border & margin
	*/
	protected final static Insets defaultMargin = new Insets(0, 8, 0, 8);
	protected final static Insets defaultIconMargin = new Insets(1, 1, 1, 1);
	protected final static Insets defaultCombinedMargin = new Insets(2, 4, 2, 4);
	
	protected MacButtonListener macButtonListener = new MacButtonListener(null);

	protected static Color GSBColor = UIManager.getColor("GrayscaleAppearanceB");
	protected static Color GSWColor = UIManager.getColor("GrayscaleAppearanceW");
	protected static Color GS2Color = UIManager.getColor("GrayscaleAppearance2");
	protected static Color GS7Color = UIManager.getColor("GrayscaleAppearance7");
	protected static Color GS9Color = UIManager.getColor("GrayscaleAppearance9");

	protected ActivationHelper activationHelper;
	protected ChangeListener changeListener;
	protected boolean isActive = true;
	
	public static ComponentUI createUI(JComponent c)
	{
		return new MacButtonUI();
	}
	
    public void installUI(JComponent c)
    {
    	super.installUI(c);
    	
		//The Mac doesn't paint the focus...
		((AbstractButton)c).setFocusPainted(false);
		
		LookAndFeel.installBorder(c,"Button.border");
    }

    public boolean isActive()
    {
    	return isActive;
    }

    public Dimension getPreferredSize(JComponent c) {
		AbstractButton b = (AbstractButton)c;
		return MacGraphicsUtils.getPreferredButtonSize(b, getDefaultTextIconGap(b));
    }

	public Insets getDefaultMargin(AbstractButton b)
	{
		String text = b.getText();
		if (text != null && !text.equals("")) {
			if (b.getIcon() != null)
				return defaultCombinedMargin;
			return defaultMargin;
		} else
			return defaultIconMargin;
	}
	
    public boolean contains(JComponent c, int x, int y)
    {
    	boolean isDefault = false;
    	
		if(c instanceof JButton)
		{
			JButton b = (JButton)c;
			isDefault = b.isDefaultButton();
		}
		
		if(isDefault)
		{
			try
			{
				MacButtonBorder	border	= (MacButtonBorder) c.getBorder();
				Insets			i		= border.getDefaultBorderInsets(c);
				Rectangle		rect	= c.getBounds();
				
				rect.x		+= i.left;
				rect.y		+= i.top;
				rect.width	-= i.left + i.right;
				rect.height	-= i.top + i.bottom;
				
				return rect.contains(x, y);;
			}
			catch(ClassCastException exc) {}
		}

		return super.contains(c, x, y);;
    }

	public void paint(Graphics g, JComponent c)
	{
		AbstractButton b = (AbstractButton) c;
		ButtonModel model = b.getModel();
		
		if (model.isArmed() && model.isPressed())
		{
			paintButtonPressed(g,b); 
		}
		else
		{
			paintButton(g, b, false);
		}
	}
    
	protected void paintButtonPressed(Graphics g, AbstractButton b)
	{
		paintButton(g, b, true);
	}
	
	protected void paintButton(Graphics g, AbstractButton b, boolean isPressed)
	{
		JComponent	c			= (JComponent) b;
		ButtonModel	model		= b.getModel();
		Dimension	size		= b.getSize();
		FontMetrics	fm			= g.getFontMetrics();
	    Rectangle	viewRect	= new Rectangle(size);
	    Rectangle	iconRect	= new Rectangle();
	    Rectangle	textRect	= new Rectangle();
		Color		fillColor;
		Color		textColor;
		
		if(model.isEnabled() && isActive())
		{
			if(isPressed)
			{
				fillColor = GS9Color;
				textColor = GSWColor;
			}
			else
			{
				fillColor = GS2Color;
				textColor = GSBColor;
			}
		}
		else
		{
				fillColor = GS2Color;
				textColor = GS7Color;
		}

		// Paint background
		g.setColor(fillColor);
	    g.fillRect(2,2,size.width-5,size.height-5);

		// layout the text and icon
	    String text = SwingUtilities.layoutCompoundLabel
	    (
			fm, b.getText(), b.getIcon(),
			b.getVerticalAlignment(), b.getHorizontalAlignment(),
			b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
			viewRect, iconRect, textRect, b.getText() == null ? 0 : getDefaultTextIconGap(b)
		);
	
		//Adjust the rectangles for the Mac
		if(b.getVerticalAlignment() == AbstractButton.CENTER)
		{
			--textRect.x;
			--textRect.y;
			--iconRect.y;
		}
		
		g.setColor(textColor);

 		// Draw the icon if needed
 		paintIcon(g, b, iconRect, isPressed);
	
		// Draw the Text if needed
 		paintText(g, b, textRect, text, textColor);

		// Paint the focus if needed (shouldn't be, but leaving in for extensibility)
		if (b.isFocusPainted() && b.hasFocus())
		{
			// paint UI specific focus
			paintFocus(g, size);
		}
	}

 	protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text, Color textColor)
 	{
		// Draw the Text
		if(text != null && !text.equals(""))
		{
			JComponent	c		= (JComponent) b;
			Font		f		= c.getFont();
			g.setFont(f);
			FontMetrics	fm		= g.getFontMetrics();
			
			g.drawString(text, textRect.x, textRect.y + fm.getAscent() + ((fm.getLeading() + 1) / 2));
		}		
 	}
 	
 	protected void paintIcon(Graphics g, AbstractButton b, Rectangle iconRect, boolean isPressed)
 	{
		// Paint the Icon
		if(b.getIcon() != null)
		{ 
			JComponent	c		= (JComponent) b;
			ButtonModel	model	= b.getModel();
			Icon		icon	= null;
			
			if(!model.isEnabled())
			{
				icon = (Icon) b.getDisabledIcon();
			}
			else if(isPressed)
			{
				icon = (Icon) b.getPressedIcon();
				// if no pressed icon, draw a darker version of the icon
				if (icon == null)
				{
					// Use default icon
					icon = (Icon) b.getIcon();
					if (icon != null && icon instanceof ImageIcon) {
						icon = new ImageIcon(
							PressedFilter.createPressedImage(((ImageIcon) icon).getImage()));
					}
				}
			}
			else if(b.isRolloverEnabled() && model.isRollover())
			{
				icon = (Icon) b.getRolloverIcon();
			}
		
			if (icon == null)
			{
				icon = (Icon) b.getIcon();
			}
			
			icon.paintIcon(c, g, iconRect.x, iconRect.y);
		}
	}

	protected void paintFocus(Graphics g, Dimension size)
	{
		//Do nothing
	}

	protected BasicButtonListener createListener(JComponent c)
	{
		return macButtonListener;
	}
	
	protected void installListeners(JComponent c)
	{
		super.installListeners(c);
		
		activationHelper	= new ActivationHelper(c);
		changeListener		= new ChangeListener();
		activationHelper.addPropertyChangeListener(changeListener);
	}
	
	protected void uninstallListeners(JComponent c)
	{
		super.uninstallListeners(c);
		activationHelper.removePropertyChangeListener(changeListener);
		activationHelper = null;
		changeListener = null;
	}

    class ChangeListener implements java.beans.PropertyChangeListener
    {
		public void propertyChange(java.beans.PropertyChangeEvent evt)
		{
			if(evt.getPropertyName().equals("activated"))
			{
				boolean oldActive = isActive;
				isActive = ((Boolean) evt.getNewValue()).booleanValue();
				if(isActive != oldActive)
				{
					Object obj = evt.getSource();
					if(obj instanceof ActivationHelper)
					{
						((ActivationHelper)obj).getComponent().repaint();
					}
				}
			}
		}
    }
}
