/*
 * @(#)MacButtonBorder.java	1.5 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Dimension;
import java.util.Vector;

/**
 * @version @(#)MacButtonBorder.java	1.0 12/5/97
 * @author Symantec
 * @author Levi Brown
 */

class MacButtonBorder extends AbstractBorder implements UIResource
{
	final static Insets borderInsets			= new Insets(3, 3, 3, 3);
	final static Insets defaultBorderInsets	= new Insets(3, 3, 3, 3);

	protected static Color GSBColor	= UIManager.getColor("GrayscaleAppearanceB");
	protected static Color GSWColor	= UIManager.getColor("GrayscaleAppearanceW");
	protected static Color GS2Color	= UIManager.getColor("GrayscaleAppearance2");
	protected static Color GS4Color	= UIManager.getColor("GrayscaleAppearance4");
	protected static Color GS5Color	= UIManager.getColor("GrayscaleAppearance5");
	protected static Color GS7Color	= UIManager.getColor("GrayscaleAppearance7");
	protected static Color GS8Color	= UIManager.getColor("GrayscaleAppearance8");
	protected static Color GS9Color	= UIManager.getColor("GrayscaleAppearance9");
	protected static Color GS10Color	= UIManager.getColor("GrayscaleAppearance10");
	protected static Color GS11Color	= UIManager.getColor("GrayscaleAppearance11");

	protected static ImageIcon upPB		= null;
	protected static ImageIcon downPB;
	protected static ImageIcon disabledPB;
	protected static ImageIcon defaultEnabledPB;
	protected static ImageIcon defaultDisabledPB;

	public MacButtonBorder()
	{
		if(upPB == null)
		{
			upPB				= (ImageIcon) UIManager.getIcon("PushButton.up");
			downPB				= (ImageIcon) UIManager.getIcon("PushButton.down");
			disabledPB			= (ImageIcon) UIManager.getIcon("PushButton.disabled");
			defaultEnabledPB	= (ImageIcon) UIManager.getIcon("PushButton.defaultEnabled");
			defaultDisabledPB	= (ImageIcon) UIManager.getIcon("PushButton.defaultDisabled");
		}
	}
	
	public void paintBorder(Component c, Graphics g, int x, int y, int width, int height)
	{
		boolean	isPressed		= false;
		boolean	isEnabled		= true;
		boolean	isDefault		= false;
		boolean	isActive		= true;
		int			internalWidth	= width;
		int			internalHeight	= height;
		int			xOffset			= 0;
		int			yOffset			= 0;
		ImageIcon	workingIcon;
		Vector		colors;
		
		if (c instanceof AbstractButton)
		{
			AbstractButton b = (AbstractButton)c;
			ButtonModel model = b.getModel();
			
			isPressed = (model.isArmed() && model.isPressed());
			isEnabled = model.isEnabled();
			
			ComponentUI ui = b.getUI();
			if(ui instanceof MacButtonUI)
			{
				isActive = ((MacButtonUI)ui).isActive();
			}
		}
		
		if(c instanceof JButton)
		{
			JButton b = (JButton)c;
			isDefault = b.isDefaultButton();
		}
		
		
		if(isDefault)
		{
			colors = new Vector();
			
			if(isEnabled && isActive)
			{
				workingIcon		= defaultEnabledPB;
				
				colors.addElement(GSBColor);	//Top and Left
				colors.addElement(GSBColor);	//Bottom and Right
				colors.addElement(GS2Color);	//Top and Left
				colors.addElement(GS8Color);	//Bottom and Right
				colors.addElement(GS5Color);	//Top and Left
				colors.addElement(GS5Color);	//Bottom and Right
			}
			//Disabled
			else
			{
				workingIcon		= defaultDisabledPB;
	
				colors.addElement(GS7Color);	//Top and Left
				colors.addElement(GS7Color);	//Bottom and Right
				colors.addElement(GS4Color);	//Top and Left
				colors.addElement(GS4Color);	//Bottom and Right
				colors.addElement(GS4Color);	//Top and Left
				colors.addElement(GS4Color);	//Bottom and Right
			}
	
			MacBorderFactory.paintButtonBorder(c, g, workingIcon, colors, new Point(xOffset, yOffset), new Dimension(internalWidth, internalHeight));
			internalWidth	-= defaultBorderInsets.left + defaultBorderInsets.right;
			internalHeight	-= defaultBorderInsets.top + defaultBorderInsets.bottom;
			xOffset = defaultBorderInsets.left;
			yOffset = defaultBorderInsets.top;
		}

		colors = new Vector();
		
		if(isEnabled && isActive)
		{
			if(isPressed)
			{
				workingIcon		= downPB;

				colors.addElement(GSBColor);	//Top and Left
				colors.addElement(GSBColor);	//Bottom and Right
				colors.addElement(GS11Color);	//Top and Left
				colors.addElement(GS7Color);	//Bottom and Right
				colors.addElement(GS10Color);	//Top and Left
				colors.addElement(GS8Color);	//Bottom and Right
			}
			//If it's released
			else
			{
				workingIcon		= upPB;
				
				colors.addElement(GSBColor);	//Top and Left
				colors.addElement(GSBColor);	//Bottom and Right
				colors.addElement(GS2Color);	//Top and Left
				colors.addElement(GS8Color);	//Bottom and Right
				colors.addElement(GSWColor);	//Top and Left
				colors.addElement(GS5Color);	//Bottom and Right
			}
		}
		//Disabled
		else
		{
			workingIcon		= disabledPB;

			colors.addElement(GS7Color);	//Top and Left
			colors.addElement(GS7Color);	//Bottom and Right
			colors.addElement(GS2Color);	//Top and Left
			colors.addElement(GS2Color);	//Bottom and Right
			colors.addElement(GS2Color);	//Top and Left
			colors.addElement(GS2Color);	//Bottom and Right
		}
		
		MacBorderFactory.paintButtonBorder(c, g, workingIcon, colors, new Point(xOffset, yOffset), new Dimension(internalWidth, internalHeight));
	}
	
	public Insets getBorderInsets(Component c)
	{
		boolean	isDefault	= false;
		Insets		insets		= (Insets) borderInsets.clone();
		
		if(c instanceof JButton)
		{
			JButton b = (JButton)c;
			isDefault = b.isDefaultButton();
		}
		
		if(isDefault)
		{
			insets.top		+= defaultBorderInsets.top;
			insets.left		+= defaultBorderInsets.left;
			insets.bottom	+= defaultBorderInsets.bottom;
			insets.right	+= defaultBorderInsets.right;
		}
		
		return insets;
	}
	
	public Insets getDefaultBorderInsets(Component c)
	{
		return defaultBorderInsets;
	}	
}
