/*
 * @(#)MacBorderFactory.java	1.6 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;

import java.awt.Component;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Dimension;
import java.util.Vector;

/**
 * @version @(#)MacBorderFactory.java	1.0 11/24/97
 * @author Symantec
 */

public class MacBorderFactory
{
	protected static Border loweredBevelBorder;
	protected static Border raisedBevelBorder;
	protected static Border buttonBorder;
	protected static Border toggleButtonBorder;
	private static Border textBorder;
	protected static Border focusBorder;
	protected static Border fieldBorder;
	protected static Border menuBarBorder;
	protected static Border popupMenuBorder;
	protected static Border comboBoxBorder;
	protected static Border comboBoxArrowBorder;
	protected static Border editableComboBoxArrowBorder;
	protected static Border buttonMarginBorder;
	
	public static Border getLoweredBevelBorder()
	{
		if (loweredBevelBorder == null)
		{
			loweredBevelBorder = new MacBevelBorder(false);
		}
		return loweredBevelBorder;
	}
	
	public static Border getRaisedBevelBorder()
	{
		if (raisedBevelBorder == null)
		{
			raisedBevelBorder = new MacBevelBorder(true);
		}
		return raisedBevelBorder;
	}
	
	
	public static Border getButtonBorder()
	{
		if (buttonBorder == null)
		{
			buttonBorder = new MacButtonBorder();
		}
		return buttonBorder;
	}
	
	
	public static Border getTextBorder() {
		if (textBorder == null)
		{
			textBorder = new MacTextBorder();
		}
		return textBorder;
	}
    
    
	public static Border getFocusBorder()
	{
		if (focusBorder == null)
		{
			focusBorder = new MacFocusBorder();
		}
		return focusBorder;
	}
	
	public static Border getFieldBorder()
	{
		if (fieldBorder == null)
		{
			fieldBorder = new MacTextBorder();
		}
		return fieldBorder;
	}
	
	public static Border getToggleButtonBorder()
	{
		if (toggleButtonBorder == null)
		{
			toggleButtonBorder = new MacToggleButtonBorder();
		}
		return toggleButtonBorder;
	}
	
	public static Border getMenuBarBorder()
	{
		if (menuBarBorder == null)
		{
			menuBarBorder = new MacMenuBarBorder();
		}
		return menuBarBorder;
	}
	
	public static Border getPopupMenuBorder()
	{
		if (popupMenuBorder == null)
		{
			popupMenuBorder = new MacPopupMenuBorder();
		}
		return popupMenuBorder;
	}
	
	public static Border getComboBoxBorder()
	{
		if (comboBoxBorder == null)
		{
			comboBoxBorder = new MacComboBoxBorder();
		}
		return comboBoxBorder;
	}
	
	public static Border getComboBoxArrowBorder()
	{
		if (comboBoxArrowBorder == null)
		{
			comboBoxArrowBorder = new CompoundBorder(
										new MacComboBoxArrowBorder(),
										getButtonMarginBorder());
		}
		return comboBoxArrowBorder;
	}
	
	public static Border getEditableComboBoxArrowBorder()
	{
		if (editableComboBoxArrowBorder == null)
		{
			editableComboBoxArrowBorder = new CompoundBorder(
										new MacEditableComboBoxArrowBorder(),
										getButtonMarginBorder());
		}
		return editableComboBoxArrowBorder;
	}

	public static Border getButtonMarginBorder()
	{
		if (buttonMarginBorder == null)
		{
			buttonMarginBorder = new AbstractBorder() {
				public Insets getBorderInsets(Component c) {
					return ((AbstractButton)c).getMargin();
				}
			};
		}
		return buttonMarginBorder;
	}

	static void paintButtonCorners(Component c, Graphics g, ImageIcon icon, Point origin, Dimension size)
	{
		Image	img			= icon.getImage();
		int		imgWidth	= icon.getIconWidth();
		int		imgHeight	= icon.getIconHeight();
		int		halfWidth	= imgWidth >> 1;
		int		halfHeight	= imgHeight >> 1;
		int		x			= origin.x;
		int		y			= origin.y;
		
		//Draw the Top Left corner
		g.drawImage(img,
		  x, y, halfWidth + x, halfHeight + y,															/*destination*/
		  0, 0, halfWidth, halfHeight,																	/*source*/
		  c);
		//Draw the Top Right corner
		g.drawImage(img,
		  size.width - halfWidth + x, y, size.width + x, halfHeight + y,								/*destination*/
		  halfWidth, 0, imgWidth, halfHeight,															/*source*/
		  c);
		//Draw the Bottom Left corner
		g.drawImage(img,
		  x, size.height - halfHeight + y, halfWidth + x, size.height + y,								/*destination*/
		  0, halfHeight, halfWidth, imgHeight,															/*source*/
		  c);
		//Draw the Bottom Right corner
		g.drawImage(img,
		  size.width - halfWidth + x, size.height - halfHeight + y, size.width + x, size.height + y,	/*destination*/
		  halfWidth, halfHeight, imgWidth, imgHeight,													/*source*/
		  c);
	}

	public static void paintButtonBorder(Component c, Graphics g, ImageIcon icon, Vector colors, Point origin, Dimension size)
	{
		int		halfWidth	= icon.getIconWidth() >> 1;
		int		halfHeight	= icon.getIconHeight() >> 1;
		int		w			= size.width - 1;
		int		h			= size.height - 1;
		int		x			= origin.x;
		int		y			= origin.y;

		// Draw the corners
		paintButtonCorners(c, g, icon, origin, size);
		
		Color oldColor = g.getColor();	
		
		//Draw the lines
		for(int index = 0, count = 0; index < colors.size(); index += 2, ++count)
		{
			g.setColor((Color)colors.elementAt(index));
			g.drawLine(halfWidth + x, count + y, w - halfWidth + x, count + y);				//Top
			g.drawLine(count + x, halfHeight + y, count + x, h - halfHeight + y);			//Left
			try
			{
				g.setColor((Color)colors.elementAt(index + 1));
			}
			catch (ArrayIndexOutOfBoundsException exc) { }
			g.drawLine(halfWidth + x, h - count + y, w - halfWidth + x, h - count + y);		//Bottom
			g.drawLine(w - count + x, halfHeight + y, w - count + x, h - halfHeight + y);	//Right
			
		}

		g.setColor(oldColor);
	}

	private static class MacPopupMenuBorder extends AbstractBorder implements UIResource
	{
		public void paintBorder(Component c, Graphics g, int x, int y, int width, int height)
		{
			g.translate(x, y);
	
			// There is a black rectangle that encompasses (most of) the border
			g.setColor(MacUtilities.GrayscaleAppearanceB);
			g.drawRect(0, 0, width - 2, height - 2);

			// The top side lightens a couple pixels in the black border
			g.setColor(MacUtilities.GrayscaleAppearance12);
			g.drawLine(1, 0, 1, 0);
			g.drawLine(width - 3, 0, width - 3, 0);
			
			// The top side has a light bevel accent inside the black border
			g.setColor(MacUtilities.GrayscaleAppearanceW);
			g.drawLine(1, 1, width - 4, 1);
			g.setColor(MacUtilities.GrayscaleAppearance2);
			g.drawLine(width - 3, 1, width - 3, 1);
			
			// The Bottom & Right have a shadow outside the black border
			g.setColor(MacUtilities.GrayscaleAppearance12);
			g.drawLine(2, height - 1, width - 1, height - 1);		// Bottom
			g.drawLine(width - 1, 2, width - 1, height - 1);		// Right

			// The Bottom has a dark bevel accent inside the black border
			g.setColor(MacUtilities.GrayscaleAppearance2);
			g.drawLine(1, height - 3, 1, height - 3);
			g.setColor(MacUtilities.GrayscaleAppearance6);
			g.drawLine(2, height - 3, width - 3, height - 3);

			g.translate(-x, -y);
		}

		public Insets getBorderInsets(Component c)
		{
			return new Insets(2,1,2,3);
		}
	}


        /**
         * <p>
         * Warning: serialized objects of this class will not be compatible with
         * future swing releases.  The current serialization support is appropriate
         * for short term storage or RMI between Swing1.0 applications.  It will
         * not be possible to load serialized Swing1.0 objects with future releases
         * of Swing.  The JDK1.2 release of Swing will be the compatibility
         * baseline for the serialized form of Swing objects.
         */
	protected static class MacMenuBarBorder extends AbstractBorder implements UIResource
	{
		public void paintBorder(Component c, Graphics g, int x, int y, int width, int height)
		{
			g.translate(x, y);
	
			// Top & Left are white
			g.setColor(MacUtilities.GrayscaleAppearanceW);
			g.drawLine(0, 0, width, 0);
			g.drawLine(0, 0, 0, height);
	
			// Draw a Bevel at the Bottom & Right
			g.setColor(MacUtilities.GrayscaleAppearance6);
			g.drawLine(1, height - 2, width, height - 2);	// Bottom
	
			g.setColor(MacUtilities.GrayscaleAppearanceB);
			g.drawLine(0, height - 1, width, height - 1);	// Bottom
			g.drawLine(width - 1, 1, width - 1, height);	// Right
	
			g.translate(-x, -y);
		}
		
		public Insets getBorderInsets(Component c)
		{
			return new Insets(2,6,2,6);
		}
	}

        /**
         * <p>
         * Warning: serialized objects of this class will not be compatible with
         * future swing releases.  The current serialization support is appropriate
         * for short term storage or RMI between Swing1.0 applications.  It will
         * not be possible to load serialized Swing1.0 objects with future releases
         * of Swing.  The JDK1.2 release of Swing will be the compatibility
         * baseline for the serialized form of Swing objects.
         */
	protected static class MacComboBoxBorder extends AbstractBorder implements UIResource
	{
		static ImageIcon comboBoxEnabledBorder = null;
		static ImageIcon comboBoxPressedBorder = null;
		static ImageIcon comboBoxDisabledBorder = null;
		static final int borderLeftSize = 3;
		static final int borderTopSize = 2;
		static final int borderBottomSize = 2;

		public MacComboBoxBorder() {
			if (comboBoxEnabledBorder == null)
			{
				comboBoxEnabledBorder = (ImageIcon) UIManager.getIcon("ComboBoxBorder.enabled");
				comboBoxPressedBorder = (ImageIcon) UIManager.getIcon("ComboBoxBorder.pressed");
				comboBoxDisabledBorder = (ImageIcon) UIManager.getIcon("ComboBoxBorder.disabled");
			}
		}
		public void paintBorder(Component c, Graphics g, int x, int y, int width, int height)
		{
			JComboBox b = (JComboBox)c;
			
			g.translate(x, y);

			ImageIcon icon;
			Color topBotLeft, topLeftIn1, leftIn2, bottomIn1;

			if (b.isEnabled()) {
				if (b.getUI().popupIsVisible()) {
					topBotLeft = MacUtilities.GrayscaleAppearanceB;
	
					topLeftIn1 = MacUtilities.GrayscaleAppearance10;
					leftIn2 = MacUtilities.GrayscaleAppearance9;
					bottomIn1 = MacUtilities.GrayscaleAppearance8;

					icon = comboBoxPressedBorder;
				}
				else {
					topBotLeft = MacUtilities.GrayscaleAppearanceB;
	
					topLeftIn1 = MacUtilities.GrayscaleAppearanceW;
					leftIn2 = MacUtilities.GrayscaleAppearance2;
					bottomIn1 = MacUtilities.GrayscaleAppearance5;

					icon = comboBoxEnabledBorder;
				}
			}
			else {
				topBotLeft = MacUtilities.GrayscaleAppearance7;

				topLeftIn1 =
				leftIn2 =
				bottomIn1 = MacUtilities.GrayscaleAppearance2;

				icon = comboBoxDisabledBorder;
			}

			// Draw the corners
			Image	img			= icon.getImage();
			int		imgWidth	= icon.getIconWidth();
			int		imgHeight	= icon.getIconHeight();
		
			//Draw the Top Left corner
			g.drawImage(img,
			  0, 0, imgWidth, borderTopSize,									/*destination*/
			  0, 0, imgWidth, borderTopSize,									/*source*/
			  c);
			//Draw the Bottom Left corner
			g.drawImage(img,
			  0, height - borderBottomSize, imgWidth, height,					/*destination*/
			  0, borderBottomSize, imgWidth, imgHeight,							/*source*/
			  c);

		
			//Draw the lines
			Color oldColor = g.getColor();	

			int w = width - 1;
			int h = height - 1;

			//	Outside line
			g.setColor(topBotLeft);
			g.drawLine(borderLeftSize, 0, w, 0);								// Top
			g.drawLine(0, borderTopSize, 0, h - borderTopSize);					// Left
			g.drawLine(borderLeftSize, h, w, h);								// Bottom

			//	Inside 1 line
			g.setColor(topLeftIn1);
			g.drawLine(borderLeftSize, 1, w, 1);								// Top
			g.drawLine(1, borderTopSize, 1, h - borderTopSize);					// Left
			g.setColor(bottomIn1);
			g.drawLine(borderLeftSize, h - 1, w, h - 1);						// Bottom

			//	Inside 2 line
			g.setColor(leftIn2);
			g.drawLine(2, borderTopSize, 2, h - borderTopSize);					// Left

			g.setColor(oldColor);

			g.translate(-x, -y);
		}
		public Insets getBorderInsets(Component c)
		{
			return new Insets(2, 3, 2, 0);
		}
	}
        /**
         * <p>
         * Warning: serialized objects of this class will not be compatible with
         * future swing releases.  The current serialization support is appropriate
         * for short term storage or RMI between Swing1.0 applications.  It will
         * not be possible to load serialized Swing1.0 objects with future releases
         * of Swing.  The JDK1.2 release of Swing will be the compatibility
         * baseline for the serialized form of Swing objects.
         */
	protected abstract static class MacComboBoxAbstractArrowBorder extends AbstractBorder
	{
		static final int arrowBorderSize = 3;

		static final int topBotRight = 0;
		static final int left = 1;
		static final int topLeftIn1 = 2;
		static final int topLeftIn2 = 3;
		static final int botRightIn1 = 4;
		static final int botRightIn2 = 5;

		abstract ImageIcon getIcon(boolean enabled, boolean pressed);

		void getColors(boolean enabled, boolean pressed, Color[] colors) {
			if (enabled) {
				if (pressed) {
					colors[topBotRight] = MacUtilities.GrayscaleAppearanceB;
					colors[left] = MacUtilities.GrayscaleAppearance8;
	
					colors[topLeftIn1] = MacUtilities.GrayscaleAppearance11;
					colors[topLeftIn2] = MacUtilities.GrayscaleAppearance10;
					colors[botRightIn1] = MacUtilities.GrayscaleAppearance7;
					colors[botRightIn2] = MacUtilities.GrayscaleAppearance8;
				}
				else {
					colors[topBotRight] = MacUtilities.GrayscaleAppearanceB;
					colors[left] = MacUtilities.GrayscaleAppearance5;
	
					colors[topLeftIn1] = MacUtilities.GrayscaleAppearance2;
					colors[topLeftIn2] = MacUtilities.GrayscaleAppearanceW;
					colors[botRightIn1] = MacUtilities.GrayscaleAppearance8;
					colors[botRightIn2] = MacUtilities.GrayscaleAppearance5;
				}
			}
			else {
				colors[topBotRight] = MacUtilities.GrayscaleAppearance7;
				colors[left] = MacUtilities.GrayscaleAppearance5;

				colors[topLeftIn1] =
				colors[topLeftIn2] =
				colors[botRightIn1] =
				colors[botRightIn2] = MacUtilities.GrayscaleAppearance2;
			}
		}

		public void paintBorder(Component c, Graphics g, int x, int y, int width, int height)
		{
			ButtonModel model = ((AbstractButton)c).getModel();
			boolean enabled = model.isEnabled();
			boolean pressed = model.isPressed();
			
			g.translate(x, y);

			Color colors[] = new Color[6];
			getColors(enabled, pressed, colors);
			
			ImageIcon icon = getIcon(enabled, pressed);

			// Draw the corners
			paintButtonCorners(c, g, icon, new Point(0, 0), new Dimension(width, height));
		
			//Draw the lines
			Color oldColor = g.getColor();	

			int w = width - 1;
			int h = height - 1;

			//	Outside line
			g.setColor(colors[topBotRight]);
			g.drawLine(arrowBorderSize, 0, w - arrowBorderSize, 0);				// Top
			g.drawLine(w, arrowBorderSize, w, h - arrowBorderSize);				// Right
			g.drawLine(arrowBorderSize, h, w - arrowBorderSize, h);				// Bottom
			
			g.setColor(colors[left]);
			g.drawLine(0, arrowBorderSize, 0, h - arrowBorderSize);				// Left

			//	Inside 1 line
			g.setColor(colors[topLeftIn1]);
			g.drawLine(arrowBorderSize, 1, w - arrowBorderSize, 1);				// Top
			g.drawLine(1, arrowBorderSize, 1, h - arrowBorderSize);				// Left
			g.setColor(colors[botRightIn1]);
			g.drawLine(arrowBorderSize, h - 1, w - arrowBorderSize, h - 1);		// Bottom
			g.drawLine(w - 1, arrowBorderSize, w - 1, h - arrowBorderSize);		// Right

			//	Inside 2 line
			g.setColor(colors[topLeftIn2]);
			g.drawLine(arrowBorderSize, 2, w - arrowBorderSize, 2);				// Top
			g.drawLine(2, arrowBorderSize, 2, h - arrowBorderSize);				// Left
			g.setColor(colors[botRightIn2]);
			g.drawLine(arrowBorderSize, h - 2, w - arrowBorderSize, h - 2);		// Bottom
			g.drawLine(w - 2, arrowBorderSize, w - 2, h - arrowBorderSize);		// Right

			g.setColor(oldColor);

			g.translate(-x, -y);
		}
		public Insets getBorderInsets(Component c)
		{
			return new Insets(arrowBorderSize, arrowBorderSize, arrowBorderSize, arrowBorderSize);
		}
	}
        /**
         * <p>
         * Warning: serialized objects of this class will not be compatible with
         * future swing releases.  The current serialization support is appropriate
         * for short term storage or RMI between Swing1.0 applications.  It will
         * not be possible to load serialized Swing1.0 objects with future releases
         * of Swing.  The JDK1.2 release of Swing will be the compatibility
         * baseline for the serialized form of Swing objects.
         */
	protected static class MacComboBoxArrowBorder extends MacComboBoxAbstractArrowBorder
	{
		static ImageIcon comboBoxEnabledArrowBorder = null;
		static ImageIcon comboBoxPressedArrowBorder = null;
		static ImageIcon comboBoxDisabledArrowBorder = null;

		public MacComboBoxArrowBorder() {
			if (comboBoxEnabledArrowBorder == null)
			{
				comboBoxEnabledArrowBorder = (ImageIcon) UIManager.getIcon("ComboBoxArrowBorder.enabled");
				comboBoxPressedArrowBorder = (ImageIcon) UIManager.getIcon("ComboBoxArrowBorder.pressed");
				comboBoxDisabledArrowBorder = (ImageIcon) UIManager.getIcon("ComboBoxArrowBorder.disabled");
			}
		}

		ImageIcon getIcon(boolean enabled, boolean pressed) {
			if (enabled)
				if (pressed)
					return comboBoxPressedArrowBorder;
				else
					return comboBoxEnabledArrowBorder;
			else
				return comboBoxDisabledArrowBorder;
		}
	}
        /**
         * <p>
         * Warning: serialized objects of this class will not be compatible with
         * future swing releases.  The current serialization support is appropriate
         * for short term storage or RMI between Swing1.0 applications.  It will
         * not be possible to load serialized Swing1.0 objects with future releases
         * of Swing.  The JDK1.2 release of Swing will be the compatibility
         * baseline for the serialized form of Swing objects.
         */
	protected static class MacEditableComboBoxArrowBorder extends MacComboBoxAbstractArrowBorder
	{
		static ImageIcon comboBoxEnabledArrowBorder = null;
		static ImageIcon comboBoxPressedArrowBorder = null;
		static ImageIcon comboBoxDisabledArrowBorder = null;

		public MacEditableComboBoxArrowBorder() {
			if (comboBoxEnabledArrowBorder == null)
			{
				comboBoxEnabledArrowBorder = (ImageIcon) UIManager.getIcon("ComboBoxEditArrowBorder.enabled");
				comboBoxPressedArrowBorder = (ImageIcon) UIManager.getIcon("ComboBoxEditArrowBorder.pressed");
				comboBoxDisabledArrowBorder = (ImageIcon) UIManager.getIcon("ComboBoxEditArrowBorder.disabled");
			}
		}

		ImageIcon getIcon(boolean enabled, boolean pressed) {
			if (enabled)
				if (pressed)
					return comboBoxPressedArrowBorder;
				else
					return comboBoxEnabledArrowBorder;
			else
				return comboBoxDisabledArrowBorder;
		}

		void getColors(boolean enabled, boolean pressed, Color[] colors) {
			super.getColors(enabled, pressed, colors);
			colors[left] = colors[topBotRight];
		}
	}
}
