/*
 * @(#)MacBevelBorder.java	1.5 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Color;
import java.awt.Graphics;

/**
 * @version @(#)MacBevelBorder.java	1.0 12/5/97
 * @author Symantec
 */

class MacBevelBorder extends AbstractBorder implements UIResource
{
	private Color darkShadow = UIManager.getColor("controlShadow");
	private Color lightShadow = UIManager.getColor("controlLtHighlight");
	private boolean isRaised;
	
	public MacBevelBorder(boolean isRaised)
	{
		this.isRaised = isRaised;
	}
	
	public void paintBorder(Component c, Graphics g, int x, int y, int w, int h)
	{
		g.setColor((isRaised) ? lightShadow : darkShadow);
		g.drawLine(x, y, x+w-1, y);           // top
		g.drawLine(x, y+h-1, x, y+1);         // left
		
		g.setColor((isRaised) ? darkShadow : lightShadow);
		g.drawLine(x+1, y+h-1, x+w-1, y+h-1); // bottom
		g.drawLine(x+w-1, y+h-1, x+w-1, y+1); // right
	}
	
	public Insets getBorderInsets(Component c)
	{ 
		return new Insets(1, 1, 1, 1);
	}
	
	public boolean isOpaque(Component c)
	{
		return true;
	}
}
