/*
 * @(#)MacAutoRepeatButton.java	1.3 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;

/**
 * This button repeatedly fires action events when it is 
 * held down.
 *
 * @version 1.0 01/20/98
 */
class MacAutoRepeatButton extends JButton {

  Timer timer = new Timer(30, null);
  
  public MacAutoRepeatButton (Icon icon) {
      super(icon);
      timer.setInitialDelay( 125 );
  }

  public MacAutoRepeatButton() {
      super();
      timer.setInitialDelay( 125 );
  }

  public void addActionListener(ActionListener l ) {
      super.addActionListener(l);
      timer.addActionListener(l);
  }

  public void removeActionListener(ActionListener l ) {
      super.removeActionListener(l);
      timer.removeActionListener(l);
  }

  public void setRepeatInterval(int interval) {
      timer.setDelay(interval);
  }

  public int getRepeatInterval() {
      return timer.getDelay();
  }

  protected void processMouseEvent(MouseEvent e) {
    if (e.getID() == e.MOUSE_CLICKED ) {
        super.processMouseEvent(e);
	return;
    }    
    if (e.getID() == e.MOUSE_PRESSED ) {
		model.setArmed(true);
        model.setPressed(true);
		repaint();
        timer.start();
    }
    if (e.getID() == e.MOUSE_RELEASED ||
    	e.getID() == e.MOUSE_EXITED) {
        model.setPressed(false);
		repaint();
        timer.stop();
    }    
  }
}
