/*
 * @(#)MacArrowIcon.java	1.2 98/01/30
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;

import java.io.Serializable;

import com.sun.java.swing.plaf.basic.BasicSpinnerUI;
import com.sun.java.swing.plaf.basic.Spinner;



/**
 * An icon that draws an up or down arrow.
 *
 * @version 1.0 01/20/98
 */
public class MacArrowIcon implements Icon {

    private boolean up = true;
	
    public MacArrowIcon(boolean up) {
        this.up = up;
    }
    
   /**
     * Paints the arrow
     */
    public void paintIcon(Component c, Graphics g, int x, int y)
		{
        g.setColor(Color.black);
        g.translate((x),y+1);

		if (up) 
			{
			g.drawLine(0,-2,0,-2);
			g.drawLine(-1,-1,1,-1);
			g.drawLine(-2, 0, 2,0);
			g.drawLine(-3, 1, 3, 1);
			} 
		else
			{
			g.drawLine(0,1,0,1);
			g.drawLine(-1,0,1,0);
			g.drawLine(-2, -1, 2,-1);
			g.drawLine(-3, -2, 3, -2);
			}

		g.translate(-(x), -(y+1));
	    }
    
    /**
     * stubbed to satisfy the interface.
     */
    public int getIconWidth() { return 0; }

    /**
     * stubbed to statify the interface.
     */
    public int getIconHeight()  { return 0; }

}

