/*
 * @(#)AppearanceFilter.java	1.2 98/01/30
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.UIDefaults;
import com.sun.java.swing.plaf.ColorUIResource;
import java.awt.image.RGBImageFilter;

/*
	AppearanceFilter

	Worker class for using the various appearance themes.

	Every appearance theme has a table of 8 colors that replace the various
	grayscale colors.
	
	
	Initialization:
		call
			AppearanceFilter.setAppearance("Lavender", uiDefaults); (or another name)
	
	
	Simple Usage:
		Load the images and colors that a component uses.
		For images that need to be tinted with the accent colors,
			for example the scrollbar thumb, use

			AppearanceFilter.FilterImageIcon(scrollbar, 		// JComponent
											scrollBoxEnabled);	// ImageIcon

		For colors that need to be tinted with the accent colors,
			for example the progressbar content area, use

			progressBarInner1 = AppearanceFilter.FilterColor(UIManager.getColor("ProgressBar.inner1"));


	Complex Usage:
		For components that use different accent mappings for the grayscale colors,
			you need to create your own subclass of AppearanceFilter that overrides
			filterRGB(), and invoke its methods instead of the static AppearanceFilter methods.

		class MySpecialAppearanceFilter extends AppearanceFilter {
			public int filterRGB(int x, int y, int rgb) {
				if (rgb == GS1)
					return appearance.getAppearanceColor(4);
				if (rgb == GS3)
					return appearance.getAppearanceColor(5);
				if (rgb == GS5)
					return appearance.getAppearanceColor(6);
				if (rgb == GS8)
					return appearance.getAppearanceColor(7);
				if (rgb == GS10)
					return appearance.getAppearanceColor(0);
				return rgb;
			}

		MySpecialAppearanceFilter myAppearance = new MySpecialAppearanceFilter();

		myAppearance.FilterImageIcon(scrollbar, 		// JComponent
									scrollBoxEnabled);	// ImageIcon

	
	T.B.D.: the black & white theme has no colors
*/


public class AppearanceFilter extends java.awt.image.RGBImageFilter {
	protected static final int GSB	= MacUtilities.GrayscaleAppearanceB.getRGB();
	protected static final int GSW	= MacUtilities.GrayscaleAppearanceW.getRGB();
	protected static final int GS1	= MacUtilities.GrayscaleAppearance1.getRGB();
	protected static final int GS2	= MacUtilities.GrayscaleAppearance2.getRGB();
	protected static final int GS3	= MacUtilities.GrayscaleAppearance3.getRGB();
	protected static final int GS4	= MacUtilities.GrayscaleAppearance4.getRGB();
	protected static final int GS5	= MacUtilities.GrayscaleAppearance5.getRGB();
	protected static final int GS6	= MacUtilities.GrayscaleAppearance6.getRGB();
	protected static final int GS7	= MacUtilities.GrayscaleAppearance7.getRGB();
	protected static final int GS8	= MacUtilities.GrayscaleAppearance8.getRGB();
	protected static final int GS9	= MacUtilities.GrayscaleAppearance9.getRGB();
	protected static final int GS10	= MacUtilities.GrayscaleAppearance10.getRGB();
	protected static final int GS11	= MacUtilities.GrayscaleAppearance11.getRGB();
	protected static final int GS12	= MacUtilities.GrayscaleAppearance12.getRGB();
	protected static final int GSA1	= MacUtilities.GrayscaleAppearanceA1.getRGB();
	protected static final int GSA2	= MacUtilities.GrayscaleAppearanceA2.getRGB();

	
	protected static Appearance appearance = null;
	public static AppearanceFilter defaultAppearanceFilter = null;

	public AppearanceFilter() {
		// The filter's operation does not depend on the
		// pixel's location, so IndexColorModels can be
		// filtered directly.
		canFilterIndexColorModel = true;
	}
	
	public static final void setAppearance(AppearanceFilter.Appearance appearance, UIDefaults table) {
		AppearanceFilter.appearance = appearance;
		if (defaultAppearanceFilter == null)
			defaultAppearanceFilter = new AppearanceFilter();
			
		// Fill the ui defaults table with filtered grayscale colors
		Object[] accentAppearanceColors =
		{
			"AccentAppearance1",		MacUtilities.GrayscaleAppearance1,
			"AccentAppearance2",		MacUtilities.GrayscaleAppearance2,
			"AccentAppearance3",		MacUtilities.GrayscaleAppearance3,
			"AccentAppearance4",		MacUtilities.GrayscaleAppearance4,
			"AccentAppearance5",		MacUtilities.GrayscaleAppearance5,
			"AccentAppearance6",		MacUtilities.GrayscaleAppearance6,
			"AccentAppearance7",		MacUtilities.GrayscaleAppearance7,
			"AccentAppearance8",		MacUtilities.GrayscaleAppearance8,
			"AccentAppearance9",		MacUtilities.GrayscaleAppearance9,
			"AccentAppearance10",		MacUtilities.GrayscaleAppearance10,
			"AccentAppearance11",		MacUtilities.GrayscaleAppearance11,
			"AccentAppearance12",		MacUtilities.GrayscaleAppearance12,
			"AccentAppearanceA1",		MacUtilities.GrayscaleAppearanceA1,
			"AccentAppearanceA2",		MacUtilities.GrayscaleAppearanceA2,
		};

		for(int i = 0; i < accentAppearanceColors.length; i += 2)
			table.put((String) accentAppearanceColors[i], new ColorUIResource(AppearanceFilter.FilterRGB(((java.awt.Color) accentAppearanceColors[i + 1]).getRGB())));
	}

	public static void setAppearance(String appearanceName, UIDefaults table) {
		AppearanceFilter.Appearance appearance;

		try {
			String classname = "com.sun.java.swing.plaf.mac.AppearanceFilter$" + appearanceName.replace(' ', '_') + "Appearance";
			java.lang.Class c = java.lang.Class.forName(classname);
			appearance = (AppearanceFilter.Appearance) c.newInstance();
		}
		catch (Exception e) {
			e.printStackTrace();
			appearance = new AppearanceFilter.LavenderAppearance();
		}
		
		AppearanceFilter.setAppearance(appearance, table);
	}
	
	public static final void FilterImageIcon(java.awt.Component imageComponent, com.sun.java.swing.ImageIcon imageIcon) {
		defaultAppearanceFilter.filterImageIcon(imageComponent, imageIcon);
	}
	
	public static final java.awt.Image FilterImage(java.awt.Component imageComponent, java.awt.Image image) {
		return defaultAppearanceFilter.filterImage(imageComponent, image);
	}
	
	public static final java.awt.Color FilterColor(java.awt.Color color) {
		return defaultAppearanceFilter.filterColor(color);
	}
	public static final int FilterRGB(int rgb) {
		return defaultAppearanceFilter.filterRGB(rgb);
	}


	public final void filterImageIcon(java.awt.Component imageComponent, com.sun.java.swing.ImageIcon imageIcon) {
		imageIcon.setImage(this.filterImage(imageComponent, imageIcon.getImage()));
	}
	
	public final java.awt.Image filterImage(java.awt.Component imageComponent, java.awt.Image image) {
		return imageComponent.createImage(new java.awt.image.FilteredImageSource(image.getSource(), this));
	}
	
	public final java.awt.Color filterColor(java.awt.Color color) {
		return new java.awt.Color(this.filterRGB(0, 0, color.getRGB()));
	}
	public final int filterRGB(int rgb) {
		return this.filterRGB(0, 0, rgb);
	}


	public int filterRGB(int x, int y, int rgb) {
		if (rgb == GS1)
			return appearance.getAppearanceColor(0);
		if (rgb == GS3)
			return appearance.getAppearanceColor(1);
		if (rgb == GS5)
			return appearance.getAppearanceColor(2);
		if (rgb == GS8)
			return appearance.getAppearanceColor(3);
		if (rgb == GS10)
			return appearance.getAppearanceColor(4);
		if (rgb == GS12)
			return appearance.getAppearanceColor(5);
		return rgb;
	}


	public interface Appearance {
		public int getAppearanceColor(int index);
	}

	public interface AquamarineAppearanceColors {
		static final int aquamarineColors[] = new int[] {
															0xffccccff,
															0xff66ffcc,
															0xff00cc99,
															0xff009999,
															0xff006666,
															0xff003333,
															0xff002200,
															0xff000000
														};
	}

	public interface CopperAppearanceColors {
		static final int copperColors[] = new int[] {
															0xffffffcc,
															0xffffcc99,
															0xffff9966,
															0xffcc6633,
															0xff993300,
															0xff660000,
															0xff220000,
															0xff000000
														};
	}

	public interface CrimsonAppearanceColors {
		static final int crimsonColors[] = new int[] {
															0xffffcccc,
															0xffff9999,
															0xffff6666,
															0xffcc3333,
															0xff990000,
															0xff770000,
															0xff440000,
															0xff000000
														};
	}

	public interface EmeraldAppearanceColors {
		static final int emeraldColors[] = new int[] {
															0xffccffcc,
															0xff66ff99,
															0xff33cc66,
															0xff339966,
															0xff006633,
															0xff004400,
															0xff002200,
															0xff000000
														};
	}

	public interface French_BlueAppearanceColors {
		static final int frenchBlueColors[] = new int[] {
															0xffeeeeee,
															0xffccccff,
															0xff9999cc,
															0xff666699,
															0xff333366,
															0xff000022,
															0xff000011,
															0xff000000
														};
	}

	public interface GoldAppearanceColors {
		static final int goldColors[] = new int[] {
															0xffffff99,
															0xffffff00,
															0xffcccc00,
															0xff999900,
															0xff666600,
															0xff333300,
															0xff111111,
															0xff000000
														};
	}

	public interface IvyAppearanceColors {
		static final int ivyColors[] = new int[] {
															0xffccffcc,
															0xff99cc99,
															0xff669966,
															0xff336633,
															0xff003300,
															0xff002200,
															0xff001100,
															0xff000000
														};
	}

	public interface LavenderAppearanceColors {
		static final int lavenderColors[] = new int[] {
															0xffeeeeee,
															0xffccccff,
															0xff9999ff,
															0xff6666cc,
															0xff333399,
															0xff000088,
															0xff000055,
															0xff000000
														};
	}

	public interface LimeAppearanceColors {
		static final int limeColors[] = new int[] {
															0xffffffcc,
															0xffccff66,
															0xff99cc66,
															0xff669900,
															0xff336600,
															0xff004400,
															0xff003300,
															0xff000000
														};
	}

	public interface MagentaAppearanceColors {
		static final int magentaColors[] = new int[] {
															0xffffccff,
															0xffff99ff,
															0xffcc66cc,
															0xff993399,
															0xff660066,
															0xff330033,
															0xff220000,
															0xff000000
														};
	}

	public interface NutmegAppearanceColors {
		static final int nutmegColors[] = new int[] {
															0xffffffcc,
															0xffffcc99,
															0xffcc9966,
															0xff996633,
															0xff663300,
															0xff220000,
															0xff110000,
															0xff000000
														};
	}

	public interface OliveAppearanceColors {
		static final int oliveColors[] = new int[] {
															0xffffffcc,
															0xffcccc99,
															0xff999966,
															0xff666633,
															0xff333300,
															0xff002200,
															0xff001100,
															0xff000000
														};
	}

	public interface PlumAppearanceColors {
		static final int plumColors[] = new int[] {
															0xffffccff,
															0xffcc99cc,
															0xff996699,
															0xff663366,
															0xff330033,
															0xff220000,
															0xff110000,
															0xff000000
														};
	}
	public interface RoseAppearanceColors {
		static final int roseColors[] = new int[] {
															0xffeeeeee,
															0xffffcccc,
															0xffcc9999,
															0xff996666,
															0xff663333,
															0xff440000,
															0xff220000,
															0xff000000
														};
	}
	public interface SapphireAppearanceColors {
		static final int sapphireColors[] = new int[] {
															0xffeeeeee,
															0xff99ccff,
															0xff6699ff,
															0xff3366ff,
															0xff0033cc,
															0xff000099,
															0xff000055,
															0xff000000
														};
	}
	public interface SilverAppearanceColors {
		static final int silverColors[] = new int[] {
															0xffeeeeee,
															0xffcccccc,
															0xffaaaaaa,
															0xff777777,
															0xff555555,
															0xff333333,
															0xff222222,
															0xff000000
														};
	}
	public interface TealAppearanceColors {
		static final int tealColors[] = new int[] {
															0xffeeeeee,
															0xff99cccc,
															0xff669999,
															0xff336666,
															0xff003333,
															0xff002200,
															0xff001100,
															0xff000000
														};
	}
	public interface TurquoiseAppearanceColors {
		static final int turquoiseColors[] = new int[] {
															0xffccffff,
															0xff66ffff,
															0xff00ccff,
															0xff0099cc,
															0xff006699,
															0xff003366,
															0xff000022,
															0xff000000
														};
	}

	public static class AquamarineAppearance implements Appearance, AquamarineAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return aquamarineColors[index];
		}
	}

	public static class CopperAppearance implements Appearance, CopperAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return copperColors[index];
		}
	}

	public static class CrimsonAppearance implements Appearance, CrimsonAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return crimsonColors[index];
		}
	}

	public static class EmeraldAppearance implements Appearance, EmeraldAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return emeraldColors[index];
		}
	}

	public static class French_BlueAppearance implements Appearance, French_BlueAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return frenchBlueColors[index];
		}
	}

	public static class GoldAppearance implements Appearance, GoldAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return goldColors[index];
		}
	}

	public static class IvyAppearance implements Appearance, IvyAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return ivyColors[index];
		}
	}

	public static class LavenderAppearance implements Appearance, LavenderAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return lavenderColors[index];
		}
	}

	public static class LimeAppearance implements Appearance, LimeAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return limeColors[index];
		}
	}

	public static class MagentaAppearance implements Appearance, MagentaAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return magentaColors[index];
		}
	}

	public static class NutmegAppearance implements Appearance, NutmegAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return nutmegColors[index];
		}
	}
	public static class OliveAppearance implements Appearance, OliveAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return oliveColors[index];
		}
	}
	public static class PlumAppearance implements Appearance, PlumAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return plumColors[index];
		}
	}
	public static class RoseAppearance implements Appearance, RoseAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return roseColors[index];
		}
	}
	public static class SapphireAppearance implements Appearance, SapphireAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return sapphireColors[index];
		}
	}
	public static class SilverAppearance implements Appearance, SilverAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return silverColors[index];
		}
	}
	public static class TealAppearance implements Appearance, TealAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return tealColors[index];
		}
	}
	public static class TurquoiseAppearance implements Appearance, TurquoiseAppearanceColors
	{
		public int getAppearanceColor(int index) {
			return turquoiseColors[index];
		}
	}
}
