/*
 * @(#)ActivationHelper.java	1.3 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import java.awt.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;

/**
 * @version @(#)ActivationHelper.java	1.0 1/21/98
 * @author Symantec
 * @author Levi Brown
 * @author Craig Conner
 */

class ActivationHelper extends JComponent
{
	protected Window				parentWindow;
	protected MacAncestorListener	ancestorListener;
	protected boolean				activated;
	protected JComponent			c;
	
	public ActivationHelper()
	{
		parentWindow	= null;
		activated		= false;
		c				= null;
		
	    //set up listener so we know when addNotify and removeNotify are called
	    ancestorListener = new MacAncestorListener();
	}

	public ActivationHelper(JComponent c)
	{
		this();
		setComponent(c);
	}
	
	public void finalize()
	{
		setComponent(null);
	}
	
	public void setComponent(JComponent c)
	{
		if(this.c != null)
		{
		    this.c.removeAncestorListener(ancestorListener);
		}

		this.c = c;

		if(this.c != null)
		{
		    this.c.addAncestorListener(ancestorListener);
		}
	}
	
	public JComponent getComponent()
	{
		return c;
	}
	
	public boolean isActivated()
	{
		return activated;
	}

    protected void setActivated(boolean activated)
	{
		boolean oldValue = this.activated;
		
		this.activated = activated;

        firePropertyChange("activated", oldValue, activated);
	}
	
    class MacAncestorListener implements com.sun.java.swing.event.AncestorListener
	{
		MacWindowAdapter macWindowAdapter;
		
		/**
	     * Called when the source or one of its ancestors is made visible
	     * either by setVisible(true) being called or by its being
	     * added to the component hierarchy.  The method is only called
	     * if the source has actually become visible.  For this to be true
	     * all its parents must be visible and it must be in a hierarchy
	     * rooted at a Window
	     */
	    public void ancestorAdded(com.sun.java.swing.event.AncestorEvent event)
	    {
	    	Component parent = null;
	    	int hHeight = 0, vWidth = 0;
	    	
	    	Object object = event.getSource();
	    	if(object == c )
	    		 parent = c.getParent();
	    	
        		while((parent != null) && (!(parent instanceof Window)))
        			parent = parent.getParent();
        			
        		
			if(parent != null)
	        {
	        	parentWindow = (Window)parent;
	        	
	        	macWindowAdapter = new MacWindowAdapter();
	        	parentWindow.addWindowListener(macWindowAdapter);
	        }
		}
	
	    /**
	     * Called when the source or one of its ancestors is made invisible
	     * either by setVisible(false) being called or by its being
	     * remove from the component hierarchy.  The method is only called
	     * if the source has actually become invisible.  For this to be true
	     * at least one of its parents must by invisible or it is not in
	     * a hierarchy rooted at a Window
	     */
	    public void ancestorRemoved(com.sun.java.swing.event.AncestorEvent event)
	    {
	    	if(parentWindow != null)
	    		parentWindow.removeWindowListener(macWindowAdapter);
	    }
	
	    /**
	     * Called when either the source or one of its ancestors is moved.
	     */
	    public void ancestorMoved(com.sun.java.swing.event.AncestorEvent event)
	    {
	    }
	}
	
    class MacWindowAdapter extends java.awt.event.WindowAdapter
	{
		public void windowDeactivated(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == parentWindow)
				ParentWindow_WindowDeactivated(event);
		}

		public void windowActivated(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == parentWindow)
				ParentWindow_WindowActivated(event);
		}
	}

	void ParentWindow_WindowActivated(java.awt.event.WindowEvent event)
	{
		setActivated(true);
	}

	void ParentWindow_WindowDeactivated(java.awt.event.WindowEvent event)
	{
		setActivated(false);
	}
}
