/*
 * @(#)StringSpinner.java	1.13 02/16/98
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.basic;

import java.awt.*;
import java.awt.event.*;
import java.io.*;


/**
 * A typein field for an integer, where the integers are named.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 * <p>
 * For the keyboard keys used by this component in the standard Look and
 * Feel (L&F) renditions, see the
 * <a href="doc-files/Key-Index.html#JStringSpinner">JStringSpinner</a> key assignments.
 * <b>Note:</b> The link above is only a placeholder. It will not be valid
 *              until this component is released.
 *
 * @author James Gosling
 */
public class StringSpinner extends Spinner {
    private String names[];
    private String typed = null;

    public StringSpinner(int init, String t, String[] names) {
        super(init, t);
        this.names = names;
        setMinimum(0);
        setMaximum(names.length-1);
        setWrap(true);
        updateUI();
    }

//     public Dimension getMinimumSize() {
//         if (d == null) {
//             fm = getFontMetrics(getFont());
//             int w = 0;
//             for (int i = names.length; --i>=0; ) {
//                 int tw = fm.stringWidth(names[i]);
//                 if (tw>w) w = tw;
//             }
//             if (txt!=null) w+=fm.stringWidth(txt);
//             d = new Dimension(w+8, fm.getHeight()+8);
//             ascent = fm.getAscent();
//         }
//         return d;
//     }
    public String[] getNameArray() {return names;}

    public String getValueName() {return names[value];}

    public String getTypedString() {return typed;}


//     protected void  processKeyEvent(KeyEvent e){
//         if (e.getID() != e.KEY_PRESSED) return;
//         if (e.isActionKey())
//             switch(e.getKeyCode()) {
//              case e.VK_DOWN:    setValue(value-1); break;
//                 case e.VK_UP:      setValue(value+1); break;
//             }
//         else {
//             int c = e.getKeyChar();
//             if (040<c && c<0177) {
//                 typed = typed != null ? typed + (char) c
//                     : String.valueOf((char)c);
//                 resynctyped();
//             }
//             else switch(c) {
//                 case 0177:
//                 case '\b':
//                     if (typed!=null)
//                         if (typed.length()<=0) typed = null;
//                         else typed = typed.substring(0,typed.length()-1);
//                     resynctyped();
//                     break;
//             }
//         }
//         return;
//     }
    private void resynctyped() {
        if (typed==null) {
          //setValue(0);
          //repaint();
        } else {
            int len = typed.length();
            for(int i = 0; i<names.length; i++)
                if (typed.regionMatches(true,0,names[i],0,len)) {
                    setValue(i);
                    repaint();
                    return;
                }
            if (len>1) typed = typed.substring(0,len-1);
            else typed = null;
            resynctyped();
        }
    }
//     public void paint(Graphics g) {
//         if (d == null) getMinimumSize(); //Force computation of ascent

//      g.setColor(Color.white);
//      g.drawRect(0,0,d.width-1,d.height-1);
//      g.setColor(Color.black);
//      g.drawLine(0,0,0,d.height-1);
//      g.drawLine(1,0,1,d.height-3); 
//      g.drawLine(1,0,d.width,0);
//      g.drawLine(1,1,d.width-2,1);
//      g.setColor(Color.white);
//      g.fillRect(3,3,d.width-5,d.height-5);


//      if (haveFocus) 
//        {
//          g.setColor(new Color(0,0,150));
//          g.fillRect(4, 4, d.width-7, d.height-7);
//          g.setColor(Color.white);
//        }
//      else
//        {
//          g.setColor(Color.black);
//        }
//      String s = names[value];
//      if (txt != null) s += txt;
//         if (typed==null)
//        {
//          g.drawString(s, 4, ascent + 4);
//        }
//      else 
//        {
//             g.setColor(Color.lightGray);
//             g.drawString(s, 4, ascent+4);
//             g.setColor(Color.white);
//             g.drawString(s.substring(0,typed.length()), 4, ascent+4);
//        }
//     }

//     protected void processFocusEvent(FocusEvent e){
//         typed = null;
//         super.processFocusEvent(e);
//     }

  public void keyPressed(KeyEvent e)
  {
    if (e.isActionKey())
      switch(e.getKeyCode()) {
      case e.VK_DOWN:    setValue(value-1); break;
      case e.VK_UP:      setValue(value+1); break;
      }
    else {
      int c = e.getKeyChar();
      if (040<c && c<0177) {
        typed = typed != null ? typed + (char) c
          : String.valueOf((char)c);
        resynctyped();
      }
      else switch(c) {
      case 0177:
      case '\b':
        if (typed!=null)
          if (typed.length()<=0) typed = null;
          else typed = typed.substring(0,typed.length()-1);
        resynctyped();
        break;
      }
    }
    return;
  }
 
  public void focusGained(FocusEvent e) 
  {
    typed = null;
    repaint();
    super.focusGained(e);
  }
  public void focusLost(FocusEvent e)
  {
    typed = null;
    repaint();
    super.focusLost(e);
  }
}
