/*
 * @(#)Spinner.java	1.19 02/16/98
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.basic;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;


/**
 * A typein field for an integer.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 * <p>
 * For the keyboard keys used by this component in the standard Look and
 * Feel (L&F) renditions, see the
 * <a href="doc-files/Key-Index.html#JSpinner">JSpinner</a> key assignments.
 * <b>Note:</b> The link above is only a placeholder. It will not be valid
 *              until this component is released.
 *
 * @author James Gosling
 */
public class Spinner extends JComponent implements Adjustable, AdjustmentListener, 
                                                   FocusListener, KeyListener, MouseListener
{
  protected String txt;
  protected Dimension d;
  protected int ascent;
  protected int value;
  protected boolean haveFocus = false;
  protected int minValue = 0;
  protected int maxValue = 0x7FFFFF;
  protected FontMetrics fm;
  protected int nDigits = 4;
  protected int digitsTyped = 0;
  protected boolean wraps = false;
  protected boolean borderPainted = false;
  protected Color backgroundColor = Color.white;
  protected int leadingPad = -1;
  
  public boolean wrapped= false;

  public Spinner(int startValue, String t) {
//     txt = t;
//     value = init;
//     enableEvents(AWTEvent.FOCUS_EVENT_MASK
//               |AWTEvent.KEY_EVENT_MASK|AWTEvent.MOUSE_EVENT_MASK);
//     updateUI();
    init(startValue,t);
  }
  public Spinner(int startValue) {
//     value = init;
//     enableEvents(AWTEvent.FOCUS_EVENT_MASK
//               |AWTEvent.KEY_EVENT_MASK|AWTEvent.MOUSE_EVENT_MASK);
//     updateUI();
    init(startValue,null);
  }

  private void init(int startValue, String t)
  {
    txt = t;
    value = startValue;
    addFocusListener(this);
    addMouseListener(this);
    addKeyListener(this);
    updateUI();
  }
  
  
  /**
   * Gets the current value of the Spinner object.
   */
  public int getValue() { return value; }
  
  /**
   * Sets the current value of the Spinner. This
   * value must be within the range defined by the minimum and
   * maximum values for this object.
   * @param v the current value
   */
  public void setValue(int v) {
    if(wraps)
      {
        if((v<minValue) || (v>maxValue)) wrapped = true;
        else wrapped = false;
      }
    while (v < minValue)
      if(wraps) v = maxValue+1-minValue+v;
      else v = minValue;
    while (v > maxValue)
      if(wraps) v = minValue-1+v-maxValue;
      else v = maxValue;
    if (value!=v){
      value = v;
      if (isShowing()) repaint(20);
      fireAdjustmentValueChanged(new AdjustmentEvent
                                      (this, 0, AdjustmentEvent.ADJUSTMENT_VALUE_CHANGED, v));
    }
  }
  /** A Spinner for which wrapping is true wraps around to the minimum
    value when the maximum value is exceeded, and vice versa.
    @param w true if wrapping is to be enabled, false if the
    value is to be clamped. */
  public void setWrap(boolean w) { wraps = w; }
  public boolean getWrap() { return wraps; }
  /** A Spinner can have a string associated with it, which is placed
    at the right of the number
    @param s the new text value */
  public void setText(String s) { txt = s; if(isShowing()) repaint(20); }
  public String getText() { return txt; }
  public void setFont(Font f) {
    if (f != getFont()) {
      super.setFont(f);
      d = null;
      invalidate();
    }
  }
  public void setDigits(int n) { nDigits = n; }
  public int getDigits() { return nDigits; }
  public void setLeadingPad(int newPad) {leadingPad = newPad;}
  public int getLeadingPad() {return leadingPad;}
  public void setBackgroundColor(Color newColor) {backgroundColor = newColor;}
  public Color getBackgroundColor() {return backgroundColor;}
  
//   protected void processFocusEvent(FocusEvent e){
//     if ((e.getID()==e.FOCUS_GAINED)!=haveFocus) {
//       haveFocus = !haveFocus;
//       if(haveFocus)
//      {
//        digitsTyped = 0;
//      }
//       repaint();
//     }
//   }
//   protected void  processKeyEvent(KeyEvent e){
//     if (e.getID() != e.KEY_PRESSED) return;
//     if (e.isActionKey())
//       switch(e.getKeyCode()) {
//       case e.VK_DOWN:    setValue(value-1); break;
//       case e.VK_UP:      setValue(value+1); break;
//       }
//     else {
//       int c = e.getKeyChar();
//       if ('0'<=c && c<='9') {
        
//      if(digitsTyped < nDigits)
//        {
//          if (digitsTyped == 0)
//            {
//              value = 0;
//            }
//          int nv = value*10+c-'0';
//          if ((nv<=maxValue) && (nv>=minValue))
//            {
//              // int M = 10;
//              //            int Mn = 0;
//              //            while ((Mn=M*10)<nv && Mn>M) M = Mn;
//              //            nv = nv%M;
//              setValue(nv);
//              digitsTyped++;
//            }
//        }
//       }
//       else switch(c) {
//       case 0177:
//       case '\b': 
//      if((value/10) >= 1)
//        {
//          setValue(value/10);
//          digitsTyped--;
//        }
//      break;
//       case '-': setValue(-value); break;
//      //case '\t': transferFocus(); break;
//       }
//     }
//     return;
//   }
//   protected void processMouseEvent(MouseEvent e){
//     if (e.getID()==e.MOUSE_PRESSED) requestFocus();
//     return;
//   }
  

  public boolean isFocusTraversable() { return true; }

  public boolean hasFocus() {return haveFocus;}

  public boolean isBorderPainted() {return borderPainted;}

  public void setBorderPainted(boolean b) 
  {
        borderPainted = b;
        invalidate();
  }

    /**
     * Paint the spinner's border if BorderPainted property is true.
     * 
     * @see #paint
     * @see #setBorder
     */
    protected void paintBorder(Graphics g) {    
        if (isBorderPainted()) {
            super.paintBorder(g);
        }
    }

  /** Spinners can both send and recieve AdjustmentEvents -- they
   * can be cascaded together for situations where there are multiple
   * ways to enter the same value (popup menu or typin number) */
  public void adjustmentValueChanged(AdjustmentEvent e) {
    setValue(e.getValue());
  }
  
  /**
   * Sets the minimum value of the Spinner.
   * @param min the minimum value
   */
  public void setMinimum(int min){minValue=min;setValue(value);}
  
  /**
   * Gets the minimum value of the Spinner.
   */
  public int getMinimum(){return minValue;}
  
  /**
   * Sets the maximum value of the Spinner.
   * @param max the maximum value
   */
  public void setMaximum(int max){maxValue=max;setValue(value);}
  
  /**
   * Gets the maximum value of the Spinner.
   */
  public int getMaximum(){return maxValue;}
  
  /**
   * Add a listener to recieve adjustment events when the value of
   * the Spinner changes.
   * @param l the listener to recieve events
   * @see AdjustmentEvent
   */
  public void addAdjustmentListener(AdjustmentListener l){
      listenerList.add(AdjustmentListener.class, l);
  }
  
  /**
   * Removes an adjustment listener.
   * @param l the listener being removed
   * @see AdjustmentEvent
   */
  public void removeAdjustmentListener(AdjustmentListener l){
      listenerList.remove(AdjustmentListener.class, l);
  }
  
    /*
     * Notify all listeners that have registered interest for
     * notification on this event type.  The event instance 
     * is lazily created using the parameters passed into 
     * the fire method.
     * @see EventListenerList
     */
    protected void fireAdjustmentValueChanged(AdjustmentEvent e) {
        // Guaranteed to return a non-null array
        Object[] listeners = listenerList.getListenerList();
        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==AdjustmentListener.class) {
                // Lazily create the event:
                // if (e == null)
                // e = new WindowEvent(this.popup, event.getID());
                ((AdjustmentListener)listeners[i+1]).adjustmentValueChanged(e);
            }          
        }
    }   

  /**
   * Does nothing -- part of the Adjustable interface.
   * @param u the unit increment
   */
  public void setUnitIncrement(int u){};
  
  /**
   * Does nothing -- part of the Adjustable interface.
   */
  public int getUnitIncrement(){return 1;};
  
  /**
   * Does nothing -- part of the Adjustable interface.
   * @param b the block increment
   */
  public void setBlockIncrement(int b){};
  
  /**
   * Does nothing -- part of the Adjustable interface.
   */
  public int getBlockIncrement(){return 1;}
  
  /**
   * Does nothing -- part of the Adjustable interface.
   * @param v the length of the indicator
   */
  public void setVisibleAmount(int v){};
  
  /**
   * Does nothing -- part of the Adjustable interface.
   */
  public int getVisibleAmount(){return 1;}
  
  /**
   * Does nothing -- part of the Adjustable interface.
   */
  public int getOrientation(){return HORIZONTAL;};

  public void keyTyped(KeyEvent e) {}
  public void keyPressed(KeyEvent e)
  {
    if (e.isActionKey())
      switch(e.getKeyCode()) {
      case e.VK_DOWN:    setValue(value-1); break;
      case e.VK_UP:      setValue(value+1); break;
      }
    else {
      int c = e.getKeyChar();
      if ('0'<=c && c<='9') {
        
        if(digitsTyped < nDigits)
          {
            if (digitsTyped == 0)
              {
                value = 0;
              }
            int nv = value*10+c-'0';
            if ((nv<=maxValue) && (nv>=minValue))
              {
                // int M = 10;
                //            int Mn = 0;
                //            while ((Mn=M*10)<nv && Mn>M) M = Mn;
                //            nv = nv%M;
                setValue(nv);
                digitsTyped++;
              }
          }
      }
      else switch(c) {
      case 0177:
      case '\b': 
        setValue(value/10);
        digitsTyped--;
        break;
      case '-': setValue(-value); break;
        //case '\t': transferFocus(); break;
      }
    }
    return;
  }
  public void keyReleased(KeyEvent e){}
  public void mouseClicked(MouseEvent e) {}
  public void mousePressed(MouseEvent e) 
  {
    requestFocus();
    return;
  }
  public void mouseReleased(MouseEvent e) {}
  public void mouseEntered(MouseEvent e) {}
  public void mouseExited(MouseEvent e) {}
  public void focusGained(FocusEvent e) 
  {
    haveFocus = true;
    digitsTyped = 0;
    repaint();
  }
  public void focusLost(FocusEvent e)
  {
    haveFocus = false;
    repaint();
  }



    
  public SpinnerUI getUI() {
    return (SpinnerUI)ui;
  }
     
  public void setUI(SpinnerUI ui) {
    super.setUI(ui);
  }

  public void updateUI() 
  {
    setUI((SpinnerUI)UIManager.getUI(this));
  }

    /**
     * @return "SpinnerUI"
     * @see JComponent#getUIClassID
     * @see UIDefaults#getUI
     */
    public String getUIClassID() {
        return "SpinnerUI";
    }
}
