/*
 * @(#)ComboPopup.java	1.2 98/04/10
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.basic;

import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.KeyListener;


/**
 * The interface which defines the kind of popup menu that BasicComboBoxUI requires.
 * Classes that implement this interface don't have to extend JPopupMenu.  This interface
 * demands very little so alternatives to JPopupMenu can be used.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.2 04/10/98
 * @author Tom Santos
 */
public interface ComboPopup {
    /**
     * Shows and hides the popup.
     */
    //public void setVisible( boolean isVisible );

    public void show();
    public void hide();

    /**
     * Returns whether or not the popup is visible
     */
    public boolean isVisible();

    /**
     * Returns a mouse listener that shows and hides the popup.
     */
    public MouseListener getMouseListener();

    /**
     * Returns a mouse motion listener that makes the popup act like a menu.
     */
    public MouseMotionListener getMouseMotionListener();

    /**
     * Returns a key listener that shows and hides the popup.
     */
    public KeyListener getKeyListener();

    /**
     * Called to inform the ComboPopup that the UI is uninstalling.
     * If the ComboPopup added any listeners in the component, it should remove them here.
     */
    public void uninstallingUI(); 
}
