/*
 * @(#)BasicVisibleTreeNode.java	1.6 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.*;
import com.sun.java.swing.tree.*;
import com.sun.java.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.util.*;
import com.sun.java.swing.plaf.*;

/**
 * BasicVisibleTreeNode extends VisibleTreeNode to stop editing
 * whenever nodes are added/removed and to redisplay when collapsing/
 * expanding the node.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.6 02/02/98
 * @author Rob Davis
 * @author Ray Ryan
 * @author Scott Violet
 */
public class BasicVisibleTreeNode extends VisibleTreeNode {
    protected BasicVisibleTreeNode(AbstractTreeUI treeUI, Object value,
				   int index) {
	super(treeUI, value, index);
    }

    /**
     * Repaints the receiver by messaging the TreeUI with repaintNode.
     */
    public void repaint() {
	((BasicTreeUI)treeUI).repaintNode(this);
    }

    /**
     * Messages the BasicTreeUI the receiver was crated for to stop
     * editing.
     */
    public void cancelEditing() {
	((BasicTreeUI)treeUI).completeEditing(false, true, false);
    }

    /**
     * If the node is visible, it is repainted.
     */
    public void modelChildCountChanged() {
	if(getRow() != -1)
	    repaint();
    }

    /**
     * Stops editing, repaints the node if only 1 child and messages
     *  super.
     */
    public void insert(MutableTreeNode newChild, int childIndex) {
	cancelEditing();
	super.insert(newChild, childIndex);
	if(getChildCount() == 1 && getRow() != -1)
	    repaint();
    }

    /**
     * Stops editing, repaints if no children, and messages super.
     */
    public void remove(int childIndex) {
	cancelEditing();
	super.remove(childIndex);
	if(getModelChildCount() == 0 && getRow() != -1)
	    repaint();
    }

    /**
     * Stops editing messages super and repaints this node if
     * there are no children.
     */
    protected void collapse(boolean adjustTree) {
	cancelEditing();
	super.collapse(adjustTree);
	if(adjustTree && (children == null || children.size() == 0))
	    repaint();
    }

    /**
     * Stops editing messages super and repaints this node if
     * there are no children.
     */
    protected void expand(boolean adjustTree) {
	cancelEditing();
	super.expand(adjustTree);
	if(adjustTree && (children == null || children.size() == 0))
	    repaint();
    }

}
