/*
 * @(#)BasicTreeCellEditor.java	1.12 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.util.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.tree.*;

/**
 * BasicTreeCellEditor starts editing on triple clicks, or on
 * click-pause-click-pause (two single clicks, followed by a 
 * delay of 1200 milliseconds).
 * This determines the JTree instance by seeing if one of the
 * editorListeners that is added is the BasicTreeUI, and if it is
 * the JTree is obtained from that. Meaning there isn't really a 
 * good reason for this to be an inner class.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.12 02/02/98
 * @author Scott Violet
 */
public class BasicTreeCellEditor extends BasicTreeCellEditorContainer
	implements ActionListener, TreeSelectionListener
{
    /** Should isCellEditable return true? This is set in configure...
     * based on the value and lastPath. */
    protected boolean     canEdit;
    /** JTree instance listening too. */
    protected JTree       changeTree;
    /** last path that was selected. */
    protected TreePath   lastPath;
    /** Used before starting the editing session. */
    protected Timer      timer;

    public BasicTreeCellEditor(BasicTreeCellRenderer renderer) {
	super(null, renderer);

	/* Boy, it sure would be nice not to have to call super first! */
	JTextField        tf = new JTextField();
	realEditor = new DefaultCellEditor(tf);
	/* One click to edit. */
	((DefaultCellEditor)realEditor).setClickCountToStart(1);
    }

    /**
     * Messages super and sets isCellEditable based on value nast lastPath.
     */
    public Component getTreeCellEditorComponent(JTree tree, Object value,
						boolean isSelected,
						boolean expanded,
						boolean leaf, int row) {
	TreePath        newPath = tree.getPathForRow(row);
	Component	returnValue;

	returnValue = super.getTreeCellEditorComponent(tree, value, isSelected,
						       expanded,leaf, row);
	canEdit = (lastPath != null && newPath != null &&
		   lastPath.equals(newPath));
	if(timer != null) {
	    timer.stop();
	}
	return returnValue;
    }

    /**
     * Returns true for triple clicks, or if isCellEditable is true, or the
     * event is null.
     */
    public boolean isCellEditable(EventObject event) {
	if(event == null || ((event instanceof MouseEvent) &&
			     ((MouseEvent)event).getClickCount() > 2))
	    return super.isCellEditable(event);
	else if(canEdit && ((MouseEvent)event).getClickCount() == 1) {
	    if(timer == null) {
		timer = new Timer(1200, this);
		timer.setRepeats(false);
	    }
	    timer.start();
	}
	return false;
    }

    /**
     * Messages super and setChangeTree.
     */
    public void addCellEditorListener(CellEditorListener l) {
	super.addCellEditorListener(l);
	if(l instanceof BasicTreeUI)
	    setChangeTree(((BasicTreeUI)l).tree);
	else
	    setChangeTree(null);
    }

    /**
     * Messages super and setChangeTree.
     */
    public void removeCellEditorListener(CellEditorListener l) {
	super.removeCellEditorListener(l);
	if(l instanceof BasicTreeUI)
	    setChangeTree(null);
    }

    /**
     * Sets the JTree to listen to to newTree.
     */
    protected void setChangeTree(JTree newTree) {
	if(changeTree != null)
	    changeTree.removeTreeSelectionListener(this);
	changeTree = newTree;
	if(changeTree != null)
	    changeTree.addTreeSelectionListener(this);
	if(timer != null) {
	    timer.stop();
	}
    }

    /**
     * Resets lastPath.
     */
    public void valueChanged(TreeSelectionEvent e) {
	if(changeTree != null) {
	    if(changeTree.getSelectionCount() == 1)
		lastPath = changeTree.getSelectionPath();
	    else
		lastPath = null;
	}
	if(timer != null) {
	    timer.stop();
	}
    }

    /**
     * Messaged when the timer fires, this will start the editing
     * session.
     */
    public void actionPerformed(ActionEvent e) {
	if(changeTree != null && lastPath != null) {
	    changeTree.startEditingAtPath(lastPath);
	}
    }
} // End of BasicTreeCellEditor


