/*
 * @(#)BasicToolTipUI.java	1.22 98/04/06
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing.plaf.basic;

import java.awt.*;
import com.sun.java.swing.*;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.ToolTipUI;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.UIResource;
import java.io.Serializable;


/**
 * Standard tool tip L&F.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.22 04/06/98
 * @author Dave Moore
 */
public class BasicToolTipUI extends ToolTipUI implements Serializable
{
    static BasicToolTipUI sharedInstance = new BasicToolTipUI();

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    public BasicToolTipUI() {
        super();
    }

    public void installUI(JComponent c) {
	installDefaults(c);
	installListeners(c);
    }

    public void uninstallUI(JComponent c) {
	// REMIND: this is NOT getting called
	uninstallDefaults(c);
	uninstallListeners(c);
    }

    protected void installDefaults(JComponent c){
	LookAndFeel.installColorsAndFont(c, "ToolTip.background",
					 "ToolTip.foreground",
					 "ToolTip.font");
        LookAndFeel.installBorder(c, "ToolTip.border");
    }
    
    protected void uninstallDefaults(JComponent c){
	LookAndFeel.uninstallBorder(c);
    }

    protected void installListeners(JComponent c) {
    }

    protected void uninstallListeners(JComponent c) {
    }

    public void paint(Graphics g, JComponent c) {
        Font font = c.getFont();
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        Dimension size = c.getSize();

        g.setColor(c.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(c.getForeground());
        g.setFont(font);
        g.drawString(((JToolTip)c).getTipText(), 3, 2 + metrics.getAscent());
    }

    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
	// fix for bug 4094153
	String tipText = ((JToolTip)c).getTipText();
	if (tipText == null)
	  return new Dimension(6,metrics.getHeight() + 4);
	else
	  return new Dimension(metrics.stringWidth(tipText) + 6,
			       metrics.getHeight() + 4);
    }

    public Dimension getMinimumSize(JComponent c) {
        return getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return getPreferredSize(c);
    }

}
