/*
 * @(#)BasicToggleButtonUI.java	1.38 98/06/23
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
 
package com.sun.java.swing.plaf.basic;

import java.awt.*;
import java.awt.event.*;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;

import java.io.Serializable;

/**
 * BasicToggleButton implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.38 06/23/98
 * @author Jeff Dinkins
 */
public class BasicToggleButtonUI extends ToggleButtonUI implements Serializable {
    private static ToggleButtonUI toggleButtonUI;
    private BasicButtonListener listener;

    // visual constants
    private static final int defaultTextIconGap = 4;
    private final static Insets defaultMargin = new Insets(2,2,2,2);

    protected static Color toggleButtonFocus;

    public static ComponentUI createUI(JComponent b) {
        if(toggleButtonUI == null) {
            toggleButtonUI = new BasicToggleButtonUI();
        }
        return toggleButtonUI;
    }
    
    /**
     * insets and margin
     */

    public Insets getDefaultMargin(AbstractButton b) {
	return defaultMargin;
    }

    public Border getDefaultBorder(AbstractButton b) {
	return UIManager.getBorder("ToggleButton.border");
    }

    public int getDefaultTextIconGap(AbstractButton b) {
	return defaultTextIconGap;
    }


    /**
     * ToggleButtonUI Implementation
     *
     */

    public void installUI(JComponent c) {
      installDefaults((AbstractButton) c);
      installListeners((AbstractButton) c);
      installKeyboardActions((AbstractButton) c);
    }


    protected void installDefaults(AbstractButton b){
      LookAndFeel.installColorsAndFont(b, 
					    "ToggleButton.background", 
					    "ToggleButton.foreground", 
					    "ToggleButton.font");
      LookAndFeel.installBorder(b,"ToggleButton.border");
      toggleButtonFocus = UIManager.getColor("ToggleButton.focus");

    }

    protected void installListeners(AbstractButton b){
        if (listener == null) {
            listener = createListener(b);
        }
        b.addMouseListener(listener);
        b.addMouseMotionListener(listener);
        b.addFocusListener(listener);
        b.addPropertyChangeListener(listener);
        b.addChangeListener(listener);
    }


    protected void installKeyboardActions(AbstractButton b){
	listener.installKeyboardActions(b);
    }

    public void uninstallUI(JComponent c) {
	uninstallKeyboardActions((AbstractButton) c);
	uninstallListeners((AbstractButton) c);
	uninstallDefaults((AbstractButton) c);
    }
    
    protected void uninstallKeyboardActions(AbstractButton b) {
	listener.uninstallKeyboardActions(b);
    }
    
    protected void uninstallListeners(AbstractButton b) {
        b.removeMouseListener(listener);
        b.removeMouseMotionListener(listener);
	b.removeFocusListener(listener);
        b.removeChangeListener(listener);
    }

    protected void uninstallDefaults(AbstractButton b){
	LookAndFeel.uninstallBorder(b);
    }


    protected BasicButtonListener createListener(AbstractButton b) {
	return new BasicButtonListener(b);
    }


    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton) c;
        ButtonModel model = b.getModel();

        Dimension size = b.getSize();
        FontMetrics fm = g.getFontMetrics();

	Insets i = c.getInsets();

        Rectangle viewRect = new Rectangle(size);

	viewRect.x += i.left;
	viewRect.y += i.top;
	viewRect.width -= (i.right + viewRect.x);
	viewRect.height -= (i.bottom + viewRect.y);

        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();

	Font f = c.getFont();
	g.setFont(f);

	// layout the text and icon
        String text = SwingUtilities.layoutCompoundLabel(
	    fm, b.getText(), b.getIcon(),
	    b.getVerticalAlignment(), b.getHorizontalAlignment(),
	    b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
	    viewRect, iconRect, textRect, b.getText() == null ? 0 : defaultTextIconGap
	);


        g.setColor(b.getBackground());

	if (model.isArmed() && model.isPressed() || model.isSelected())
	  {
	    paintButtonPressed(g,b);
	  }

	// Paint the Icon
        if(b.getIcon() != null) { 
	    paintIcon(g, b, iconRect);
        }

	// Draw the Text
        if(text != null && !text.equals("")) {
	    paintText(g, b, textRect, text);
        }
	  
	// draw the dashed focus line.
        if (b.isFocusPainted() && b.hasFocus()) {
	  paintFocus(g, b, viewRect, textRect, iconRect);
	}
    }

    protected void paintIcon(Graphics g, AbstractButton b, Rectangle iconRect) {
	ButtonModel model = b.getModel();
	Icon icon = null;
	
	if(!model.isEnabled()) {
	    icon = (Icon) b.getDisabledIcon();
	} else if(model.isPressed() && model.isArmed()) {
	    icon = (Icon) b.getPressedIcon();
	    if(icon == null) {
		// Use selected icon
		       icon = (Icon) b.getSelectedIcon();
	    } 
	} else if(model.isSelected()) {
	    icon = (Icon) b.getSelectedIcon();
	} else if(b.isRolloverEnabled() && model.isRollover()) {
	    icon = (Icon) b.getRolloverIcon();
	} 
	
	if(icon == null) {
	    icon = (Icon) b.getIcon();
	}
	
	icon.paintIcon(b, g, iconRect.x, iconRect.y);
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text){
	ButtonModel model = b.getModel();

        FontMetrics fm = g.getFontMetrics();

	if(model.isEnabled()) {
	    // *** paint the text normally
		       g.setColor(b.getForeground());
	    BasicGraphicsUtils.drawString(g,text, model.getMnemonic(),
					  textRect.x,
					  textRect.y + fm.getAscent());
	} else {
	    // *** paint the text disabled
		       g.setColor(b.getBackground().brighter());
	    BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
					  textRect.x, textRect.y + fm.getAscent());
	    g.setColor(b.getBackground().darker());
	    BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
					  textRect.x - 1, textRect.y + fm.getAscent() - 1);
	}
    }

    // Basic does nothing - L&F like Motif paint the button's focus
    protected void paintFocus(Graphics g, AbstractButton b,
			      Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    // Basic does nothing - L&F like Motif shade the button
    protected void paintButtonPressed(Graphics g, AbstractButton b){
    }


    public Dimension getPreferredSize(JComponent c) {
	AbstractButton b = (AbstractButton)c;
	return BasicGraphicsUtils.getPreferredButtonSize(b, defaultTextIconGap);
    }


}
