/*
 * @(#)BasicSpinnerUI.java	1.13 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.basic;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;

import java.io.Serializable;


/**
 * BasicSpinner implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.13 02/02/98
 * @author Brian Gerhold
 */
public class BasicSpinnerUI extends SpinnerUI implements Serializable
{
  final static Border defaultBorder = BorderFactory.createLoweredBevelBorder();

  protected Dimension d;
  protected int ascent;
  protected FontMetrics fm;

  // Shared UI object
  protected static SpinnerUI spinnerUI;

  public static ComponentUI createUI(JComponent s) 
  {
    if(spinnerUI == null) {
      spinnerUI = new BasicSpinnerUI();
    }
    return spinnerUI;
  }
  
  public void installUI(JComponent c) 
  {
    c.setFont(BasicGraphicsUtils.controlFont);
    if(c.getBorder() == null)
      c.setBorder(defaultBorder);
  }
  
  public void uninstallUI(JComponent c) 
  {
    c.resetKeyboardActions();
    if(c.getBorder() == defaultBorder)
      c.setBorder(null);
  }
    
  public void paint(Graphics g, JComponent c)
  {
    Spinner spinner = ((Spinner)(c));
    //frosty man, frosty
    getMinimumSize(c); //Force computation of dimension
    Insets bi = spinner.getBorder().getBorderInsets(spinner);
    g.setColor(spinner.getBackgroundColor());
    g.fillRect(bi.left,bi.top,d.width-(bi.left+bi.right),d.height-(bi.top+bi.bottom));    

    //g.setColor(Color.black);
    //g.drawLine(0,0,0,d.height-1);
    //g.drawLine(1,0,1,d.height-3); 
    //g.drawLine(1,0,d.width,0);
    //g.drawLine(1,1,d.width-2,1);
    //g.setColor(Color.white);
    //g.fillRect(3,3,d.width-5,d.height-5);

    if (spinner.hasFocus()) 
      {
       g.setColor(new Color(0,0,150));
       g.fillRect(bi.left+2, bi.top+2, d.width-(bi.left+bi.right+4), d.height-(bi.top+bi.bottom+4));
       g.setColor(Color.white);
      }
    else
      {
	g.setColor(Color.black);
      }
    String s;
    if(spinner instanceof StringSpinner)
      {
	StringSpinner spinner2 = ((StringSpinner)(spinner));
	s = spinner2.getValueName() + (spinner2.getText()!=null ? spinner2.getText() : "");
	if (spinner2.getTypedString()==null)
	  {
	    g.drawString(s, bi.left+2, ascent + bi.top+2);
	  }
	else 
	  {
            g.setColor(Color.lightGray);
            g.drawString(s, bi.left+2, ascent+bi.top+2);
            g.setColor(Color.white);
            g.drawString(s.substring(0,spinner2.getTypedString().length()),bi.left+2 , ascent+bi.top+2);
	  }
      }
    else
      {
	s = Integer.toString(spinner.getValue());
	if(spinner.getLeadingPad() != -1)
	  {
	    int j = spinner.getDigits()-s.length();
	    String lp = Integer.toString(spinner.getLeadingPad());
	    for(int i=0; i<j; i++) { s = lp +s;}
	  }
	s += (spinner.getText()!=null ? spinner.getText() : "");
	g.drawString(s, d.width-fm.stringWidth(s) - bi.right-2, ascent + bi.bottom+2);
      }
  }
 
  public Dimension getPreferredSize(JComponent c) 
  {
    return getMinimumSize(c);
  }
  public Dimension getMaximumSize(JComponent c) 
  {
    return getMinimumSize(c);
  }
  public Dimension getMinimumSize(JComponent c) 
  {
    Spinner s = ((Spinner)(c));
    fm = s.getFontMetrics(s.getFont());
    int w=0;
    if(s instanceof StringSpinner)
      {
	StringSpinner s2 = ((StringSpinner)(s));
	String[] names = s2.getNameArray();
	for (int i = names.length; --i>=0; ) 
	  {
	    int tw = fm.stringWidth(names[i]);
	    if (tw>w) w = tw;
	  }
      }
    else
      {
	w = fm.stringWidth("0")*s.getDigits();
      }
    if (s.getText()!=null) w+=fm.stringWidth(s.getText());
    Insets bi = s.getBorder().getBorderInsets(s);
    d = new Dimension(w+bi.left+bi.right+4, fm.getHeight()+bi.top+bi.bottom+4);
    ascent = fm.getAscent();
    return d;
  }
}
