/*
 * @(#)BasicScrollPaneUI.java	1.35 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Insets;
import java.awt.Graphics;
import java.io.Serializable;


/**
 * A Windows L&F implementation of ScrollPaneUI.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.35 02/02/98
 * @author Hans Muller
 */
public class BasicScrollPaneUI
    extends ScrollPaneUI implements ScrollPaneConstants, Serializable
{
    protected JScrollPane scrollpane;
    protected ChangeListener vsbListener = createVSBListener();
    protected ChangeListener hsbListener = createHSBListener();
    protected ChangeListener viewportListener = createViewportListener();


    public void paint(Graphics g, JComponent c) {
	Border vpBorder = scrollpane.getViewportBorder();
	if (vpBorder != null) {
	    Rectangle r = getSPLayout().getViewportBorderBounds(scrollpane);
	    vpBorder.paintBorder(scrollpane, g, r.x, r.y, r.width, r.height);
	}

    }


    public Dimension getPreferredSize(JComponent c) {
	return getSPLayout().preferredLayoutSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
	return getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
	return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }


    public void installUI(JComponent x)
    {
	scrollpane = (JScrollPane)x;
	scrollpane.setLayout(createLayoutManager());

	JViewport viewport = getViewport();
	JScrollBar vsb = createVerticalScrollBar();
	JScrollBar hsb = createHorizontalScrollBar();

	if (viewport != null) {
	    viewport.addChangeListener(viewportListener);
	}

	vsb.getModel().addChangeListener(vsbListener);
	hsb.getModel().addChangeListener(hsbListener);

	scrollpane.add(vsb, VERTICAL_SCROLLBAR);
	scrollpane.add(hsb, HORIZONTAL_SCROLLBAR);

	LookAndFeel.installBorder(scrollpane, "ScrollPane.border");
	LookAndFeel.installColorsAndFont( x, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        Border vpBorder = scrollpane.getViewportBorder();
        if ((vpBorder == null) ||( vpBorder instanceof UIResource)) {
	    vpBorder = UIManager.getBorder("ScrollPane.viewportBorder");
	    scrollpane.setViewportBorder(vpBorder);
        }

    }


    public void uninstallUI(JComponent x)
    {
	JViewport viewport = getViewport();
	JScrollBar vsb = getVerticalScrollBar();
	JScrollBar hsb = getHorizontalScrollBar();

	scrollpane.removeAll();
	scrollpane.setLayout(null);

	if (viewport != null) {
	    viewport.removeChangeListener(viewportListener);
	}

	if (vsb != null) {
	    vsb.getModel().removeChangeListener(vsbListener);
	}

	if (hsb != null) {
	    hsb.getModel().removeChangeListener(hsbListener);
	}

	LookAndFeel.uninstallBorder(scrollpane);

        if (scrollpane.getViewportBorder() instanceof UIResource) {
            scrollpane.setViewportBorder(null);
        }

	scrollpane = null;
    }


    public static ComponentUI createUI(JComponent x) {
	return new BasicScrollPaneUI();
    }


    protected ScrollPaneLayout getSPLayout() {
	return (ScrollPaneLayout)(scrollpane.getLayout());
    }

    public int getVerticalScrollBarPolicy() {
	return getSPLayout().getVerticalScrollBarPolicy();
    }

    public void setVerticalScrollBarPolicy(int x) {
	getSPLayout().setVerticalScrollBarPolicy(x);
    }

    public int getHorizontalScrollBarPolicy() {
	return getSPLayout().getHorizontalScrollBarPolicy();
    }

    public void setHorizontalScrollBarPolicy(int x) {
	getSPLayout().setHorizontalScrollBarPolicy(x);
    }

    public JScrollBar getHorizontalScrollBar() {
	return getSPLayout().getHorizontalScrollBar();
    }

    public JScrollBar getVerticalScrollBar() {
	return getSPLayout().getVerticalScrollBar();
    }

    /**
     * Remove the old viewport (if there is one), force the
     * viewPosition of the new viewport to be in the +x,+y quadrant,
     * sync up the row and column headers (if there are any) with the
     * new viewport, and finally sync the scrollbars and
     * headers with the new viewport.
     */

    public void setViewport(JViewport newViewport) {
	JViewport oldViewport = getViewport();

	if (newViewport == oldViewport) {
	    return;
	}

	if (oldViewport != null) {
	    oldViewport.removeChangeListener(viewportListener);
	    scrollpane.remove(oldViewport);
	}

	if (newViewport != null) {
	    Point p = newViewport.getViewPosition();
	    p.x = Math.max(p.x, 0);
	    p.y = Math.max(p.y, 0);
	    newViewport.setViewPosition(p);
	    scrollpane.add(newViewport, VIEWPORT);
	    syncScrollPaneWithViewport();
	    newViewport.addChangeListener(viewportListener);
	}
    }

    public JViewport getViewport() {
	return getSPLayout().getViewport();
    }


    /**
     * If an old rowHeader exists, remove it.  If the new rowHeader
     * isn't null, sync the y coordinate of the its viewPosition with
     * the viewport (if there is one) and then add it to the ScrollPane.
     */

    public void setRowHeader(JViewport newRowHead) {
	JViewport oldRowHead = getRowHeader();

	if (oldRowHead == newRowHead) {
	    return;
	}

	if (oldRowHead != null) {
	    scrollpane.remove(oldRowHead);
	}

	if (newRowHead != null) {
	    JViewport viewport = getViewport();
	    Point p = newRowHead.getViewPosition();
	    p.y = (viewport != null) ? viewport.getViewPosition().y : 0;
	    newRowHead.setViewPosition(p);
	    scrollpane.add(newRowHead, ROW_HEADER);
	}
    }

    public JViewport getRowHeader() {
	return getSPLayout().getRowHeader();
    }


    /**
     * If an old columnHeader exists, remove it.  If the new columnHeader
     * isn't null, sync the x coordinate of the its viewPosition with
     * the viewport (if there is one) and then add it to the ScrollPane.
     */

    public void setColumnHeader(JViewport newColHead) {
	JViewport oldColHead = getColumnHeader();

	if (oldColHead == newColHead) {
	    return;
	}

	if (oldColHead != null) {
	    scrollpane.remove(oldColHead);
	}

	if (newColHead != null) {
	    JViewport viewport = getViewport();
	    Point p = newColHead.getViewPosition();
	    p.x = (viewport != null) ? viewport.getViewPosition().x : 0;
	    newColHead.setViewPosition(p);
	    scrollpane.add(newColHead, COLUMN_HEADER);
	}
    }

    public JViewport getColumnHeader() {
	return getSPLayout().getColumnHeader();
    }



    public Component getCorner(String key) {
	return getSPLayout().getCorner(key);
    }

    public void setCorner(String key, Component x) {
	scrollpane.add(x, key);
    }


    protected void syncScrollPaneWithViewport()
    {
	JViewport viewport = getViewport();
	JScrollBar vsb = getVerticalScrollBar();
	JScrollBar hsb = getHorizontalScrollBar();
	JViewport rowHead = getRowHeader();
	JViewport colHead = getColumnHeader();

	if (viewport != null) {
	    Dimension extentSize = viewport.getExtentSize();
	    Dimension viewSize = viewport.getViewSize();
	    Point viewPosition = viewport.getViewPosition();

	    if (vsb != null) {
		int extent = extentSize.height;
		int max = viewSize.height;
		int value = Math.max(0, Math.min(viewPosition.y, max - extent));
		vsb.setValues(value, extent, 0, max);
	    }

	    if (hsb != null) {
		int extent = extentSize.width;
		int max = viewSize.width;
		int value = Math.max(0, Math.min(viewPosition.x, max - extent));
		hsb.setValues(value, extent, 0, max);
	    }

	    if (rowHead != null) {
		Point p = rowHead.getViewPosition();
		p.y = viewport.getViewPosition().y;
		rowHead.setViewPosition(p);
	    }

	    if (colHead != null) {
		Point p = colHead.getViewPosition();
		p.x = viewport.getViewPosition().x;
		colHead.setViewPosition(p);
	    }
	}
    }


    /**
     * Listener for viewport events.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    protected class ViewportListener implements ChangeListener, Serializable
    {
	public void stateChanged(ChangeEvent e) {
	    syncScrollPaneWithViewport();
	}
    }

    protected ChangeListener createViewportListener() {
	return new ViewportListener();
    }


    /**
     * Horizontal scrollbar listener.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    protected class HSBListener implements ChangeListener, Serializable
    {
	public void stateChanged(ChangeEvent e)
	{
	    JViewport viewport = getViewport();
	    if (viewport != null) {
		BoundedRangeModel model = (BoundedRangeModel)(e.getSource());
		Point p = viewport.getViewPosition();
		p.x = model.getValue();
		viewport.setViewPosition(p);
	    }
	}
    }

    protected ChangeListener createHSBListener() {
	return new HSBListener();
    }


    /**
     * Vertical scrollbar listener.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    protected class VSBListener implements ChangeListener, Serializable
    {
	public void stateChanged(ChangeEvent e)
	{
	    JViewport viewport = getViewport();
	    if (viewport != null) {
		BoundedRangeModel model = (BoundedRangeModel)(e.getSource());
		Point p = viewport.getViewPosition();
		p.y = model.getValue();
		viewport.setViewPosition(p);
	    }
	}
    }

    protected ChangeListener createVSBListener() {
	return new VSBListener();
    }


    /**
     * Standard layout manager for a scroll pane.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    protected class BasicScrollPaneLayout extends ScrollPaneLayout implements Serializable
    {
	public void layoutContainer(Container parent) {
	    super.layoutContainer(parent);
	    syncScrollPaneWithViewport();
	}
    }

    /**
     * @return new BasicScrollPaneLayout()
     */
    protected LayoutManager createLayoutManager() {
	return new BasicScrollPaneLayout();
    }


    /**
     * This method just delegates to the JScrollPane
     * <code>createVerticalScrollbar()</code> method.  Subclasses
     * may override this method to wrap the scrollbar with a
     * special proxy or reconfigure the scrollbar, e.g.
     * by setting its border.
     *
     * @returns scrollpane.createVerticalScrollBar()
     * @see JScrollPane#createVerticalScrollBar
     */
    protected JScrollBar createVerticalScrollBar() {
	return scrollpane.createVerticalScrollBar();
    }

    /**
     * This method just delegates to the JScrollPane
     * <code>createVerticalScrollbar()</code> method.  Subclasses
     * may override this method to wrap the scrollbar with a
     * special proxy or reconfigure the scrollbar, e.g. by
     * setting its border.
     *
     * @returns scrollpane.createHorizontalScrollBar()
     * @see JScrollPane#createHorizontalScrollBar
     */
    protected JScrollBar createHorizontalScrollBar() {
	return scrollpane.createHorizontalScrollBar();
    }

}
