/*
 * @(#)BasicRadioButtonUI.java	1.44 98/06/22
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.swing.plaf.basic;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import java.io.Serializable;


/**
 * RadioButtonUI implementation for BasicRadioButtonUI
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.44 06/22/98
 * @author Jeff Dinkins
 */
public class BasicRadioButtonUI extends BasicToggleButtonUI 
    implements Serializable
{
    protected final static Insets defaultMargin = new Insets(2,2,2,2);

    protected Icon icon = null;

    public BasicRadioButtonUI() {
    }

    protected static ToggleButtonUI radioButtonUI;

    public static ComponentUI createUI(JComponent b) {
        if(radioButtonUI == null) {
            radioButtonUI = new BasicRadioButtonUI();
        }
        return radioButtonUI;
    }


    /************************** The View *************************/

    ButtonModel model;

    protected void installDefaults(AbstractButton b){
	super.installDefaults(b);
	icon = createIcon();
	LookAndFeel.installColorsAndFont(b,
					 "RadioButton.background",
					 "RadioButton.foreground",
					 "RadioButton.font");
    }   


    /**
     * paint the radio button
     */
    public synchronized void paint(Graphics g, JComponent c) {

	AbstractButton b = (AbstractButton) c;
	model = b.getModel();
	
	Dimension size = c.getSize();

	int w = size.width;
	int h = size.height;

	Font f = c.getFont();
	g.setFont(f);
	FontMetrics fm = g.getFontMetrics();

	Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();

	Icon altIcon = b.getIcon();
	Icon selectedIcon = null;
	Icon disabledIcon = null;
	
        String text = SwingUtilities.layoutCompoundLabel(
            fm, b.getText(), altIcon != null ? altIcon : icon,
            b.getVerticalAlignment(), b.getHorizontalAlignment(),
            b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
            viewRect, iconRect, textRect, getDefaultTextIconGap(b)
        );
	
        // fill background
	if(c.isOpaque()) {
	    g.setColor(b.getBackground());
	    g.fillRect(0,0, size.width, size.height); 
	}

	
	// Paint the radio button
        if(altIcon != null) { 

            if(!model.isEnabled()) {
                altIcon = b.getDisabledIcon();
            } else if(model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if(altIcon == null) {
                    // Use selected icon
                    altIcon = b.getSelectedIcon();
                } 
            } else if(model.isSelected()) {
                altIcon = b.getSelectedIcon();
	    } else if(b.isRolloverEnabled() && model.isRollover()) {
                altIcon = (Icon) b.getRolloverIcon();
            } 
	      
	    if(altIcon == null) {
		altIcon = b.getIcon();
	    }
	       
	    altIcon.paintIcon(c, g, iconRect.x, iconRect.y);

        } else {
	    icon.paintIcon(c, g, iconRect.x, iconRect.y);
	}


	// Draw the Text
	if(text != null) {
	    if(model.isEnabled()) {
		// *** paint the text normally
		g.setColor(b.getForeground());
                BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
                                              textRect.x, textRect.y + fm.getAscent());
	    } else {
		// *** paint the text disabled
		g.setColor(b.getBackground().brighter());
                BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
                                              textRect.x + 1, textRect.y + fm.getAscent() + 1);
		g.setColor(b.getBackground().darker());
                BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
                                              textRect.x, textRect.y + fm.getAscent());
	    }
            if(b.hasFocus() && b.isFocusPainted() && textRect.width > 0 && textRect.height > 0 ) {
	      paintFocus(g,textRect,size);

            }
	}
    }

    protected void paintFocus(Graphics g, Rectangle textRect, Dimension size){
    }

    /**
     * Creates the radio dot
     */
    public Icon createIcon() {
	return UIManager.getIcon("RadioButton.icon");
    }


    /**
     * The preferred size of the radio button
     */
    public Dimension getPreferredSize(JComponent c) {

	if(c.getComponentCount() > 0) {
	    return null;
	}

        AbstractButton b = (AbstractButton) c;

        String text = b.getText();

        Icon radioIcon = (Icon) b.getIcon();
	if(radioIcon == null) {
	    radioIcon = icon;
	}

        int width = 0;
        int height = 0;

        Font font = b.getFont();
        FontMetrics fm = b.getToolkit().getFontMetrics(font);
	  
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);

        SwingUtilities.layoutCompoundLabel(
	    fm, text, radioIcon,
	    b.getVerticalAlignment(), b.getHorizontalAlignment(),
	    b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
	    viewR, iconR, textR, text == null ? 0 : getDefaultTextIconGap(b)
	);

        // find the union of the icon and text rects
        Rectangle r = iconR.union(textR);

	Insets insets = b.getInsets();
	r.width += insets.left + insets.right;
	r.height += insets.top + insets.bottom;

        return r.getSize();
    }

    public Insets getDefaultMargin(AbstractButton b) {
	return defaultMargin;
    }

    
}
