/*
 * @(#)BasicRadioButtonMenuItemUI.java	1.33 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.border.*;
import java.io.Serializable;

/**
 * BasicRadioButtonMenuItem implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.33 02/02/98
 * @author Georges Saab
 * @author David Karlton
 */
public class BasicRadioButtonMenuItemUI extends RadioButtonMenuItemUI implements Serializable
{
    protected static Color pressedBackground = null;
    protected static Color pressedForeground = null;
    protected Icon menuArrow = null;
    protected Icon checkIcon = null;

    // visual constants
    protected static final int defaultTextIconGap = 4;

    protected MouseListener       mouseListener;
    protected MouseMotionListener mouseMotionListener;

    protected boolean oldBorderPainted;

    public static ComponentUI createUI(JComponent b) {
        return new BasicRadioButtonMenuItemUI();
    }

    public void installUI(JComponent c) {
	JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem) c;
	initListeners(c);
	addListeners(c);
	// Set defaults
	c.setOpaque(true);
	LookAndFeel.installBorder(c,"MenuItem.border");
	oldBorderPainted = menuItem.isBorderPainted();
	menuItem.setBorderPainted( ( (Boolean) (UIManager.get("MenuItem.borderPainted")) ).booleanValue() );
	LookAndFeel.installColorsAndFont(c,
					      "MenuItem.background",
					      "MenuItem.foreground",
					      "MenuItem.font");
	// MenuItem specific defaults
	if (pressedBackground == null || 
	    pressedBackground instanceof UIResource) {
	    pressedBackground = 
		UIManager.getColor("MenuItem.pressedBackground");
	}
	if (pressedForeground == null || 
	    pressedForeground instanceof UIResource) {
	    pressedForeground = 
		UIManager.getColor("MenuItem.pressedForeground");
	}
	if (menuArrow == null ||
	    menuArrow instanceof UIResource) {
	    menuArrow = UIManager.getIcon("MenuItem.arrowIcon");
	}
	if (menuItem.getSelectedIcon() == null ||
	    menuItem.getSelectedIcon() instanceof UIResource) {
	    menuItem.setSelectedIcon(UIManager.getIcon("RadioButtonMenuItem.icon"));
	}
    }

    public void uninstallUI(JComponent c) {
	JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem) c;
	removeListeners(c);
	LookAndFeel.uninstallBorder(c);
	((JMenuItem) c).setBorderPainted( oldBorderPainted );
	if (menuArrow instanceof UIResource)
	    menuArrow = null;
	if (checkIcon instanceof UIResource)
	    checkIcon = null;
        if (menuItem.getSelectedIcon() instanceof UIResource) {
            menuItem.setSelectedIcon(null);
        }
    }

    protected void initListeners(JComponent c) {
        mouseListener = createMouseListener(c);
        mouseMotionListener  = createMouseMotionListener(c);
    }

    protected void addListeners(JComponent c) {
        c.addMouseListener(mouseListener);	
        c.addMouseMotionListener(mouseMotionListener);
    }

    protected void removeListeners(JComponent c) {
        c.removeMouseListener(mouseListener);
        c.removeMouseMotionListener(mouseMotionListener);
    }

    protected MouseListener createMouseListener(JComponent c) {
	return new BasicMenuMouseListener();
    }

    protected MouseMotionListener createMouseMotionListener(JComponent c) {
        return new BasicMenuMouseMotionListener();
    }

    public Insets getDefaultMargin(AbstractButton c) { 
        return new Insets(2,2,2,2);
    }

    public Dimension getMinimumSize(JComponent c) {
        return getPreferredSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
	return BasicGraphicsUtils.getPreferredMenuItemSize(c,
							   checkIcon, 
							   menuArrow, 
							   defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent c) {
        return getPreferredSize(c);
    }

    /**
     * We draw the background in BasicGraphicsUtils.paintMenuItem()
     * so override update (which fills the background of opaque
     * components by default) to just call paint().
     *
     * @see BasicGraphicsUtils#paintMenuItem
     */
    public void update(Graphics g, JComponent c) {
        paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
	BasicGraphicsUtils.paintMenuItem(g, c, ((JRadioButtonMenuItem)c).getSelectedIcon(), menuArrow,
					 pressedBackground, pressedForeground,
					 defaultTextIconGap);	
    }


    public void processMouseEvent(JMenuItem item,MouseEvent e,MenuElement path[],MenuSelectionManager manager) {
        Point p = e.getPoint();
        if(p.x >= 0 && p.x < item.getWidth() &&
           p.y >= 0 && p.y < item.getHeight()) {
            if(e.getID() == MouseEvent.MOUSE_RELEASED) {
                manager.clearSelectedPath();
                item.doClick(0);
                item.setArmed(false);
            } else
                manager.setSelectedPath(path);
        } else if(item.getModel().isArmed()) {
            MenuElement newPath[] = new MenuElement[path.length-1];
            int i,c;
            for(i=0,c=path.length-1;i<c;i++)
                newPath[i] = path[i];
            manager.setSelectedPath(newPath);
        }
    }
}








