/*
 * @(#)BasicRGBChooserPanel.java	1.6 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.ColorChooserUI;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;


/**
 * The standard RGB chooser.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.6 02/02/98
 * @author Tom Santos
 */
public class BasicRGBChooserPanel extends ColorChooserPanel implements ChangeListener, Serializable {
  protected Color color = Color.red;
  protected JSlider redSlider;
  protected JSlider greenSlider;
  protected JSlider blueSlider;
  protected JPanel resultColor;

  String redString = "Red";
  String greenString = "Green";
  String blueString = "Blue";

    public BasicRGBChooserPanel() {
        super();
    }

    public BasicRGBChooserPanel( Color startColor ) {
        super();
	color = startColor;
    }


    public void setColor( Color newColor ) {
	redSlider.setValue( newColor.getRed() );
	greenSlider.setValue( newColor.getGreen() );
	blueSlider.setValue( newColor.getBlue() );
    }

    public Color getColor() {
        return color;
    }
       
    /**
     * The background color, foreground color, and font are already set to the
     * defaults from the defaults table before this method is called.
     */									
    public void installChooserPanel() {
      //	addPropertyChangeListener( this );
	

	setLayout( new BorderLayout() );

	// The box that displays the current color
	resultColor = new JPanel () { public Dimension getPreferredSize() {
	                                         return new Dimension( 30, 45 ); } };
	JPanel colorBuffer = new JPanel( );
	colorBuffer.add(resultColor);

	resultColor.setBackground( color );
	add( resultColor, BorderLayout.CENTER );

	// The panel that holds the sliders
	JPanel sliderPanel = new JPanel();
	sliderPanel.setLayout( new ColumnLayout() );
	add( sliderPanel, BorderLayout.WEST );
	//	sliderPanel.setBorder(new LineBorder(Color.black));

	// The slider for the red value
	redSlider = new JSlider( JSlider.HORIZONTAL, 0, 255, color.getRed() );
	redSlider.setMajorTickSpacing( 85 );
	redSlider.setMinorTickSpacing( 17 );
	redSlider.setPaintTicks( true );
	redSlider.setPaintLabels( true );

	// The panel that holds the components for the Red element
	JPanel redPanel = new JPanel();
	
	JLabel rLabel = new JLabel("Red");
	redPanel.add(rLabel);
	redPanel.add( redSlider);
/*	Spinner rSpin = new Spinner(color.getRed());
	rSpin.setMaximum(255);
	redPanel.add(rSpin);*/
	sliderPanel.add( redPanel );

	// The slider for the green value
	greenSlider = new JSlider( JSlider.HORIZONTAL, 0, 255, color.getRed() );
	greenSlider.setMajorTickSpacing( 85 );
	greenSlider.setMinorTickSpacing( 17 );
	greenSlider.setPaintTicks( true );
	greenSlider.setPaintLabels( true );

	// The panel that holds the components for the green element
	JPanel greenPanel = new JPanel();

	JLabel gLabel = new JLabel("Green");
	greenPanel.add(gLabel);
	greenPanel.add( greenSlider );
	sliderPanel.add( greenPanel );

	// The slider for the blue value
	blueSlider = new JSlider( JSlider.HORIZONTAL, 0, 255, color.getRed() );
	blueSlider.setMajorTickSpacing( 85 );
	blueSlider.setMinorTickSpacing( 17 );
	blueSlider.setPaintTicks( true );
	blueSlider.setPaintLabels( true );

	// The panel that holds the components for the blue element
	JPanel bluePanel = new JPanel();

	JLabel bLabel = new JLabel("Blue");
	bluePanel.add(bLabel);
	bluePanel.add( blueSlider );
	//	bluePanel.setBorder(new LineBorder(Color.black));
	sliderPanel.add( bluePanel );

	int labelWidth = Math.max(rLabel.getPreferredSize().width, gLabel.getPreferredSize().width);
	labelWidth = Math.max(labelWidth, bLabel.getPreferredSize().width);
	rLabel.setPreferredSize(new Dimension(labelWidth, rLabel.getPreferredSize().height));
	gLabel.setPreferredSize(new Dimension(labelWidth, gLabel.getPreferredSize().height));
	bLabel.setPreferredSize(new Dimension(labelWidth, bLabel.getPreferredSize().height));

	setPreferredSize( new Dimension( sliderPanel.getPreferredSize().width + resultColor.getPreferredSize().width, 
					 sliderPanel.getPreferredSize().height + resultColor.getPreferredSize().height));
	// Install listeners
	redSlider.addChangeListener( this );
	greenSlider.addChangeListener( this );
	blueSlider.addChangeListener( this );
    }

    public void uninstallChooserPanel() {
      //removePropertyChangeListener( this );
	color = null;
	redSlider = null;
	greenSlider = null;
	blueSlider = null;
    }

    public void stateChanged( ChangeEvent e ) {
	if ( e.getSource() instanceof JSlider ) {
	    JSlider source = (JSlider)e.getSource();
	    Color oldColor = color;

	    if ( source == redSlider ) {
	        color = new Color( redSlider.getValue(), color.getGreen(), color.getBlue() );
	    }
	    else if ( source == greenSlider ) {
	        color = new Color( color.getRed(), greenSlider.getValue(), color.getBlue() );
	    }
	    else if ( source == blueSlider ) {
	        color = new Color( color.getRed(), color.getGreen(), blueSlider.getValue() );
	    }

	    resultColor.setBackground( color );
	    resultColor.repaint();

	    fireColorPropertyChange( oldColor, color );
	}
    }
}

class ColumnLayout implements LayoutManager {

  int xInset = 5;
  int yInset = 5;
  int yGap = 2;

  public void addLayoutComponent(String s, Component c) {}

  public void layoutContainer(Container c) {
      Insets insets = c.getInsets();
      int height = yInset + insets.top;
      
      Component[] children = c.getComponents();
      Dimension compSize = null;
      for (int i = 0; i < children.length; i++) {
	  compSize = children[i].getPreferredSize();
	  children[i].setSize(compSize.width, compSize.height);
	  children[i].setLocation( xInset + insets.left, height);
	  height += compSize.height + yGap;
      }

  }

  public Dimension minimumLayoutSize(Container c) {
      Insets insets = c.getInsets();
      int height = yInset + insets.top;
      int width = 0 + insets.left + insets.right;
      
      Component[] children = c.getComponents();
      Dimension compSize = null;
      for (int i = 0; i < children.length; i++) {
	  compSize = children[i].getPreferredSize();
	  
	  height += compSize.height + yGap;
	  width = Math.max(width, compSize.width + insets.left + insets.right + xInset*2);
      }
      height += insets.bottom;
      return new Dimension( width, height);
  }
  
  public Dimension preferredLayoutSize(Container c) {
      return minimumLayoutSize(c);
  }
   
  public void removeLayoutComponent(Component c) {}

}
