/*
 * @(#)BasicMenuUtilities.java	1.2 98/01/30
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.basic;
import com.sun.java.swing.*;
import java.awt.*;


/**
 * A Windows L&F implementation of MenuUI.  This implementation 
 * is a "combined" view/controller.
 *
 * @version 1.2 01/30/98
 * @author Georges Saab
 * @author David Karlton
 */

public class BasicMenuUtilities {



    /**
     * Returns the subcomponent at the given coordinates in this 
     * menubar's coordinate space.
     */

    public static Component getMenuComponentAt(JMenuBar menuBar, int x, int y) {
	// System.out.println("Start Coords: " + x + " " + y);
	int ncomponents = menuBar.getComponentCount();
	Component[] component = menuBar.getComponents();
	for (int i = 0 ; i < ncomponents ; i++) {
	    Component comp = component[i];
	    Point tp = getTranslatedPoint(menuBar, x, y, menuBar, comp);
	    // System.out.println("Item Coords: " + tp.x + " " + tp.y);
	    Component ret;
	    if (comp instanceof JMenu) {
		ret = getMenuComponentAt((JMenu)comp, tp.x, tp.y);
	    } else {
		ret = comp.getComponentAt(tp.x, tp.y);
	    }
	    // Subcomponent must be visible!
	    if ((ret != null) && ret.isShowing()) return ret;
	}
	return null;
    }


    /*
     * Returns the menu subcomponent at the given coordinates in this 
     * menu's coordinate space.
     * @param x the x coordinate to be tested
     * @param y the y coordinate to be tested
     */

    public static Component getMenuComponentAt(JMenu menu, int x, int y) {
	// Coordinates are within the menu's JMenuItem
	if (menu.contains(x,y)) {
	    return menu;
	} else {
	    // Test the popup menu
	    if (menu.isSelected()) {
		Point tp = translateToPopupMenu(menu, x,y);
		return getMenuComponentAt(menu.getPopupMenu(), tp.x, tp.y);
	    }
	    return null;
	}
    }

    /**
     * Returns the menu subcomponent at the given coordinates in this 
     * menu's coordinate space.
     */

    public static Component getMenuComponentAt(JPopupMenu popupMenu, int x, int y) {
	int ncomponents = popupMenu.getComponentCount();
	Component[] component = popupMenu.getComponents();
	for (int i = 0 ; i < ncomponents ; i++) {
	    Component comp = component[i];
	    Point tp = getTranslatedPoint(popupMenu, 
							   x, y, popupMenu, comp);
	    Component ret;
	    if (comp instanceof JMenu) {
		ret = getMenuComponentAt((JMenu)comp, tp.x, tp.y);
	    } else {
		ret = comp.getComponentAt(tp.x, tp.y);
	    }
	    // Subcomponent must be visible!
	    if ((ret != null) && ret.isShowing()) return ret;
	}
	// Not in a child, is it within PopupMenu's insets?
	if (popupMenu.contains(x,y) && popupMenu.isShowing()) {
	    // System.out.println("In PopupMenu Insets");
	    return popupMenu;
	}
	return null;
    }

    /**
     * Returns the given point in the <i>from</i> components coordinate 
     * space translated into the <i>to</i> components coordinate space.  
     * The <i>from</i> component is expected to be a menu-parent of
     * the <i>to</i> component.
     */

    public static Point getTranslatedPoint(JMenuBar menuBar, int x, int y, 
				    Component from, Component to) {
	Component c;
	int x1 = x;
	int y1 = y;
	for(c = to; c != null && c != from; c = c.getParent()) {
	    Rectangle r = c.getBounds();
	    x1 -= r.x;
	    y1 -= r.y;
	}
	// Inside Menu
	if (c != null) {
	    return new Point(x1, y1);
	}

	// Handle submenus
	int ncomponents = menuBar.getComponentCount();
	Component[] component = menuBar.getComponents();
	for (int i = 0 ; i < ncomponents ; i++) {
	    Component comp = component[i];
	    if (comp instanceof JMenu) {
		Point tp = getTranslatedPoint((JMenu)comp, x, y, comp, to);
		if (tp!= null) return tp;
	    }
	}
	return null;
    }

    /**
     * Returns the given point in the <i>from</i> components coordinate 
     * space translated into the <i>to</i> components coordinate space.  
     * The <i>from</i> component is expected to parent the <i>to</i> 
     * component.
     */
    public static Point getTranslatedPoint(JPopupMenu popupMenu,
					     int x, int y, 
					     Component from, Component to) {
	Component c;
	int x1 = x;
	int y1 = y;
	for(c = to; c != null && c != from; c = c.getParent()) {
	    Rectangle r = c.getBounds();
	    x1 -= r.x;
	    y1 -= r.y;
	}
	// Inside Menu
	if (c != null) {
	    return new Point(x1, y1);
	}

	// Handle submenus
	int ncomponents = popupMenu.getComponentCount();
	Component[] component = popupMenu.getComponents();
	for (int i = 0 ; i < ncomponents ; i++) {
	    Component comp = component[i];
	    if (comp instanceof JMenu) {
		Point tp = getTranslatedPoint((JMenu)comp, x, y, comp, to);
		if (tp!= null) return tp;
	    }
	}
	return null;
    }

    /**
     * Returns the given point in the <i>from</i> components coordinate 
     * space translated into the <i>to</i> components coordinate space.  
     * The <i>from</i> component is expected to be a menu-parent of
     * the <i>to</i> component.
     */

    public static Point getTranslatedPoint(JMenu menu, 
					       int x, int y, 
					       Component from, Component to) {
	// System.out.println("In coords: " + x + " " + y);
	if (to == menu) {
	    return new Point (x,y);
	} else {
	    if (menu.isSelected()) {
		Point tp = translateToPopupMenu(menu, x,y);
		// System.out.println("PopupMenu coords: " + tp.x + " " + tp.y);
		int ncomponents = menu.getMenuComponentCount();
		Component[] component = menu.getMenuComponents();
		for (int i = 0 ; i < ncomponents ; i++) {
		    Component comp = component[i];
		    JPopupMenu popupMenu = menu.getPopupMenu();
		    Point tp2 = getTranslatedPoint(popupMenu, tp.x, tp.y,
						     popupMenu, comp);
		    // System.out.println("Item Coords: " + tp2.x + " " + tp2.y);
		    if (comp == to) 
			return tp2;
		    if (comp instanceof JMenu) {
			Point tp3 = getTranslatedPoint((JMenu)comp,
						       tp2.x, tp2.y, comp, to);
			if (tp3!= null) return tp3;
		    }
		}
	    }
	    return null;
	}
    }

    /**
     * Returns a point in the coordinate space of this menu's popupmenu
     * which corresponds to the point p in the menu's coordinate space.
     * @param p the point to be translated
     */
    private static Point translateToPopupMenu(JMenu menu, Point p) {
	return translateToPopupMenu(menu, p.x, p.y);
    }

    /**
     * Returns a point in the coordinate space of this menu's popupmenu
     * which corresponds to the point (x,y) in the menu's coordinate space.
     * @param x the x coordinate of the point to be translated
     * @param y the y coordinate of the point to be translated
     */
    private static Point translateToPopupMenu(JMenu menu, int x, int y) {
	    int newX;
	    int newY;

	    if (menu.getParent() instanceof JPopupMenu) {
		newX = x - menu.getSize().width;
		newY = y;
	    } else {
		newX = x;
		newY = y - menu.getSize().height;
	    }

	    return new Point(newX, newY);
	}

}
