/*
 * @(#)BasicMenuItemUI.java	1.59 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.basic;

import java.awt.*;
import java.awt.event.*;
import java.io.Serializable;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;


/**
 * BasicMenuItem implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.59 02/02/98
 * @author Georges Saab
 * @author David Karlton
 * @author Arnaud Weber
 */
public class BasicMenuItemUI extends MenuItemUI implements Serializable
{

    protected static Color pressedBackground;
    protected static Color pressedForeground;
    // visual constants
    protected static final int defaultTextIconGap = 4;
    protected MouseListener mouseListener;
    protected MouseMotionListener dragListener;
    
    protected Icon menuArrow = null;
    protected Icon checkIcon = null;

    protected boolean oldBorderPainted;

    public static ComponentUI createUI(JComponent c) {
        return new BasicMenuItemUI();
    }

    public void installUI(JComponent c) {
	JMenuItem menuItem = (JMenuItem) c;
	// Create and install listeners
	initListeners(c);
	addListeners(c);
	// Set defaults
	c.setOpaque(true);
	LookAndFeel.installBorder(c,"MenuItem.border");
	oldBorderPainted = menuItem.isBorderPainted();
	menuItem.setBorderPainted( ( (Boolean) (UIManager.get("MenuItem.borderPainted")) ).booleanValue() );
	LookAndFeel.installColorsAndFont(c,
					      "MenuItem.background",
					      "MenuItem.foreground",
					      "MenuItem.font");
	// MenuItem specific defaults
	if (pressedBackground == null || 
	    pressedBackground instanceof UIResource) {
	    pressedBackground = 
		UIManager.getColor("MenuItem.pressedBackground");
	}
	if (pressedForeground == null || 
	    pressedForeground instanceof UIResource) {
	    pressedForeground = 
		UIManager.getColor("MenuItem.pressedForeground");
	}
	// Icons
	if (menuArrow == null ||
	    menuArrow instanceof UIResource) {
	    menuArrow = UIManager.getIcon("MenuItem.arrowIcon");
	}
	if (checkIcon == null ||
	    checkIcon instanceof UIResource) {
	    checkIcon = UIManager.getIcon("MenuItem.checkIcon");
	}
    }

    public void uninstallUI(JComponent c) {
	removeListeners(c);
	LookAndFeel.uninstallBorder(c);
	((JMenuItem) c).setBorderPainted( oldBorderPainted );
	if (menuArrow instanceof UIResource)
	    menuArrow = null;
	if (checkIcon instanceof UIResource)
	    checkIcon = null;
    }

    protected void initListeners(JComponent c) {
        mouseListener = createMouseListener(c);
        dragListener = createMouseMotionListener(c);
    }

    protected void addListeners(JComponent c) {
        c.addMouseListener(mouseListener);
        c.addMouseMotionListener(dragListener);
    }

    protected void removeListeners(JComponent c) {
        c.removeMouseListener(mouseListener);
        c.removeMouseMotionListener(dragListener);
    }

    protected MouseListener createMouseListener(JComponent c) {
	return new BasicMenuMouseListener();
    }

    protected MouseMotionListener createMouseMotionListener(JComponent c) {
	return new BasicMenuMouseMotionListener();
    }

    public Dimension getMinimumSize(JComponent c) {
        return getPreferredSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        Icon checkIcon = getCheckIcon();
        Icon arrowIcon = getMenuArrow();
	return BasicGraphicsUtils.getPreferredMenuItemSize(c,
				   checkIcon, arrowIcon, defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent c) {
        return getPreferredSize(c);
    }


    /**
     * We draw the background in BasicGraphicsUtils.paintMenuItem()
     * so override update (which fills the background of opaque
     * components by default) to just call paint().
     *
     * @see BasicGraphicsUtils#paintMenuItem
     */
    public void update(Graphics g, JComponent c) {
        paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
	BasicGraphicsUtils.paintMenuItem(g, c, getCheckIcon(), getMenuArrow(),
					 pressedBackground, pressedForeground,
					 defaultTextIconGap);
    }

    public Insets getDefaultMargin(AbstractButton c) { 
        return new Insets(2,2,2,2);
    }

    Icon getMenuArrow(){
	return menuArrow;
    }

    Icon getCheckIcon() {
	return checkIcon;
    }

    public void processMouseEvent(JMenuItem item,MouseEvent e,MenuElement path[],MenuSelectionManager manager) {
        Point p = e.getPoint();
        if(p.x >= 0 && p.x < item.getWidth() &&
           p.y >= 0 && p.y < item.getHeight()) {
            if(e.getID() == MouseEvent.MOUSE_RELEASED) {
                manager.clearSelectedPath();
                item.doClick(0);
            } else
                manager.setSelectedPath(path);
        } else if(e.getID() == MouseEvent.MOUSE_RELEASED) {
            manager.clearSelectedPath();
        } else if(item.getModel().isArmed()) {
            MenuElement newPath[] = new MenuElement[path.length-1];
            int i,c;
            for(i=0,c=path.length-1;i<c;i++)
                newPath[i] = path[i];
            manager.setSelectedPath(newPath);
        }
    }

    private int lower(int ascii) {
        if(ascii >= 'A' && ascii <= 'Z')
            return ascii + 'a' - 'A';
        else
            return ascii;
    }
    
    public void processKeyEvent(JMenuItem item,KeyEvent e,MenuElement path[],MenuSelectionManager manager) {
        int key = item.getMnemonic();
        if(key == 0)
            return;
        if(e.getID() == KeyEvent.KEY_PRESSED) {
     
            if(lower(key) == lower((int)(e.getKeyChar()))) {
                manager.clearSelectedPath();
                item.doClick(0);
                e.consume();
            }
        }
    }
}








