/*
 * @(#)BasicMenuBarUI.java	1.55 98/02/16
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.*;
import java.io.Serializable;

import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;


/**
 * A Windows L&F implementation of MenuBarUI.  This implementation 
 * is a "combined" view/controller.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.55 02/16/98
 * @author Georges Saab
 * @author David Karlton
 * @author Arnaud Weber
 */
public class BasicMenuBarUI extends MenuBarUI implements Serializable {
    protected JMenuBar              menuBar;
    protected MouseListener         mouseListener;
    protected MouseMotionListener   dragListener;
    protected ChangeListener        menuChangeListener;

    public static ComponentUI createUI(JComponent x) {
	return new BasicMenuBarUI();
    }

    public void installUI(JComponent c) {
	menuBar = (JMenuBar) c;
	initListeners();
	addListeners();
	// Set defaults
	c.setOpaque(true);
	LookAndFeel.installBorder(c,"MenuBar.border");	
	LookAndFeel.installColorsAndFont(c,
					      "MenuBar.background",
					      "MenuBar.foreground",
					      "MenuBar.font");
    }

    public void uninstallUI(JComponent c) {
	removeListeners();
	c.resetKeyboardActions();
	LookAndFeel.uninstallBorder(c);

    }

    protected void initListeners() {
        mouseListener = createMouseListener();
        dragListener  = createMouseMotionListener();
        menuChangeListener = createChangeListener();
    }

    protected MouseListener createMouseListener() {
        return new MouseListener(menuBar);
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new BasicMenuMouseMotionListener();
    }

    protected ChangeListener createChangeListener() {
        return new BasicMenuBarChangeListener() {
            public void stateChanged(ChangeEvent e) {
                int i,c;
                for(i=0,c = menuBar.getMenuCount() ; i < c ; i++) {
		    JMenu menu = menuBar.getMenu(i);
                    if(menu !=null && menu.isSelected()) {
                        menuBar.getSelectionModel().setSelectedIndex(i);
                        break;
                    }
                }
            }
        };
    }

    private abstract static class BasicMenuBarChangeListener implements
        ChangeListener, Serializable {
        // This class exists so the above anonymous class is
        // Serializable.
    }

    protected void addListeners() {
        for (int i = 0; i < menuBar.getMenuCount(); i++) {	    
            registerMenu(menuBar.getMenu(i));
        }
    }

    protected void removeListeners() {
        for (int i = 0; i < menuBar.getMenuCount(); i++) { 
	    unregisterMenu(menuBar.getMenu(i));
        }        
    }

    /** Adds this MenuBarUI's listeners 
      */
    public void registerMenu(JMenu menu) {
        menu.getModel().addChangeListener(menuChangeListener);
    }

    /** Removes this MenuBarUI's listeners
      */
    public void unregisterMenu(JMenu menu) {
        menu.getModel().removeChangeListener(menuChangeListener);
    }

    public Dimension getPreferredSize(JComponent c) { 
        return null; 
    }

    public Dimension getMinimumSize(JComponent c) { 
        return null; 
    } 

    public Dimension getMaximumSize(JComponent c) { 
        return null; 
    }

    static class MouseListener extends MouseAdapter implements Serializable {
        JMenuBar menuBar;
        public MouseListener(JMenuBar mb) {
            menuBar = mb;
        }

        public void mousePressed(MouseEvent e) {
            MenuElement me[] = new MenuElement[1];
            me[0]=menuBar;
            MenuSelectionManager.defaultManager().setSelectedPath(me);
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }
        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }
        public void mouseEntered(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }
        public void mouseExited(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }
    }


}


