/*
 * @(#)BasicMarginBorder.java	1.9 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.basic;

import java.awt.Component;
import java.awt.Insets;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.JToolBar;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.border.*;

/**
 * A border class to be used for defining margin space for
 * component classes which define "Margin" as a property.
 * (currently this class is rigged to work with subclasses
 * of AbstractButton and JToolBar).
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.9 02/02/98
 * @author Amy Fowler
 */
public class BasicMarginBorder extends AbstractBorder {
    private static Border marginBorder = new BasicMarginBorder();

    public static Border getMarginBorder() {
        return marginBorder;
    }

    public Insets getBorderInsets(Component c)       {
        //
        // Ideally we'd have an interface defined for classes which
        // support margins (to avoid this hackery), but we've
        // decided against it for simplicity
        //
       if (c instanceof AbstractButton) {
           AbstractButton b = (AbstractButton)c;
           return b.getMargin();
       } else if (c instanceof JToolBar) {
           JToolBar t = (JToolBar)c;
           return t.getMargin();
       } else if (c instanceof JTextComponent) {
           JTextComponent t = (JTextComponent)c;
           return t.getMargin();
       }
       return new Insets(0, 0, 0, 0);
    }
}
