/*
 * @(#)BasicLookAndFeel.java	1.106 98/04/14
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.basic;

import java.awt.Font;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.io.Serializable;

import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.UIDefaults;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.DefaultEditorKit;

/**
 * Implements the a standard base LookAndFeel class from which
 * standard desktop LookAndFeel classes (JLF, Mac, Windows, etc.)
 * can be derived.  This class cannot be instantiated directly,
 * however the UI classes "Basic" defines can be.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.106 04/14/98
 * @author unknown
 */
public abstract class BasicLookAndFeel extends LookAndFeel implements Serializable
{

    public UIDefaults getDefaults() {
	UIDefaults table = new UIDefaults();

	initClassDefaults(table);
	initSystemColorDefaults(table);
	initComponentDefaults(table);

	return table;
    }

    /** 
     * Initialize the uiClassID to BasicComponentUI mapping.
     * The JComponent classes define their own uiClassID constants
     * (see AbstractComponent.getUIClassID).  This table must
     * map those constants to a BasicComponentUI class of the
     * appropriate type.
     * 
     * @see #getDefaults
     */
    protected void initClassDefaults(UIDefaults table)
    {
	String basicPackageName = "com.sun.java.swing.plaf.basic.";
	Object[] uiDefaults = {
		   "ButtonUI", basicPackageName + "BasicButtonUI",
		 "CheckBoxUI", basicPackageName + "BasicCheckBoxUI",
             "ColorChooserUI", basicPackageName + "BasicColorChooserUI",
		  "MenuBarUI", basicPackageName + "BasicMenuBarUI",
		     "MenuUI", basicPackageName + "BasicMenuUI",
		 "MenuItemUI", basicPackageName + "BasicMenuItemUI",
	 "CheckBoxMenuItemUI", basicPackageName + "BasicCheckBoxMenuItemUI",
      "RadioButtonMenuItemUI", basicPackageName + "BasicRadioButtonMenuItemUI",
	      "RadioButtonUI", basicPackageName + "BasicRadioButtonUI",
	     "ToggleButtonUI", basicPackageName + "BasicToggleButtonUI",
		"PopupMenuUI", basicPackageName + "BasicPopupMenuUI",
	      "ProgressBarUI", basicPackageName + "BasicProgressBarUI",
		"ScrollBarUI", basicPackageName + "BasicScrollBarUI",
	       "ScrollPaneUI", basicPackageName + "BasicScrollPaneUI",
		"SplitPaneUI", basicPackageName + "BasicSplitPaneUI",
		   "SliderUI", basicPackageName + "BasicSliderUI",
		  "SpinnerUI", basicPackageName + "BasicSpinnerUI",
		"SeparatorUI", basicPackageName + "BasicSeparatorUI",
	       "TabbedPaneUI", basicPackageName + "BasicTabbedPaneUI",
		 "TextAreaUI", basicPackageName + "BasicTextAreaUI",
		"TextFieldUI", basicPackageName + "BasicTextFieldUI",
	    "PasswordFieldUI", basicPackageName + "BasicPasswordFieldUI",
		 "TextPaneUI", basicPackageName + "BasicTextPaneUI",
               "EditorPaneUI", basicPackageName + "BasicEditorPaneUI",
		     "TreeUI", basicPackageName + "BasicTreeUI",
		    "LabelUI", basicPackageName + "BasicLabelUI",
		     "ListUI", basicPackageName + "BasicListUI",
		  "ToolBarUI", basicPackageName + "BasicToolBarUI",
		  "ToolTipUI", basicPackageName + "BasicToolTipUI",
		 "ComboBoxUI", basicPackageName + "BasicComboBoxUI",
		    "TableUI", basicPackageName + "BasicTableUI",
	      "TableHeaderUI", basicPackageName + "BasicTableHeaderUI",
	    "InternalFrameUI", basicPackageName + "BasicInternalFrameUI",
	   "StandardDialogUI", basicPackageName + "BasicStandardDialogUI",
	      "DesktopPaneUI", basicPackageName + "BasicDesktopPaneUI",
	      "DesktopIconUI", basicPackageName + "BasicDesktopIconUI",
	       "OptionPaneUI", basicPackageName + "BasicOptionPaneUI"
	};

	table.putDefaults(uiDefaults);
    }

    /**
     * Load the SystemColors into the defaults table.  The keys
     * for SystemColor defaults are the same as the names of
     * the public fields in SystemColor.  If the table is being
     * created on a native Windows platform we use the SystemColor
     * values, otherwise we create color objects whose values match
     * the defaults Windows95 colors.
     */
    protected void initSystemColorDefaults(UIDefaults table)
    {
	String[] systemColors = {
  	        "desktop", "#005C5C", /* Color of the desktop background */
	  "activeCaption", "#000080", /* Color for captions (title bars) when they are active. */
      "activeCaptionText", "#FFFFFF", /* Text color for text in captions (title bars). */
    "activeCaptionBorder", "#C0C0C0", /* Border color for caption (title bar) window borders. */
        "inactiveCaption", "#808080", /* Color for captions (title bars) when not active. */
    "inactiveCaptionText", "#C0C0C0", /* Text color for text in inactive captions (title bars). */
  "inactiveCaptionBorder", "#C0C0C0", /* Border color for inactive caption (title bar) window borders. */
	         "window", "#FFFFFF", /* Default color for the interior of windows */
	   "windowBorder", "#000000", /* ??? */
	     "windowText", "#000000", /* ??? */
		   "menu", "#C0C0C0", /* Background color for menus */
	       "menuText", "#000000", /* Text color for menus  */
		   "text", "#C0C0C0", /* Text background color */
	       "textText", "#000000", /* Text foreground color */
	  "textHighlight", "#000080", /* Text background color when selected */
      "textHighlightText", "#FFFFFF", /* Text color when selected */
       "textInactiveText", "#808080", /* Text color when disabled */
	        "control", "#C0C0C0", /* Default color for controls (buttons, sliders, etc) */
	    "controlText", "#000000", /* Default color for text in controls */
       "controlHighlight", "#FFFFFF", /* Specular highlight (opposite of the shadow) */
     "controlLtHighlight", "#E0E0E0", /* Highlight color for controls */
	  "controlShadow", "#808080", /* Shadow color for controls */
        "controlDkShadow", "#000000", /* Dark shadow color for controls */
	      "scrollbar", "#E0E0E0", /* Scrollbar background (usually the "track") */
		   "info", "#FFFFE1", /* ??? */
	       "infoText", "#000000"  /* ??? */
	};

	loadSystemColors(table, systemColors);
    }


    /**
     * If this is the native look and feel the initial values for the
     * system color properties are the same as the SystemColor constants.
     * If not we use the integer color values in the <code>systemColors</code>
     * argument.
     */
    protected void loadSystemColors(UIDefaults table, String[] systemColors)
    {
	/* PENDING(hmuller) We don't load the system colors below because
	 * they're not reliable.  Hopefully we'll be able to do better in 
	 * a future version of AWT.
	 */
	if (false && isNativeLookAndFeel()) {
	    for(int i = 0; i < systemColors.length; i += 2) {
		Color color = Color.black;
		try {
		    String name = systemColors[i];
		    color = (Color)(SystemColor.class.getField(name).get(null));
		} catch (Exception e) { 
		}
		table.put(systemColors[i], new ColorUIResource(color));
	    }
	} else {
	    for(int i = 0; i < systemColors.length; i += 2) {
		Color color = Color.black;
		try {
		    color = Color.decode(systemColors[i + 1]);
		} 
		catch(NumberFormatException e) {
		    e.printStackTrace();
		}
		table.put(systemColors[i], new ColorUIResource(color));
	    }
	}
    }

    
    protected void initComponentDefaults(UIDefaults table) 
    {
	// *** Fonts
	FontUIResource dialogPlain12 = new FontUIResource("Dialog", Font.PLAIN, 12);
	FontUIResource serifPlain12 = new FontUIResource("Serif", Font.PLAIN, 12);
	FontUIResource sansSerifPlain12 = new FontUIResource("SansSerif", Font.PLAIN, 12);
	FontUIResource monospacedPlain12 = new FontUIResource("Monospaced", Font.PLAIN, 12);
	FontUIResource dialogBold12 = new FontUIResource("Dialog", Font.BOLD, 12);

	// *** Colors
	ColorUIResource red = new ColorUIResource(Color.red);
	ColorUIResource black = new ColorUIResource(Color.black);
        ColorUIResource white = new ColorUIResource(Color.white);
	ColorUIResource yellow = new ColorUIResource(Color.yellow);
        ColorUIResource gray = new ColorUIResource(Color.gray);
	ColorUIResource lightGray = new ColorUIResource(Color.lightGray);
	ColorUIResource darkGray = new ColorUIResource(Color.darkGray);
	ColorUIResource scrollBarTrack = new ColorUIResource(224, 224, 224);
	ColorUIResource treeSelection = new ColorUIResource(Color.red);
	ColorUIResource menuItemPressedBackground = new ColorUIResource(0,0,128);
	ColorUIResource menuItemPressedForeground = new ColorUIResource(255,255,255);


	// *** List 
	Object listCellRendererActiveValue = new UIDefaults.ActiveValue() {
	    public Object createValue(UIDefaults table) { 
		return new BasicListCellRenderer.UIResource();
	    }
	};

	// *** ComboBox
        Object comboBoxRendererActiveValue  = new UIDefaults.ActiveValue() {
            public Object createValue(UIDefaults table) {
                return new BasicComboBoxRenderer.UIResource();
            }
        };

        Object comboBoxEditorActiveValue  = new UIDefaults.ActiveValue() {
            public Object createValue(UIDefaults table) {
                return new BasicComboBoxEditor.UIResource();
            }
        };

	// *** ScrollPane
	Object scrollPaneBorder = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return BorderUIResource.getEtchedBorderUIResource();
	    }
	};

	Object tableScrollPaneBorder = new BorderUIResource(new BevelBorder(BevelBorder.LOWERED));

	// *** FileChooser / FileView
	Object newFolderIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return LookAndFeel.makeIcon(getClass(), "icons/NewFolder.gif");
	    }
	};

	Object upFolderIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return LookAndFeel.makeIcon(getClass(), "icons/UpFolder.gif");
	    }
	};

	Object homeFolderIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return LookAndFeel.makeIcon(getClass(), "icons/HomeFolder.gif");
	    }
	};

	Object detailsViewIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return LookAndFeel.makeIcon(getClass(), "icons/DetailsView.gif");
	    }
	};

	Object listViewIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return LookAndFeel.makeIcon(getClass(), "icons/ListView.gif");
	    }
	};

	Object directoryIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return LookAndFeel.makeIcon(getClass(), "icons/Directory.gif");
	    }
	};

	Object fileIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return LookAndFeel.makeIcon(getClass(), "icons/File.gif");
	    }
	};

	Object computerIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return LookAndFeel.makeIcon(getClass(), "icons/Computer.gif");
	    }
	};

	Object hardDriveIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return LookAndFeel.makeIcon(getClass(), "icons/HardDrive.gif");
	    }
	};

	Object floppyDriveIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return LookAndFeel.makeIcon(getClass(), "icons/FloppyDrive.gif");
	    }
	};


	// *** Text
	Object multilineTextBorder = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return BasicMarginBorder.getMarginBorder();
	    }
	};

	Object fieldTextBorder = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
		return new BorderUIResource(new CompoundBorder(
                                            BasicFieldBorder.getFieldBorder(),
					    BasicMarginBorder.getMarginBorder()));
	    }
	};

	JTextComponent.KeyBinding[] fieldBindings = {
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
					  JTextField.notifyAction)
	};

	JTextComponent.KeyBinding[] multilineBindings = {
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_UP, 0),
					  DefaultEditorKit.upAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_DOWN, 0),
					  DefaultEditorKit.downAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, 0),
					  DefaultEditorKit.pageUpAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_DOWN, 0),
					  DefaultEditorKit.pageDownAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
					  DefaultEditorKit.insertBreakAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_TAB, 0),
					  DefaultEditorKit.insertTabAction)
	};

	Object caretBlinkRate = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
		return new Integer(500);
	    }
	};

	// *** ToolTips
        Object toolTipBorder = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return BorderUIResource.getBlackLineBorderUIResource();
            }
        };
                       

	// *** ProgessBar
	Object progressBarBorder = new BorderUIResource(
	    new LineBorder(Color.green, 2));
                       

	// *** Buttons
	Object buttonBorder = new UIDefaults.LazyValue() {
	  public Object createValue(UIDefaults table) {
	    return new BorderUIResource(new CompoundBorder(
       					   BasicBorderFactory.getButtonBorder(),
	       				   BasicMarginBorder.getMarginBorder()));
	  }
	};

	Object buttonToggleBorder = new UIDefaults.LazyValue() {
	  public Object createValue(UIDefaults table) {
	    return new BorderUIResource(new CompoundBorder(
				      BasicBorderFactory.getToggleButtonBorder(),
				      BasicMarginBorder.getMarginBorder()));
	  }
	};

	Object radioButtonBorder = new UIDefaults.LazyValue() {
	  public Object createValue(UIDefaults table) {
	    return new BorderUIResource(new CompoundBorder(
				      BasicBorderFactory.getRadioButtonBorder(),
				      BasicMarginBorder.getMarginBorder()));
	  }
	};

	Object internalFrameBorder = new UIDefaults.LazyValue() {
	  public Object createValue(UIDefaults table) {
	    return new BorderUIResource( BorderFactory.createCompoundBorder(
				new BevelBorder(BevelBorder.RAISED,
					BasicGraphicsUtils.control,
					BasicGraphicsUtils.controlHighlight,
					BasicGraphicsUtils.controlBlack,
					BasicGraphicsUtils.controlShadow),
				BorderFactory.createLineBorder(
					BasicGraphicsUtils.control, 1)));
	  }
	};

	Object menuMarginBorder = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return new BorderUIResource(BasicMarginBorder.getMarginBorder());
	    }
	};
	  
	Object menuBarBorder = new UIDefaults.LazyValue(){
	  public Object createValue(UIDefaults table) {
	    return new BorderUIResource(BasicBorderFactory.getMenuBarBorder());
	  }
	};

	Object popupMenuBorder = new UIDefaults.LazyValue(){
	  public Object createValue(UIDefaults table) {
	    return new BorderUIResource(BorderFactory.createRaisedBevelBorder());
	  }
	};

	Object titledBorderBorder = new UIDefaults.LazyValue(){
	  public Object createValue(UIDefaults table) {
	    return new BorderUIResource(BorderFactory.createEtchedBorder());
	  };
	};

	Object toolBarBorder = new UIDefaults.LazyValue(){
	    public Object createValue(UIDefaults table) {
		return new BorderUIResource(//new CompoundBorder(
					    BorderFactory.createEtchedBorder()//,
					    //BasicMarginBorder.getMarginBorder())
		    );
	    }
	};

	Object selectedColorBorder = new UIDefaults.LazyValue(){
	  public Object createValue(UIDefaults table) {
	    return new BorderUIResource(BorderFactory.createLoweredBevelBorder());
	  };
	};

	Object menuItemCheckIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return BasicIconFactory.getMenuItemCheckIcon();
	    }
	};

	Object menuItemArrowIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return BasicIconFactory.getMenuItemArrowIcon();
	    }
	};

	Object menuArrowIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return BasicIconFactory.getMenuArrowIcon();
	    }
	};

	Object checkBoxIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return BasicIconFactory.getCheckBoxIcon();
	    }
	};

	Object radioButtonIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return BasicIconFactory.getRadioButtonIcon();
	    }
	};


	Object checkBoxMenuItemIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return BasicIconFactory.getCheckBoxMenuItemIcon();
	    }
	};

	Object radioButtonMenuItemIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return BasicIconFactory.getRadioButtonMenuItemIcon();
	    }
	};

	Object optionPaneBorder = new UIDefaults.LazyValue(){
	  public Object createValue(UIDefaults table) {
	    return new BorderUIResource(new EmptyBorder(10, 10, 12, 10));
	  };
	};

	// ** for table
	class DimensionUIResource extends java.awt.Dimension implements UIResource {
	  DimensionUIResource() { super(); };
	  DimensionUIResource(int x, int y) { super(x, y); };
	}

	Object cellEditorBorder = new UIDefaults.LazyValue(){
	  public Object createValue(UIDefaults table) {
	    return new BorderUIResource(LineBorder.createBlackLineBorder());
	  };
	};

	Object focusCellHighlightBorder = new BorderUIResource( new LineBorder(yellow) );

	Object splitPaneBorder = new BorderUIResource ( new BasicSplitPaneUI.SplitBorder(
								  table.getColor("controlHighlight"),
								  table.getColor("controlDkShadow") ) );

	Object[] defaults = {
	    "Desktop.background", table.get("desktop"),

	    "Panel.background", table.get("control"),
	    "Panel.foreground", table.get("textText"),
	    "Panel.font", dialogPlain12,

	    "Button.border", buttonBorder,
	    "Button.background", table.get("control"),
	    "Button.foreground", table.get("controlText"),
	    "Button.focus", table.get("controlText"),
	    "Button.font", dialogPlain12,
	    "Button.pressed", table.get("control"),

	    "ToggleButton.border", buttonToggleBorder,
	    "ToggleButton.background", table.get("control"),
	    "ToggleButton.foreground", table.get("controlText"),
	    "ToggleButton.focus", table.get("controlText"),
	    "ToggleButton.font", dialogPlain12,
	    "ToggleButton.pressed", table.get("control"),

	    "RadioButton.background", table.get("control"),
	    "RadioButton.foreground", table.get("controlText"),
	    "RadioButton.font", dialogPlain12,
	    "RadioButton.icon", radioButtonIcon,
	    "RadioButton.border", radioButtonBorder,
	    "RadioButton.focus", black,

	    "CheckBox.icon", checkBoxIcon,
	    "CheckBox.focus", black,

	    "RadioButtonMenuItem.icon", radioButtonMenuItemIcon,
	    "CheckBoxMenuItem.icon", checkBoxMenuItemIcon,

	    "MenuBar.border", menuBarBorder,
	    "MenuBar.background", table.get("menu"),
	    "MenuBar.foreground", table.get("menuText"),
	    "MenuBar.font", dialogPlain12,

	    "Menu.border", menuMarginBorder,
	    "Menu.font", dialogPlain12,
	    "Menu.foreground", table.get("menuText"),
	    "Menu.background", table.get("menu"),
	    "Menu.pressedForeground", menuItemPressedForeground,
	    "Menu.pressedBackground", menuItemPressedBackground,
	    "Menu.arrowIcon", menuArrowIcon,

	    "MenuItem.border", menuMarginBorder,
	    "MenuItem.borderPainted", Boolean.FALSE,
	    "MenuItem.font", dialogPlain12,
	    "MenuItem.foreground", table.get("menuText"),
	    "MenuItem.background", table.get("menu"),
	    "MenuItem.pressedForeground", menuItemPressedForeground,
	    "MenuItem.pressedBackground", menuItemPressedBackground,
	    "MenuItem.disabledForeground", null,
	    "MenuItem.acceleratorFont", dialogPlain12,
	    "MenuItem.acceleratorForeground", table.get("menuText"),
	    "MenuItem.acceleratorPressedForeground", menuItemPressedForeground,
	    "MenuItem.checkIcon", menuItemCheckIcon,
	    "MenuItem.arrowIcon", menuItemArrowIcon,

	    "PopupMenu.background", table.get("menu"),
	    "PopupMenu.border", popupMenuBorder,	    
	    "PopupMenu.foreground", table.get("menuText"),
	    "PopupMenu.font", dialogPlain12,

	    "Label.font", dialogPlain12,
	    "Label.background", table.get("control"),
	    "Label.foreground", table.get("controlText"),
	    "Label.disabled", white,
	    "Label.disabledShadow", table.get("controlShadow"),

	    "List.selectionBackground", table.get("textHighlight"), 
	    "List.selectionForeground", table.get("textHighlightText"),
 	    "List.background", table.get("window"),
	    "List.foreground", table.get("textText"),
	    "List.focusCellHighlightBorder", focusCellHighlightBorder,
	    "List.font", dialogPlain12,
	    "List.cellRenderer", listCellRendererActiveValue,
	    "List.border", null,

            "ComboBox.renderer", comboBoxRendererActiveValue,
            "ComboBox.editor",   comboBoxEditorActiveValue,
            "ComboBox.background", white/*table.get("text")*/,
            "ComboBox.foreground", black/*table.get("TextText")*/,
            "ComboBox.selectedBackground", table.get("textHighlight"),
            "ComboBox.selectedForeground", table.get("textHighlightText"),
            "ComboBox.font", dialogPlain12,
            "ComboBox.disabledBackground", table.get("control"),
            "ComboBox.disabledForeground", table.get("textInactiveText"),

	    "FileChooser.acceptAllFileFilterText", new String ("All Files (*.*)"),
            "FileChooser.cancelButtonText", new String("Cancel"),
            "FileChooser.saveButtonText", new String("Save"),
            "FileChooser.openButtonText", new String("Open"),
            "FileChooser.updateButtonText", new String("Update"),
            "FileChooser.helpButtonText", new String("Help"),

            "FileChooser.cancelButtonToolTipText", new String("Abort file chooser dialog."),
            "FileChooser.saveButtonToolTipText", new String("Save selected file."),
            "FileChooser.openButtonToolTipText", new String("Open selected file."),
            "FileChooser.updateButtonToolTipText", new String("Update directory listing."),
            "FileChooser.helpButtonToolTipText", new String("FileChooser help."),

	    "FileChooser.newFolderIcon", newFolderIcon,
            "FileChooser.upFolderIcon", upFolderIcon,
            "FileChooser.homeFolderIcon", homeFolderIcon, 
            "FileChooser.detailsViewIcon", detailsViewIcon,
            "FileChooser.listViewIcon", listViewIcon,

            "FileView.directoryIcon", directoryIcon,
            "FileView.fileIcon", fileIcon,
            "FileView.computerIcon", computerIcon,
            "FileView.hardDriveIcon", hardDriveIcon,
            "FileView.floppyDriveIcon", floppyDriveIcon,

	    "TextField.caretForeground", black,
	    "TextField.caretBlinkRate", caretBlinkRate,
	    "TextField.inactiveForeground", table.get("textInactiveText"),
	    "TextField.selectionBackground", table.get("textHighlight"),
	    "TextField.selectionForeground", table.get("textHighlightText"),
	    "TextField.background", table.get("window"),
	    "TextField.foreground", table.get("textText"),
	    "TextField.font", sansSerifPlain12,
	    "TextField.border", fieldTextBorder,
	    "TextField.keyBindings", fieldBindings,
	    
	    "PasswordField.caretForeground", black,
	    "PasswordField.caretBlinkRate", caretBlinkRate,
	    "PasswordField.inactiveForeground", table.get("textInactiveText"),
	    "PasswordField.selectionBackground", table.get("textHighlight"),
	    "PasswordField.selectionForeground", table.get("textHighlightText"),
	    "PasswordField.background", table.get("window"),
	    "PasswordField.foreground", table.get("textText"),
	    "PasswordField.font", monospacedPlain12,
	    "PasswordField.border", fieldTextBorder,
	    "PasswordField.keyBindings", fieldBindings,
	    
	    "TextArea.caretForeground", black,
	    "TextArea.caretBlinkRate", caretBlinkRate,
	    "TextArea.inactiveForeground", table.get("textInactiveText"),
	    "TextArea.selectionBackground", table.get("textHighlight"),
	    "TextArea.selectionForeground", table.get("textHighlightText"),
	    "TextArea.background", table.get("window"),
	    "TextArea.foreground", table.get("textText"),
	    "TextArea.font", monospacedPlain12,
	    "TextArea.border", multilineTextBorder,
	    "TextArea.keyBindings", multilineBindings,
	    
	    "TextPane.caretForeground", black,
	    "TextPane.inactiveForeground", table.get("textInactiveText"),
	    "TextPane.selectionBackground", lightGray,
	    "TextPane.selectionForeground", table.get("textHighlightText"),
	    "TextPane.background", white,
	    "TextPane.foreground", table.get("textText"),
	    "TextPane.font", serifPlain12,
	    "TextPane.border", multilineTextBorder,
	    "TextPane.keyBindings", multilineBindings,
	    
	    "EditorPane.caretForeground", red,
	    "EditorPane.inactiveForeground", table.get("textInactiveText"),
	    "EditorPane.selectionBackground", lightGray,
	    "EditorPane.selectionForeground", table.get("textHighlightText"),
	    "EditorPane.background", white,
	    "EditorPane.foreground", table.get("textText"),
	    "EditorPane.font", serifPlain12,
	    "EditorPane.border", multilineTextBorder,
	    "EditorPane.keyBindings", multilineBindings,
	    
	    "ScrollBar.background", scrollBarTrack,
	    "ScrollBar.foreground", table.get("control"),
	    "ScrollBar.track", scrollBarTrack,
	    "ScrollBar.trackHighlight", table.get("controlDkShadow"),
	    "ScrollBar.thumb", table.get("control"),
	    "ScrollBar.thumbHighlight", table.get("controlHighlight"),
	    "ScrollBar.thumbDarkShadow", table.get("controlDkShadow"),
	    "ScrollBar.thumbLightShadow", table.get("controlShadow"),
	    "ScrollBar.border", null,
 
	    "ScrollPane.border", scrollPaneBorder,
	    "ScrollPane.font", dialogPlain12,
	    "ScrollPane.background", table.get("control"),
	    "ScrollPane.foreground", table.get("controlText"),
	    "ScrollPane.viewportBorder", null,

	    "Slider.border", null,
	    "Slider.foreground", table.get("control"),
	    "Slider.background", table.get("control"),
	    "Slider.highlight", table.get("controlHighlight"),
	    "Slider.shadow", table.get("controlShadow"),
	    "Slider.focus", table.get("controlDkShadow"),

	    "SplitPane.background", table.get("control"),
	    "SplitPane.highlight", table.get("controllHighlight"),
	    "SplitPane.shadow", table.get("controlShadow"),
	    "SplitPane.border", splitPaneBorder,
	    "SplitPane.dividerSize", new Integer(5),

            "TabbedPane.font", dialogPlain12,
            "TabbedPane.tabBackground", table.get("control"),
            "TabbedPane.tabForeground", table.get("controlText"),
            "TabbedPane.tabHighlight", table.get("controlHighlight"),
            "TabbedPane.tabShadow", table.get("controlShadow"),
            "TabbedPane.tabDarkShadow", table.get("controlDkShadow"),
            "TabbedPane.focus", black,

	    "Table.font", dialogPlain12,
	    "Table.foreground", table.get("controlText"),  // cell text color
	    "Table.background", table.get("window"),  // cell background color
	    "Table.selectionForeground", table.get("textHighlightText"),
	    "Table.selectionBackground", table.get("textHighlight"),
      	    "Table.gridColor", gray,  // grid line color
	    "Table.focusCellHighlightBorder", focusCellHighlightBorder,
	    "Table.focusCellBackground", table.get("window"),
	    "Table.focusCellForeground", table.get("controlText"),
	    "Table.scrollPaneBorder", tableScrollPaneBorder,

	    "TableHeader.font", dialogPlain12, 
	    "TableHeader.foreground", table.get("controlText"), // header text color
	    "TableHeader.background", table.get("control"), // header background
	    "TableHeader.cellBorder", BorderFactory.createRaisedBevelBorder(),
   

            "TitledBorder.font", dialogPlain12,
            "TitledBorder.titleColor", table.get("controlText"),
            "TitledBorder.border", titledBorderBorder,

	    "ToolBar.border", toolBarBorder,
	    "ToolBar.background", table.get("control"),
	    "ToolBar.foreground", table.get("controlText"),
	    "ToolBar.font", dialogPlain12,
	    "ToolBar.dockingColor", table.get("control"),
	    "ToolBar.floatingColor", table.get("control"),
	    "ToolBar.dockingBorderColor", red, 
	    "ToolBar.floatingBorderColor", darkGray,
	    
            "ToolTip.font", sansSerifPlain12,
            "ToolTip.border", toolTipBorder,
            "ToolTip.background", table.get("info"),
            "ToolTip.foreground", table.get("infoText"),

	    "Tree.background", white,
	    "Tree.font", dialogPlain12,
	    "Tree.hash", gray,
	    "Tree.textSelectionColor", white,
	    "Tree.textNonSelectionColor", black,
	    "Tree.borderSelectionColor", black,
	    "Tree.backgroundSelectionColor", treeSelection,
	    "Tree.backgroundNonSelectionColor", white,
	    "Tree.openIcon", LookAndFeel.makeIcon(getClass(), "icons/TreeOpen.gif"),
	    "Tree.closedIcon", LookAndFeel.makeIcon(getClass(), "icons/TreeClosed.gif"),
	    "Tree.leafIcon", LookAndFeel.makeIcon(getClass(), "icons/TreeLeaf.gif"),
	    "Tree.expandedIcon", null,
	    "Tree.collapsedIcon", null,

	    "ProgressBar.font", dialogPlain12,
	    "ProgressBar.foreground",  table.get("textHighlight"), 
	    "ProgressBar.background", table.get("control"), 
	    "ProgressBar.border", progressBarBorder,
            "ProgressBar.cellLength", new Integer(1),
            "ProgressBar.cellSpacing", new Integer(0),

	    "OptionPane.font", dialogPlain12,
	    "OptionPane.background", table.get("control"),
	    "OptionPane.foreground", table.get("controlText"),
	    "OptionPane.border", optionPaneBorder,

	    "OptionPane.errorIcon", LookAndFeel.makeIcon(getClass(), "icons/Error.gif"),
	    "OptionPane.informationIcon", LookAndFeel.makeIcon(getClass(), "icons/Inform.gif"),
	    "OptionPane.warningIcon", LookAndFeel.makeIcon(getClass(), "icons/Warn.gif"),
	    "OptionPane.questionIcon", LookAndFeel.makeIcon(getClass(), "icons/Question.gif"),

            "ColorChooser.font", dialogPlain12,
            "ColorChooser.background", table.get("control"),
            "ColorChooser.foreground", table.get("controlText"),
            "ColorChooser.selectedColorBorder", selectedColorBorder,

            "InternalFrame.icon", LookAndFeel.makeIcon(getClass(), "icons/JavaCup.gif"),
	    "InternalFrame.border", internalFrameBorder,
            "InternalFrame.titleFont", dialogBold12,

            // Default frame icons are undefined for Basic.
            "InternalFrame.maximizeIcon", BasicIconFactory.createEmptyFrameIcon(),
            "InternalFrame.minimizeIcon", BasicIconFactory.createEmptyFrameIcon(),
            "InternalFrame.iconifyIcon", BasicIconFactory.createEmptyFrameIcon(),
            "InternalFrame.closeIcon", BasicIconFactory.createEmptyFrameIcon(),

	    "DesktopIcon.border", null
	};

	table.putDefaults(defaults);
    }

}
