/*
 * @(#)BasicInternalFrameUI.java	1.36 98/02/04
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.basic;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import java.beans.*;
import java.util.EventListener;
import java.io.Serializable;


/**
 * A basic L&F implementation of JInternalFrame.  
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.36 02/04/98
 * @author David Kloba
 */
public class BasicInternalFrameUI extends InternalFrameUI 
    implements LayoutManager, PropertyChangeListener, Serializable,
               MouseListener
{
    protected JInternalFrame frame;
    protected EventListener borderListener;
    protected JComponent northPane;
    protected JComponent southPane;
    protected JComponent westPane;
    protected JComponent eastPane;

    protected static DesktopManager sharedDesktopManager;

/////////////////////////////////////////////////////////////////////////////
// ComponentUI Interface Implementation methods
/////////////////////////////////////////////////////////////////////////////
    public static ComponentUI createUI(JComponent b)    {
        return new BasicInternalFrameUI((JInternalFrame)b);
    }

    public BasicInternalFrameUI(JInternalFrame b)   {
    }
            
    public void installUI(JComponent c)   {

        frame = (JInternalFrame)c;        
	frame.add(frame.getRootPane(), "Center");

	installDefaults(frame);

        borderListener = createBorderListener(frame);

	frame.addPropertyChangeListener(this);
        frame.setLayout(this);         

	setNorthPane(createNorthPane(frame));
	setSouthPane(createSouthPane(frame));
	setEastPane(createEastPane(frame));
	setWestPane(createWestPane(frame));

//        if(frame.getContentPane() == null) {
//            frame.setContentPane(createContentPane(frame));
//        } else {
////            installMouseHandlers((JComponent)frame.getContentPane());
//        }
        installMouseHandlers(frame);
	
	frame.setOpaque(true);
	frame.setMinimumSize(new Dimension(120, 24));
    }   

    public void uninstallUI(JComponent c) {
        if(c != frame)
            throw new IllegalComponentStateException(
                this + " was asked to deinstall() " 
                + c + " when it only knows about " 
                + frame + "."); 
                
	uninstallDefaults(frame);

	frame.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));	

	setNorthPane(null);
	setSouthPane(null);
	setEastPane(null);
	setWestPane(null);
        frame.setLayout(null);
//        deinstallMouseHandlers((JComponent)frame.getContentPane());
        deinstallMouseHandlers(frame);
        borderListener = null;
        frame.removePropertyChangeListener(this);
        frame.remove(frame.getRootPane());	
        frame = null;
    }
    
    protected void installDefaults(JInternalFrame frame) {
	Icon frameIcon = frame.getFrameIcon();
        if (frameIcon == null || frameIcon instanceof UIResource) {
            frame.setFrameIcon(UIManager.getIcon("InternalFrame.icon"));
        }
	
	LookAndFeel.installBorder(frame, "InternalFrame.border");
    }

    protected void uninstallDefaults(JInternalFrame frame) {
	Icon frameIcon = frame.getFrameIcon();
        if (frameIcon instanceof UIResource) {
            frame.setFrameIcon(null);
        }
	LookAndFeel.uninstallBorder(frame);
    }

    public Dimension getPreferredSize(JComponent x)    {
	if((JComponent)frame == x)
	    return frame.getLayout().preferredLayoutSize(x);
        return new Dimension(100, 100);
    }
    
    public Dimension getMinimumSize(JComponent x)  {
	if((JComponent)frame == x)
	    return frame.getLayout().minimumLayoutSize(x);
        return new Dimension(0, 0);
    }
    
    public Dimension getMaximumSize(JComponent x) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
    

    /** Detects changes in state from the JInternalFrame and handles actions.*/
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = (String)evt.getPropertyName();
        JInternalFrame f = (JInternalFrame)evt.getSource();
	Object newValue = evt.getNewValue();
	Object oldValue = evt.getOldValue();
	// ASSERT(frame == f) - This should always be true

        if(JInternalFrame.ROOT_PANE_PROPERTY.equals(prop)) {
	    if(oldValue != null)
		frame.remove((Component)oldValue);
	    if(newValue != null)
		frame.add((Component)newValue);
	/// Handle the action events from the Frame
	} else if(JInternalFrame.IS_CLOSED_PROPERTY.equals(prop)) {
	    if(newValue == Boolean.TRUE)
	        closeFrame(f);
	} else if(JInternalFrame.IS_MAXIMUM_PROPERTY.equals(prop)) {
	    if(newValue == Boolean.TRUE)
		maximizeFrame(f);
	    else
	        minimizeFrame(f);
	} else if(JInternalFrame.IS_ICON_PROPERTY.equals(prop)) {
	    if(newValue == Boolean.TRUE)
		iconifyFrame(f);
	    else
	        deiconifyFrame(f);
	} else if(JInternalFrame.IS_SELECTED_PROPERTY.equals(prop)) {
	    if(newValue == Boolean.TRUE
	            && oldValue == Boolean.FALSE) {
		activateFrame(f);
	    } else if(newValue == Boolean.FALSE
	            && oldValue == Boolean.TRUE) {
		deactivateFrame(f);
	    }
	}
    }
			
    /** Adds necessary mouseHandlers to currentPane and adds it to frame.
      * Reverse process for the newPane. 
      */
    protected void replacePane(JComponent currentPane, JComponent newPane) {
        if(currentPane != null) {
            deinstallMouseHandlers(currentPane);
            frame.remove(currentPane);
        }
        if(newPane != null) {
           frame.add(newPane);
           installMouseHandlers(newPane);
        }
    }

    protected void deinstallMouseHandlers(JComponent c) {
        if(c != null) {
            if(borderListener instanceof MouseListener)
                c.removeMouseListener((MouseListener)borderListener);
            if(borderListener instanceof MouseMotionListener)
                c.removeMouseMotionListener((MouseMotionListener)borderListener);
        }
    }
  
    protected void installMouseHandlers(JComponent c) {
        if(c != null) {
            if(borderListener instanceof MouseListener)
                c.addMouseListener((MouseListener)borderListener);
            if(borderListener instanceof MouseMotionListener)
                c.addMouseMotionListener((MouseMotionListener)borderListener);
        }
    }
    
    protected JComponent createNorthPane(JInternalFrame w) {
        return new BasicInternalFrameTitlePane(w);
    }

    protected JComponent createSouthPane(JInternalFrame w) {
	return null;
    }

    protected JComponent createWestPane(JInternalFrame w) {
        return null;
    }

    protected JComponent createEastPane(JInternalFrame w) {
        return null;
    }

//    protected JComponent createContentPane(JInternalFrame w) {
//	JComponent p = new JComponent();
//	p.setLayout(new BorderLayout());
//        return p;
//    }

    protected EventListener createBorderListener(JInternalFrame w) {
        return new BorderListener();
    }

    public JComponent getNorthPane() {
        return northPane;
    }

    public void setNorthPane(JComponent c) {
        replacePane(northPane, c);
        northPane = c;
    }

    public JComponent getSouthPane() {
        return southPane;
    }

    public void setSouthPane(JComponent c) {
//        replacePane(southPane, c);
        southPane = c;
    }

    public JComponent getWestPane() {
        return westPane;
    }

    public void setWestPane(JComponent c) {
//        replacePane(westPane, c);
        westPane = c;
    }

    public JComponent getEastPane() {
        return eastPane;
    }

    public void setEastPane(JComponent c) {
//        replacePane(eastPane, c);
        eastPane = c;
    }

    public void addLayoutComponent(String name, Component c) {}
    public void removeLayoutComponent(Component c) {}    
    public Dimension preferredLayoutSize(Container c)  {
	Dimension result;
	Insets i = frame.getInsets();
	
	result = frame.getRootPane().getPreferredSize();
	result.width += i.left + i.right;
	result.height += i.top + i.bottom;

        if(getNorthPane() != null) {
	    Dimension d = getNorthPane().getPreferredSize();
	    result.width = Math.max(d.width, result.width);
            result.height += d.height;
	}

        if(getSouthPane() != null) {
	    Dimension d = getSouthPane().getPreferredSize();
	    result.width = Math.max(d.width, result.width);
            result.height += d.height;
	}

        if(getEastPane() != null) {
	    Dimension d = getEastPane().getPreferredSize();
            result.width += d.width;
	    result.height = Math.max(d.height, result.height);
	}

        if(getWestPane() != null) {
	    Dimension d = getWestPane().getPreferredSize();
            result.width += d.width;
	    result.height = Math.max(d.height, result.height);
	}

	return result;
    }
    
    public Dimension minimumLayoutSize(Container c) {
	Dimension result;
	Insets i = frame.getInsets();
	
	result = frame.getRootPane().getMinimumSize();
	result.width += i.left + i.right;
	result.height += i.top + i.bottom;

        if(getNorthPane() != null) {
	    Dimension d = getNorthPane().getMinimumSize();
	    result.width = Math.max(d.width, result.width);
            result.height += d.height;
	}

        if(getSouthPane() != null) {
	    Dimension d = getSouthPane().getMinimumSize();
	    result.width = Math.max(d.width, result.width);
            result.height += d.height;
	}

        if(getEastPane() != null) {
	    Dimension d = getEastPane().getMinimumSize();
            result.width += d.width;
	    result.height = Math.max(d.height, result.height);
	}

        if(getWestPane() != null) {
	    Dimension d = getWestPane().getMinimumSize();
            result.width += d.width;
	    result.height = Math.max(d.height, result.height);
	}

	return result;
    }
    
    public void layoutContainer(Container c) {
        Insets i = frame.getInsets();
        int cx, cy, cw, ch;
        
        cx = i.left;
        cy = i.top;
        cw = frame.getWidth() - i.left - i.right;
        ch = frame.getHeight() - i.top - i.bottom;
        
        if(getNorthPane() != null) {
            Dimension size = getNorthPane().getPreferredSize();
            getNorthPane().setBounds(cx, cy, cw, size.height);
            cy += size.height;
            ch -= size.height;
        }

        if(getSouthPane() != null) {
            Dimension size = getSouthPane().getPreferredSize();
            getSouthPane().setBounds(cx, frame.getHeight() 
                                                - i.bottom - size.height, 
                                                cw, size.height);
            ch -= size.height;
        }

        if(getWestPane() != null) {
            Dimension size = getWestPane().getPreferredSize();
            getWestPane().setBounds(cx, cy, size.width, ch);
            cw -= size.width;
            cx += size.width;           
        }

        if(getEastPane() != null) {
            Dimension size = getEastPane().getPreferredSize();
            getEastPane().setBounds(cw - size.width, cy, size.width, ch);
            cw -= size.width;           
        }
        
        if(frame.getRootPane() != null) {
            frame.getRootPane().setBounds(cx, cy, cw, ch);
        }
    }

/// DesktopManager methods
    /** Returns the proper DesktopManager. Calls getDesktopPane() to 
      * find the JDesktop component and returns the desktopManager from
      * it. If this fails, it will return a default DesktopManager that 
      * should work in arbitrary parents.
      */
    protected DesktopManager getDesktopManager() {
	if(frame.getDesktopPane() != null 
		&& frame.getDesktopPane().getDesktopManager() != null)
	    return frame.getDesktopPane().getDesktopManager();
	if(sharedDesktopManager == null)
	    sharedDesktopManager = new DefaultDesktopManager();
	return sharedDesktopManager;	
    }

    /** This method is called when the user wants to close the frame.
      * This action is delegated to the desktopManager.
      */
    protected void closeFrame(JInternalFrame f) {	
	getDesktopManager().closeFrame(f);
    }
    /** This method is called when the user wants to maximize the frame.
      * This action is delegated to the desktopManager.
      */
    protected void maximizeFrame(JInternalFrame f) {	
	getDesktopManager().maximizeFrame(f);
    }
    /** This method is called when the user wants to minimize the frame.
      * This action is delegated to the desktopManager.
      */
    protected void minimizeFrame(JInternalFrame f) {
	getDesktopManager().minimizeFrame(f);
    }
    /** This method is called when the user wants to iconify the frame.
      * This action is delegated to the desktopManager.
      */
    protected void iconifyFrame(JInternalFrame f) {
	getDesktopManager().iconifyFrame(f);
    }
    /** This method is called when the user wants to deiconify the frame.
      * This action is delegated to the desktopManager.
      */
    protected void deiconifyFrame(JInternalFrame f) {
	getDesktopManager().deiconifyFrame(f);
    }
    /** This method is called when the frame becomes selected.
      * This action is delegated to the desktopManager.
      */
    protected void activateFrame(JInternalFrame f) {
	getDesktopManager().activateFrame(f);
    }
    /** This method is called when the frame is no longer selected.
      * This action is delegated to the desktopManager.
      */
    protected void deactivateFrame(JInternalFrame f) {
	getDesktopManager().deactivateFrame(f);
    }

    /**
     * Forward mouse events on to border -- used when the frame is
     * inactive to reactivate it when the mouse is clicked over it.
     */
    public void mousePressed(MouseEvent e) {
        ((BorderListener)borderListener).mousePressed(e);
    }

    /*
     * Unused mouse event handlers.
     */
    public void mouseClicked(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}

    /////////////////////////////////////////////////////////////////////////
    /// Border Listener Class
    /////////////////////////////////////////////////////////////////////////        
    /**
     * Listens for border adjustments.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    protected class BorderListener extends MouseAdapter
        implements MouseMotionListener, SwingConstants, Serializable
    {
	// _x & _y are the mousePressed location in absolute coordinate system
        int _x, _y;
	// __x & __y are the mousePressed location in source view's coordinate system
	int __x, __y;
        Rectangle startingBounds;
        int resizeDir;
        
        protected final int RESIZE_NONE  = 0;
                
        int resizeCornerSize = 16;
        
        public void mouseReleased(MouseEvent e) {
	    if(resizeDir == RESIZE_NONE)
	        getDesktopManager().endDraggingFrame(frame);	
	    else
	        getDesktopManager().endResizingFrame(frame);	
            _x = 0;
            _y = 0;
            __x = 0;
            __y = 0;
            startingBounds = null;
            resizeDir = RESIZE_NONE;
        }
                
        public void mousePressed(MouseEvent e) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), 
                        e.getX(), e.getY(), null);
            __x = e.getX();
            __y = e.getY();
            _x = p.x;
            _y = p.y;
            startingBounds = frame.getBounds();

            if(!frame.isSelected()) {
                try { frame.setSelected(true); } catch (PropertyVetoException e1) { }
            }

            if(e.getClickCount() > 1 && e.getSource() == getNorthPane()) {
		if(frame.isIconifiable() && frame.isIcon()) {
                    try { frame.setIcon(false); } catch (PropertyVetoException e2) { }
		} else if(frame.isMaximizable()) {
                    if(!frame.isMaximum())
                        try { frame.setMaximum(true); } catch (PropertyVetoException e2) { }
                    else
                        try { frame.setMaximum(false); } catch (PropertyVetoException e3) { }
		} 
            }

            if(!frame.isResizable() || e.getSource() == getNorthPane()) {
                resizeDir = RESIZE_NONE;
		getDesktopManager().beginDraggingFrame(frame);
                return;
            }       

            if(e.getSource() == frame) {
                Insets i = frame.getInsets();
                if(e.getX() <= i.left) {
                    if(e.getY() < resizeCornerSize + i.top)
                        resizeDir = NORTH_WEST;
                    else if(e.getY() > frame.getHeight() 
					- resizeCornerSize - i.bottom)
                        resizeDir = SOUTH_WEST;
                    else                
                        resizeDir = WEST;
                } else if(e.getX() >= frame.getWidth() - i.right) {
                    if(e.getY() < resizeCornerSize + i.top)
                        resizeDir = NORTH_EAST;
                    else if(e.getY() > frame.getHeight() 
				- resizeCornerSize - i.bottom)
                        resizeDir = SOUTH_EAST;
                    else                
                        resizeDir = EAST;
                } else if(e.getY() <= i.top) {
                    if(e.getX() < resizeCornerSize + i.left)
                        resizeDir = NORTH_WEST;
                    else if(e.getX() > frame.getWidth() 
				- resizeCornerSize - i.right)
                        resizeDir = NORTH_EAST;
                    else                
                        resizeDir = NORTH;
                } else if(e.getY() >= frame.getHeight() - i.bottom) {
                    if(e.getX() < resizeCornerSize + i.left)
                        resizeDir = SOUTH_WEST;
                    else if(e.getX() > frame.getWidth() 
				- resizeCornerSize - i.right)
                        resizeDir = SOUTH_EAST;
                    else                
                        resizeDir = SOUTH;
                } 
	        getDesktopManager().beginResizingFrame(frame, resizeDir);
                return;
            }
        }

        public void mouseDragged(MouseEvent e) {   

	    if ( startingBounds == null ) {
	      // (STEVE) Yucky work around for bug ID 4106552
		 return;
	    }
                                     
            Point p; 
	    int newX, newY, newW, newH;
            int deltaX;
            int deltaY;
	    Dimension min;
	    Dimension max;
            p = SwingUtilities.convertPoint((Component)e.getSource(), 
                                        e.getX(), e.getY(), null);
        
            // Handle a MOVE 
            if(e.getSource() == getNorthPane()) {
                if (frame.isMaximum()) {
                    return;  // don't allow moving of maximized frames.
                }
		Insets i = frame.getInsets();
		int pWidth, pHeight;
		Dimension s = frame.getParent().getSize();
		pWidth = s.width;
		pHeight = s.height;


	        newX = startingBounds.x - (_x - p.x);
	        newY = startingBounds.y - (_y - p.y);
		// Make sure we stay in-bounds
		if(newX + i.left <= -__x)
		    newX = -__x - i.left;
		if(newY + i.top <= -__y)
		    newY = -__y - i.top;
		if(newX + __x + i.right > pWidth)
		    newX = pWidth - __x - i.right;
		if(newY + __y + i.bottom > pHeight)
		    newY =  pHeight - __y - i.bottom;

		getDesktopManager().dragFrame(frame, newX, newY);
                return;
            }

            if(!frame.isResizable()) {
                return;
            }

	    min = frame.getMinimumSize();
	    max = frame.getMaximumSize();
        
            deltaX = _x - p.x;
            deltaY = _y - p.y;

	    newX = frame.getX();
	    newY = frame.getY();
	    newW = frame.getWidth();
	    newH = frame.getHeight();

            switch(resizeDir) {
            case RESIZE_NONE:
                return;
            case NORTH:      
		if(startingBounds.height + deltaY < min.height)
		    deltaY = -(startingBounds.height - min.height);
		else if(startingBounds.height + deltaY > max.height)
		    deltaY = (startingBounds.height - min.height);

		newX = startingBounds.x;
		newY = startingBounds.y - deltaY;
		newW = startingBounds.width;
		newH = startingBounds.height + deltaY;
                break;
            case NORTH_EAST:     
		if(startingBounds.height + deltaY < min.height)
		    deltaY = -(startingBounds.height - min.height);
		else if(startingBounds.height + deltaY > max.height)
		    deltaY = (startingBounds.height - min.height);

		if(startingBounds.width - deltaX < min.width)
		    deltaX = (startingBounds.width - min.width);
		else if(startingBounds.width - deltaX > max.width)
		    deltaX = -(startingBounds.width - min.width);

		newX = startingBounds.x;
		newY = startingBounds.y - deltaY;
		newW = startingBounds.width - deltaX;
		newH = startingBounds.height + deltaY;
                break;
            case EAST:      
		if(startingBounds.width - deltaX < min.width)
		    deltaX = (startingBounds.width - min.width);
		else if(startingBounds.width - deltaX > max.width)
		    deltaX = -(startingBounds.width - min.width);

		newW = startingBounds.width - deltaX;
		newH = startingBounds.height;
                break;
            case SOUTH_EAST:     
		if(startingBounds.width - deltaX < min.width)
		    deltaX = (startingBounds.width - min.width);
		else if(startingBounds.width - deltaX > max.width)
		    deltaX = -(startingBounds.width - min.width);

		if(startingBounds.height - deltaY < min.height)
		    deltaY = (startingBounds.height - min.height);
		else if(startingBounds.height - deltaY > max.height)
		    deltaY = -(startingBounds.height - min.height);
	
		newW = startingBounds.width - deltaX;
		newH = startingBounds.height - deltaY;
                break;
            case SOUTH:      
		if(startingBounds.height - deltaY < min.height)
		    deltaY = (startingBounds.height - min.height);
		else if(startingBounds.height - deltaY > max.height)
		    deltaY = -(startingBounds.height - min.height);

 		newW = startingBounds.width;
		newH = startingBounds.height - deltaY;
                break;
            case SOUTH_WEST:
		if(startingBounds.height - deltaY < min.height)
		    deltaY = (startingBounds.height - min.height);
		else if(startingBounds.height - deltaY > max.height)
		    deltaY = -(startingBounds.height - min.height);

		if(startingBounds.width + deltaX < min.width)
		    deltaX = -(startingBounds.width - min.width);
		else if(startingBounds.width + deltaX > max.width)
		    deltaX = (startingBounds.width - min.width);

		newX = startingBounds.x - deltaX;
		newY = startingBounds.y;
		newW = startingBounds.width + deltaX;
		newH = startingBounds.height - deltaY;
                break;
            case WEST:      
		if(startingBounds.width + deltaX < min.width)
		    deltaX = -(startingBounds.width - min.width);
		else if(startingBounds.width + deltaX > max.width)
		    deltaX = (startingBounds.width - min.width);

		newX = startingBounds.x - deltaX;
		newY = startingBounds.y;
		newW = startingBounds.width + deltaX;
		newH = startingBounds.height;
                break;
            case NORTH_WEST:     
		if(startingBounds.width + deltaX < min.width)
		    deltaX = -(startingBounds.width - min.width);
		else if(startingBounds.width + deltaX > max.width)
		    deltaX = (startingBounds.width - min.width);

		if(startingBounds.height + deltaY < min.height)
		    deltaY = -(startingBounds.height - min.height);
		else if(startingBounds.height + deltaY > max.height)
		    deltaY = (startingBounds.height - min.height);

		newX = startingBounds.x - deltaX;
		newY = startingBounds.y - deltaY;
		newW = startingBounds.width + deltaX;
		newH = startingBounds.height + deltaY;
                break;
            default:
                return;
            }

	    getDesktopManager().resizeFrame(frame, newX, newY, newW, newH);
	}

        public void mouseMoved(MouseEvent e)    {

	    if(!frame.isResizable())
		return;
		
            if(e.getSource() == frame) {
                Insets i = frame.getInsets();
                if(e.getX() <= i.left) {
                    if(e.getY() < resizeCornerSize + i.top)
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.NW_RESIZE_CURSOR));
                    else if(e.getY() > frame.getHeight() - resizeCornerSize - i.bottom)
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.SW_RESIZE_CURSOR));
                    else                
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.W_RESIZE_CURSOR));
                } else if(e.getX() >= frame.getWidth() - i.right) {
                    if(e.getY() < resizeCornerSize + i.top)
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.NE_RESIZE_CURSOR));
                    else if(e.getY() > frame.getHeight() - resizeCornerSize - i.bottom)
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.SE_RESIZE_CURSOR));
                    else                
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.E_RESIZE_CURSOR));
                } else if(e.getY() <= i.top) {
                    if(e.getX() < resizeCornerSize + i.left)
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.NW_RESIZE_CURSOR));
                    else if(e.getX() > frame.getWidth() - resizeCornerSize - i.right)
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.NE_RESIZE_CURSOR));
                    else                
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.N_RESIZE_CURSOR));
                } else if(e.getY() >= frame.getHeight() - i.bottom) {
                    if(e.getX() < resizeCornerSize + i.left)
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.SW_RESIZE_CURSOR));
                    else if(e.getX() > frame.getWidth() - resizeCornerSize - i.right)
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.SE_RESIZE_CURSOR));
                    else                
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.S_RESIZE_CURSOR));
                }
		return;
            }

	    frame.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));	
	}         

        public void mouseExited(MouseEvent e)    {
	    frame.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));	
	}
    };    /// End BorderListener Class

}   /// End BasicInternalFrameUI Class

