/*
 * @(#)BasicInternalFrameTitlePane.java	1.16 98/04/10
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.basic;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.event.InternalFrameEvent;
import java.util.EventListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.beans.PropertyVetoException;

/**
 * The class that manages a basic title bar
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.16 04/10/98
 * @author David Kloba
 */
public class BasicInternalFrameTitlePane 
    extends JComponent implements LayoutManager, ActionListener, PropertyChangeListener 
{
    JMenuBar menuBar;
    JButton iconButton;
    JButton maxButton;
    JButton closeButton;
    Icon maxIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
    Icon minIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
    Icon iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
    Icon closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
    JMenu windowMenu;
    JInternalFrame frame;

    private static Color selectedTitleColor = new Color(0, 0, 128);
    private static Color selectedTextColor = new Color(255, 255, 255);
    private static Color notSelectedTitleColor = new Color(128, 128, 128);
    private static Color notSelectedTextColor = new Color(192, 192, 192);

	
	final int RESTORE_MENU_ITEM = 0;
	final int MOVE_MENU_ITEM = 1;
	final int SIZE_MENU_ITEM = 2;
	final int MINIMIZE_MENU_ITEM = 3;
	final int MAXIMIZE_MENU_ITEM = 4;
	final int SEPARATOR_MENU_ITEM = 5;
	final int CLOSE_MENU_ITEM = 6;
	
    private class NoFocusButton extends JButton {
	public boolean isFocusTraversable() { return false; }
	public void requestFocus() {};
        public boolean isOpaque() { return true; }
    };

    public BasicInternalFrameTitlePane(JInternalFrame f) {
	JMenuItem mi;

	frame = f;
	
	setPreferredSize(new Dimension(100, 18));

	menuBar = new JMenuBar(){
	    public boolean isFocusTraversable() { return false; }
	    public void requestFocus() {}
	    public void paint(Graphics g) {
                Icon icon = frame.getFrameIcon();
                if (icon == null) {
                    icon = UIManager.getIcon("InternalFrame.icon");
                }
                if (icon != null) {
                    // Resize to 16x16 if necessary.
                    if (icon instanceof ImageIcon &&
                        (icon.getIconWidth() > 16 || 
                         icon.getIconHeight() > 16)) {
                        Image img = ((ImageIcon)icon).getImage();
                        ((ImageIcon)icon).setImage(
                            img.getScaledInstance(16, 16, Image.SCALE_SMOOTH));
                    }
                    icon.paintIcon(this, g, 0, 0);
                }
            }
	    public boolean isOpaque() { return true; }
	};
	
	menuBar.setBorderPainted(false);
	windowMenu = (JMenu) menuBar.add(new JMenu("    ") {
	    boolean neverBeenSet = true;
	    public void setPopupMenuVisible(boolean b) {
		if(neverBeenSet) {
		    if(!frame.isIconifiable())
			windowMenu.getItem(MINIMIZE_MENU_ITEM).setEnabled(false);
		    if(!frame.isMaximizable()) 
			windowMenu.getItem(MAXIMIZE_MENU_ITEM).setEnabled(false);
		    if(!frame.isMaximizable() && !frame.isIconifiable()) 
			windowMenu.getItem(RESTORE_MENU_ITEM).setEnabled(false);
		    if(!frame.isClosable())	
			windowMenu.getItem(CLOSE_MENU_ITEM).setEnabled(false);			
		    neverBeenSet = false;
		}
		super.setPopupMenuVisible(b);
	    }	      		
	});
	
	mi = (JMenuItem) windowMenu.add(new JMenuItem("Restore"));
	mi.setEnabled(false);
	mi.addActionListener(this);
	/// PENDING(klobad) Move/Size actions on InternalFrame need to be determined
	mi = (JMenuItem) windowMenu.add(new JMenuItem("Move"));
	mi.setEnabled(false);
	mi.addActionListener(this);
	mi = (JMenuItem) windowMenu.add(new JMenuItem("Size"));
	mi.setEnabled(false);
	mi.addActionListener(this);
	mi = (JMenuItem) windowMenu.add(new JMenuItem("Minimize"));
	mi.addActionListener(this);
	mi = (JMenuItem) windowMenu.add(new JMenuItem("Maximize"));
	mi.addActionListener(this);
	windowMenu.add(new JSeparator());
	mi = (JMenuItem) windowMenu.add(new JMenuItem("Close"));
	mi.addActionListener(this); 
	
	iconButton = new NoFocusButton();
	iconButton.setFocusPainted(false);
	iconButton.addActionListener(this);
	iconButton.setActionCommand("Iconify");

	maxButton = new NoFocusButton();
	maxButton.setFocusPainted(false);
	maxButton.addActionListener(this);
	maxButton.setActionCommand("Maximize");

        setButtonIcons();

	closeButton = new NoFocusButton();
	closeButton.setIcon(closeIcon);
	closeButton.setFocusPainted(false);     
	closeButton.addActionListener(this);
	closeButton.setActionCommand("Close");
            
	setLayout(this);

	add(menuBar);
	add(iconButton);
	add(maxButton);
	add(closeButton);             

	// Make sure these are ok to leave on?
	frame.addPropertyChangeListener(this);
    }

    protected void setButtonIcons() {
	if(frame.isIcon()) {
	    iconButton.setIcon(minIcon);
	    maxButton.setIcon(maxIcon);
        } else if (frame.isMaximum()) {
	    iconButton.setIcon(iconIcon);
	    maxButton.setIcon(minIcon);
        } else {
	    iconButton.setIcon(iconIcon);
	    maxButton.setIcon(maxIcon);
        }
    }
        
    public void paint(Graphics g)  {
	boolean isSelected = frame.isSelected();
	Color color = g.getColor();

	if(isSelected)
	    g.setColor(selectedTitleColor);
	else
	    g.setColor(notSelectedTitleColor);
	g.fillRect(0, 0, getWidth(), getHeight());

	if(frame.getTitle() != null) {
	    Font f = g.getFont();
	    g.setFont(UIManager.getFont("InternalFrame.titleFont"));
	    if(isSelected)
		g.setColor(selectedTextColor);
	    else
		g.setColor(notSelectedTextColor);

            // Center text vertically.
	    FontMetrics fm = g.getFontMetrics();
            int fmHeight = fm.getHeight() - fm.getLeading();
            int baseline = (18 - fmHeight) / 2 + 
                fm.getAscent() + fm.getLeading();
            
	    g.drawString(frame.getTitle(), 
                         menuBar.getX() + menuBar.getWidth() + 2, 
                         baseline);
	    g.setFont(f);
	}
            
	g.setColor(color);
	super.paint(g);
    }

    /**
     * Post a WINDOW_CLOSING-like event to the frame, so that it can
     * be treated like a regular Frame.
     */
    void postClosingEvent(JInternalFrame frame) {
        InternalFrameEvent e = new InternalFrameEvent(
            frame, InternalFrameEvent.INTERNAL_FRAME_CLOSING);
        // Try posting event, unless there's a SecurityManager.
        if (JInternalFrame.class.getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
                return;
            } catch (SecurityException se) {
                // Use dispatchEvent instead.
            }
        }
        frame.dispatchEvent(e);
    }

    public void actionPerformed(ActionEvent e) {
	if("Close".equals(e.getActionCommand()) && frame.isClosable())
            postClosingEvent(frame);
	else if("Iconify".equals(e.getActionCommand()) && frame.isIconifiable()) {
	    if(!frame.isIcon())
		try { frame.setIcon(true); } catch (PropertyVetoException e1) { }
	    else {
		try { 
                    frame.setIcon(false); 
                    if (frame.isMaximizable() && frame.isMaximum()) {
                        frame.setMaximum(false);
                    }
                } catch (PropertyVetoException e1) { }
            }
	} else if("Minimize".equals(e.getActionCommand()) && frame.isIconifiable()) {
	    try { frame.setIcon(true); } catch (PropertyVetoException e2) { }
	} else if("Maximize".equals(e.getActionCommand()) && frame.isMaximizable()) {
	    if(!frame.isMaximum()) {
		try { frame.setMaximum(true); } catch (PropertyVetoException e5) { }
	    } else {
		try { 
                    frame.setMaximum(false); 
                    if (frame.isIconifiable() && frame.isIcon()) {
                        frame.setIcon(false); 
                    }
                } catch (PropertyVetoException e6) { }
	    }
	} else if("Restore".equals(e.getActionCommand()) && 
                  frame.isMaximizable() && frame.isMaximum()) {
	    try { frame.setMaximum(false); } catch (PropertyVetoException e4) { }
	} else if("Restore".equals(e.getActionCommand()) && 
                  frame.isIconifiable() && frame.isIcon()) {
	    try { frame.setIcon(false); } catch (PropertyVetoException e4) { }
	}
    }

    public void propertyChange(PropertyChangeEvent evt) {
	String prop = (String)evt.getPropertyName();
	JInternalFrame f = (JInternalFrame)evt.getSource();
	boolean value = false;
	// ASSERT(frame == f) - This should always be true
	if(JInternalFrame.IS_SELECTED_PROPERTY.equals(prop)) {
	    //	        value = ((Boolean)evt.getNewValue()).booleanValue();
	    //		if(!value)
	    repaint();
	} else if(JInternalFrame.IS_MAXIMUM_PROPERTY.equals(prop)) {
	    value = ((Boolean)evt.getNewValue()).booleanValue();
            setButtonIcons();
	    windowMenu.getItem(RESTORE_MENU_ITEM).setEnabled(value); 
	    windowMenu.getItem(MAXIMIZE_MENU_ITEM).setEnabled(!value); 
	} else if(JInternalFrame.IS_ICON_PROPERTY.equals(prop)) {
	    value = ((Boolean)evt.getNewValue()).booleanValue();
            setButtonIcons();
	    windowMenu.getItem(RESTORE_MENU_ITEM).setEnabled(value); 
	    windowMenu.getItem(MAXIMIZE_MENU_ITEM).setEnabled(!value); 
	    windowMenu.getItem(MINIMIZE_MENU_ITEM).setEnabled(!value); 
	} 
    }

    public void addLayoutComponent(String name, Component c) {}
    public void removeLayoutComponent(Component c) {}    
    public Dimension preferredLayoutSize(Container c)  {
	return new Dimension(c.getSize().width, 18);
    }
    
    public Dimension minimumLayoutSize(Container c) {
	return new Dimension(c.getSize().width, 18);
    }
    
    public void layoutContainer(Container c) {
	int w = getWidth();
	int x = w - 16 - 2;
	menuBar.setBounds(2, 1, 16, 16);

	if(frame.isClosable()) {
	    closeButton.setBounds(x, 2, 16, 14);
	    x -= 16;
	} else if(closeButton.getParent() != null) {
	    closeButton.getParent().remove(closeButton);
	}
            
	if(frame.isMaximizable()) {
	    maxButton.setBounds(x - 2, 2, 16, 14);
	    x -= 18;
	} else if(maxButton.getParent() != null) {
	    maxButton.getParent().remove(maxButton);
	}
        
	if(frame.isIconifiable()) {
	    iconButton.setBounds(x, 2, 16, 14);
	} else if(iconButton.getParent() != null) {
	    iconButton.getParent().remove(iconButton);
	}
    }
};    /// End Title Pane Class

