/*  
 * @(#)BasicDesktopIconUI.java	1.20 98/02/06
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.basic;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import java.beans.*;
import java.util.EventListener;
import java.io.Serializable;


/**
 * Basic L&F for a minimized window on a desktop.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.20 02/06/98
 * @author David Kloba
 * @author Steve Wilson
 */
public class BasicDesktopIconUI extends DesktopIconUI implements Serializable
{
    JInternalFrame.JDesktopIcon desktopIcon;
    JComponent   iconPane;
    EventListener mml;
    JInternalFrame frame;


    public static ComponentUI createUI(JComponent c)    {
        return new BasicDesktopIconUI();
    }

    public BasicDesktopIconUI() {
    }

    public void installUI(JComponent c)   {
	desktopIcon = (JInternalFrame.JDesktopIcon)c;
	frame = desktopIcon.getInternalFrame();
	installDefaults( desktopIcon );
	installComponents(desktopIcon);
	installListeners(desktopIcon);
	JLayeredPane.putLayer(desktopIcon, JLayeredPane.getLayer(frame));
    }

    public void uninstallUI(JComponent c) {
	installDefaults( desktopIcon );
	uninstallComponents(desktopIcon);
	uninstallListeners(desktopIcon);
	desktopIcon = null;
	frame = null;
    }

    protected void installComponents(JInternalFrame.JDesktopIcon dIcon) {
	frame = dIcon.getInternalFrame();
	iconPane = new BasicInternalFrameTitlePane(frame);
	dIcon.setLayout(new BorderLayout());
	dIcon.add(iconPane, BorderLayout.CENTER);
    }

    protected void uninstallComponents(JInternalFrame.JDesktopIcon dIcon) {
	dIcon.setLayout(null);
	dIcon.remove(iconPane);
    }

    protected void installListeners(JInternalFrame.JDesktopIcon dIcon) {
	mml = createMotionListener(desktopIcon);
	dIcon.addMouseMotionListener((MouseMotionListener)mml);
	dIcon.addMouseListener((MouseListener)mml);
    }

    protected void uninstallListeners(JInternalFrame.JDesktopIcon dIcon) {
	dIcon.removeMouseMotionListener((MouseMotionListener)mml);
	dIcon.removeMouseListener((MouseListener)mml);
    }

    protected void installDefaults(JInternalFrame.JDesktopIcon dIcon) {
        LookAndFeel.installBorder(dIcon, "DesktopIcon.border");
    }

    protected void uninstallDefaults(JInternalFrame.JDesktopIcon dIcon) {
    }

    protected MotionListener createMotionListener(JInternalFrame.JDesktopIcon dIcon) {
        return new MotionListener();
    }
    
    public Dimension getPreferredSize(JComponent c) {
        JInternalFrame iframe = desktopIcon.getInternalFrame();
	Border border = iframe.getBorder();
        int w2 = 157;
	int h2 = 18;

	if(border != null)
	    h2 += border.getBorderInsets(iframe).bottom + 
                  border.getBorderInsets(iframe).top;

	return new Dimension(w2, h2);
    }

    public Dimension getMinimumSize(JComponent c) {
	return iconPane.getMinimumSize();
    } 

    public Dimension getMaximumSize(JComponent c){
	return iconPane.getMaximumSize();
    }

    public Insets getInsets(JComponent c) {
        JInternalFrame iframe = desktopIcon.getInternalFrame();
	Border border = iframe.getBorder();
	if(border != null)
	    return border.getBorderInsets(iframe);
	
	return new Insets(0,0,0,0);
    }

    public void deiconize() {
        try { frame.setIcon(false); } catch (PropertyVetoException e2) { }
    }

    /**
     * Listens for mouse movements and acts on them.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    public class MotionListener
        extends MouseAdapter implements MouseMotionListener, Serializable
    {
	// _x & _y are the mousePressed location in absolute coordinate system
        int _x, _y;
	// __x & __y are the mousePressed location in source view's coordinate system
	int __x, __y;
        Rectangle startingBounds;

        public void mouseReleased(MouseEvent e) {
            _x = 0;
            _y = 0;
            __x = 0;
            __y = 0;
            startingBounds = null;
        }
                
        public void mousePressed(MouseEvent e) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), 
                        e.getX(), e.getY(), null);
            __x = e.getX();
            __y = e.getY();
            _x = p.x;
            _y = p.y;
            startingBounds = desktopIcon.getBounds();

            try { frame.setSelected(true); } catch (PropertyVetoException e1) { }
	    if(desktopIcon.getParent() instanceof JLayeredPane) {
		((JLayeredPane)desktopIcon.getParent()).moveToFront(desktopIcon);
 	    }

            if(e.getClickCount() > 1) {
		if(frame.isIconifiable() && frame.isIcon()) {
                    deiconize();
		}
            }

 	}

         public void mouseMoved(MouseEvent e) {}

         public void mouseDragged(MouseEvent e) {   
            Point p; 
	    int newX, newY, newW, newH;
            int deltaX;
            int deltaY;
	    Dimension min;
	    Dimension max;
            p = SwingUtilities.convertPoint((Component)e.getSource(), 
                                        e.getX(), e.getY(), null);
        
		Insets i = desktopIcon.getInsets();
		int pWidth, pHeight;
		pWidth = ((JComponent)desktopIcon.getParent()).getWidth();
		pHeight = ((JComponent)desktopIcon.getParent()).getHeight();
		
		if (startingBounds == null) {
		  // (STEVE) Yucky work around for bug ID 4106552
		    return;
		}
		newX = startingBounds.x - (_x - p.x);
		newY = startingBounds.y - (_y - p.y);
		// Make sure we stay in-bounds
		if(newX + i.left <= -__x)
		    newX = -__x - i.left;
		if(newY + i.top <= -__y)
		    newY = -__y - i.top;
		if(newX + __x + i.right > pWidth)
		    newX = pWidth - __x - i.right;
		if(newY + __y + i.bottom > pHeight)
		    newY =  pHeight - __y - i.bottom;
		
		JDesktopPane d;
		if((d = desktopIcon.getDesktopPane()) != null) {
		    DesktopManager dm;
		    dm = d.getDesktopManager();
		    dm.setBoundsForFrame(desktopIcon, newX, newY, 
					     desktopIcon.getWidth(), 
					     desktopIcon.getHeight());
		} else {
		    moveAndRepaint(desktopIcon, newX, newY, 
				desktopIcon.getWidth(), desktopIcon.getHeight());
		}
		return;
	}

        public void moveAndRepaint(JComponent f, int newX, int newY, 
					int newWidth, int newHeight) {
	    Rectangle r = f.getBounds();
	    f.setBounds(newX, newY, newWidth, newHeight);		
	    SwingUtilities.computeUnion(newX, newY, newWidth, newHeight, r);
	    f.getParent().repaint(r.x, r.y, r.width, r.height);
        }	
    }; /// End MotionListener

}


