/*
 * @(#)BasicButtonUI.java	1.80 98/06/22
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
 
package com.sun.java.swing.plaf.basic;

import java.awt.*;
import java.awt.event.*;
import java.io.Serializable;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.ButtonUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.ComponentUI;

/**
 * BasicButton implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.80 06/22/98
 * @author Jeff Dinkins
 */
public class BasicButtonUI extends ButtonUI implements Serializable {

    protected Color getSelectColor()       { return UIManager.getColor("Button.pressed"); }
    protected Color getDisabledColor()     { return UIManager.getColor("Button.disabled"); }
    protected Color getDisabledTextColor() { return UIManager.getColor("Button.disabledText"); }
    protected Color getFocusColor()        { return UIManager.getColor("Button.focus"); }

    // Borders
      private final static Insets defaultMargin = new Insets(2,14,2,14);

    // Visual constants
    private static final int defaultTextIconGap = 4;
  
  // offset controlled by set method 
    private int shift_offset = 0;

    // Shared UI object
    protected static ButtonUI buttonUI;

    public static ComponentUI createUI(JComponent c) {
	if(buttonUI == null) {
            buttonUI = new BasicButtonUI();
	}
        return buttonUI;
    }

    protected BasicButtonListener listener;

    public void installUI(JComponent c) {
      installDefaults((AbstractButton) c);
      installListeners((AbstractButton) c);
      installKeyboardActions((AbstractButton) c);
    }

    protected void installDefaults(AbstractButton b) {
      b.setOpaque(false); // exterior "is Default" border turns on and off 
      LookAndFeel.installColorsAndFont(b, "Button.background", 
					  "Button.foreground", 
					  "Button.font");
      LookAndFeel.installBorder(b,"Button.border");
    }

    protected void installListeners(AbstractButton b) {
	if (listener == null) {
	    listener = createListener(b);
	}
	b.addMouseListener(listener);
	b.addMouseMotionListener(listener);
	b.addFocusListener(listener);
        b.addPropertyChangeListener(listener);
	b.addChangeListener(listener);
    }
    
    protected void installKeyboardActions(AbstractButton b){
	listener.installKeyboardActions(b);
    }

	
    public void uninstallUI(JComponent c) {
        uninstallKeyboardActions((AbstractButton) c);
        uninstallListeners((AbstractButton) c);
        uninstallDefaults((AbstractButton) c);
    }

    protected void uninstallKeyboardActions(AbstractButton b) {
	listener.uninstallKeyboardActions(b);
    }

    protected void uninstallListeners(AbstractButton b) {
        b.removeMouseListener(listener);
        b.removeMouseListener(listener);
        b.removeMouseMotionListener(listener);
        b.removeFocusListener(listener);
        b.removeChangeListener(listener);
        b.removePropertyChangeListener(listener);
    }

    protected void uninstallDefaults(AbstractButton b) {
        LookAndFeel.uninstallBorder(b);
    }
  
    protected BasicButtonListener createListener(AbstractButton b) {
	return new BasicButtonListener(b);
    }


    /**
     * ComponentUI implementation for BasicButton
     *
     */
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton) c;
        ButtonModel model = b.getModel();

        Dimension size = b.getSize();
        FontMetrics fm = g.getFontMetrics();

	Insets i = c.getInsets();

        Rectangle viewRect = new Rectangle(size);

	viewRect.x += i.left;
	viewRect.y += i.top;
	viewRect.width -= (i.right + viewRect.x);
	viewRect.height -= (i.bottom + viewRect.y);

        Rectangle iconRect = new Rectangle(); 
	Rectangle textRect = new Rectangle();

	Font f = c.getFont();
	g.setFont(f);

	// layout the text and icon
        String text = SwingUtilities.layoutCompoundLabel(
	    fm, b.getText(), b.getIcon(),
	    b.getVerticalAlignment(), b.getHorizontalAlignment(),
	    b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
	    viewRect, iconRect, textRect, b.getText() == null ? 0 : defaultTextIconGap
	);

	setTextShiftOffset(0);

	// perform UI specific press action, ie
	// ie. Basic L&F shifts text
        if (model.isArmed() && model.isPressed()) {
	  paintButtonPressed(g,b); 
        }

	// Paint the Icon
        if(b.getIcon() != null) { 
	    paintIcon(g,c,iconRect);
        }

	if (text != null && !text.equals("")){
	    paintText(g, c,textRect, text);
	}

	if (b.isFocusPainted() && b.hasFocus()) {
	  // paint UI specific focus
	  paintFocus(g,b,viewRect,textRect,iconRect);
	}
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect){
            AbstractButton b = (AbstractButton) c;			     
            ButtonModel model = b.getModel();
            Icon icon = null;
            if(!model.isEnabled()) {
                icon = (Icon) b.getDisabledIcon();
            } else if(model.isPressed() && model.isArmed()) {
                icon = (Icon) b.getPressedIcon();
                if(icon == null) {
                    // Use default icon
                    icon = (Icon) b.getIcon();
                } else {
		    // revert back to 0 offset
		  setTextShiftOffset(0);
	        }
            } else if(b.isRolloverEnabled() && model.isRollover()) {
                icon = (Icon) b.getRolloverIcon();
            }
	      
	    if (icon == null) {
                icon = (Icon) b.getIcon();
	    }
	       
            if(model.isPressed() && model.isArmed()) {
                icon.paintIcon(c, g, iconRect.x + getTextShiftOffset(),
			iconRect.y + getTextShiftOffset());
            } else {
                icon.paintIcon(c, g, iconRect.x, iconRect.y);
            }

    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
	AbstractButton b = (AbstractButton) c;			     
	ButtonModel model = b.getModel();
	FontMetrics fm = g.getFontMetrics();

	/* Draw the Text */
	if(model.isEnabled()) {
	    /*** paint the text normally */
	    g.setColor(b.getForeground());
	    BasicGraphicsUtils.drawString(g,text, model.getMnemonic(),
					  textRect.x + getTextShiftOffset(),
					  textRect.y + fm.getAscent() + getTextShiftOffset());
	}
	else {
	    /*** paint the text disabled ***/
	    g.setColor(b.getBackground().brighter());
	    BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
					  textRect.x, textRect.y + fm.getAscent());
	    g.setColor(b.getBackground().darker());
	    BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
					  textRect.x - 1, textRect.y + fm.getAscent() - 1);
	}
    }
	

    protected void paintFocus(Graphics g, AbstractButton b,
			      Rectangle viewRect, Rectangle textRect, Rectangle iconRect){
    }
  
    protected void paintButtonPressed(Graphics g, AbstractButton b){
    }

    protected void setTextShiftOffset(int i){
	this.shift_offset = i;
    }

    private int getTextShiftOffset(){
	return this.shift_offset;
    }

    public Dimension getMinimumSize(JComponent c) {
        return getPreferredSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
	AbstractButton b = (AbstractButton)c;
	return BasicGraphicsUtils.getPreferredButtonSize(b, defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent c) {
        return getPreferredSize(c);
    }

    /**
     * insets and margin
     */

    public Insets getDefaultMargin(AbstractButton b) {
	return defaultMargin;
    }

    public int getDefaultTextIconGap(AbstractButton b) {
	return defaultTextIconGap;
    }

}

