/*
 * @(#)BasicBorderFactory.java	1.5 98/01/30
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Dimension;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;


/**
 * Factory object that can vend Borders appropriate for the basic L & F.
 * @version 1.5 01/30/98
 * @author Georges Saab
 */

public class BasicBorderFactory
{

  private static Border toggleButtonBorder;
  private static Border radioButtonBorder;
  private static Border buttonBorder;
  private static Border menuBarBorder;

  public static Border getMenuBarBorder() {
    if (menuBarBorder == null){
      menuBarBorder = new BasicMenuBarBorder();
    }
    return menuBarBorder;
  }

  public static Border getButtonBorder() {
    if (buttonBorder == null){
      buttonBorder = new BasicButtonBorder();
    }
    return buttonBorder;
  }

  public static Border getToggleButtonBorder() {
    if (toggleButtonBorder == null) {
      toggleButtonBorder = new BasicToggleBorder();
    }
    return toggleButtonBorder;
  }

  public static Border getRadioButtonBorder() {
    if (radioButtonBorder == null) {
      radioButtonBorder = new BasicRadioBorder();
    }
    return radioButtonBorder;
  }


  private static class BasicToggleBorder extends AbstractBorder {

        public void paintBorder(Component c, Graphics g, int x, int y, 
                                int width, int height) {
                BasicGraphicsUtils.drawBezel(g, x, y, width, height, false, false);
	}

        public Insets getBorderInsets(Component c)       {
            return new Insets(2, 2, 2, 2);
        }
    }

    private static class BasicRadioBorder extends AbstractBorder {

        public void paintBorder(Component c, Graphics g, int x, int y, 
                                int width, int height) {

            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                ButtonModel model = b.getModel();

                if (model.isArmed() && model.isPressed() || model.isSelected()) {
                    BasicGraphicsUtils.drawLoweredBezel(g, x, y, width, height);
                } else {
                    BasicGraphicsUtils.drawBezel(g, x, y, width, height, 
                                         false, b.isFocusPainted() && b.hasFocus());
                }
            } else {	
                BasicGraphicsUtils.drawBezel(g, x, y, width, height, false, false);
            }
        }

        public Insets getBorderInsets(Component c)       {
            return new Insets(2, 2, 2, 2);
        }
    }

  private static class BasicButtonBorder extends AbstractBorder {
    public void paintBorder(Component c, Graphics g, int x, int y, 
                            int width, int height) {
      boolean isPressed = false;
      boolean isDefault = false;
      
      if (c instanceof AbstractButton) {
	AbstractButton b = (AbstractButton)c;
	ButtonModel model = b.getModel();
	
	isPressed = model.isPressed() && model.isArmed();

        if (c instanceof JButton) {
            isDefault = ((JButton)c).isDefaultButton();
        }
      }	
      BasicGraphicsUtils.drawBezel(g, x, y, width, height, 
				   isPressed, isDefault);
    }
    public Insets getBorderInsets(Component c)       {
        if (c instanceof JButton && ((JButton)c).isDefaultButton()) {
            // leave room for default visual
            return new Insets(2,2,3,3);
        }
        return new Insets(1,1,2,2);
    }
  }

    private static class BasicMenuBarBorder extends AbstractBorder
    {
	public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
	    BasicGraphicsUtils.drawGroove(g, 0, height-2, 
					  width, height);
	}
	
	public Insets getBorderInsets(Component c)       {
	    return new Insets(0, 0, 2, 0);
	}
    }
    
}
