/*
 * @(#)TreeUI.java	1.15 97/09/30
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf;

import java.awt.Rectangle;
import com.sun.java.swing.tree.TreePath;

/**
 * Pluggable look and feel interface for JTree.
 *
 * @version 1.15 09/30/97
 * @author Rob Davis
 * @author Scott Violet
 */
public abstract class TreeUI extends ComponentUI
{
    /**
      * Returns the number of rows that are being displayed.
      */
    public abstract int getRowCount();

    /**
      * Returns true if the value identified by path is currently expanded,
      * this will return false if any of the values in path are currently
      * not being displayed.
      */
    public abstract boolean isExpanded(TreePath path);

    /**
      * Returns true if the value identified by row is currently expanded.
      */
    public abstract boolean isExpanded(int row);

    /**
      * Returns true if the value identified by path is currently collapsed,
      * this will return false if any of the values in path are currently
      * not being displayed.
      */
    public abstract boolean isCollapsed(TreePath path);

    /**
      * Returns true if the value identified by row is currently collapsed.
      */
    public abstract boolean isCollapsed(int row);

    /**
      * Ensures that all of the parents of path are currently expanded.
      * To make sure it is truyly visible, you may wish to call
      * scrollPathToVisible, which will try and scroll the path to be
      * visibile if the JTree is in a scroller.
      */
    public abstract void makeVisible(TreePath path);

    /**
      * Returns true if all the parents of path are currently expanded.
      */
    public abstract boolean isVisible(TreePath path);

    /**
      * Returns the Rectangle enclosing the label portion that the
      * last item in path will be drawn into.  Will return null if
      * any component in path is currently valid.
      */
    public abstract Rectangle getPathBounds(TreePath path);

    /**
      * Returns the Rectangle enclosing the label portion that the
      * item identified by row will be drawn into.
      */
    public abstract Rectangle getRowBounds(int row);

    /**
      * Makes sure all the path components in path are expanded (accept
      * for the last path component) and tries to scroll the resulting path
      * to be visible (the scrolling will only work if the JTree is
      * contained in a JScrollPane).
      */
    public abstract void scrollPathToVisible(TreePath path);

    /**
      * Scrolls the item identified by row to be visible.  This will
      * only work if the JTree is contained in a JSrollPane.
      */
    public abstract void scrollRowToVisible(int row);

    /**
      * Returns the path for passed in row.  If row is not visible
      * null is returned.
      */
    public abstract TreePath getPathForRow(int row);

    /**
      * Returns the row that the last item identified in path is visible
      * at.  Will return -1 if any of the elements in path are not
      * currently visible.
      */
    public abstract int getRowForPath(TreePath path);

    /**
      * Insures that the last item identified in path is expanded and
      * visible.  This differs from makeVisible in that the last item
      * is expanded in this method.
      */
    public abstract void expandPath(TreePath path);

    /**
      * Insures that the item identified by row is expanded.
      */
    public abstract void expandRow(int row);

    /**
      * Insures that the last item identified in path is collapsed and
      * visible.
      */
    public abstract void collapsePath(TreePath path);

    /**
      * Insures that the item identified by row is collapsed.
      */
    public abstract void collapseRow(int row);

    /**
      * Returns the path to the node that is closest to x,y.  If
      * there is nothing currently visible this will return null, otherwise
      * it'll always return a valid path.  If you need to test if the
      * returned object is exactly at x, y you should get the bounds for
      * the returned path and test x, y against that.
      */
    public abstract TreePath getClosestPathForLocation(int x, int y);

    /**
      * Returns the row to the node that is closest to x,y.  If
      * there is nothing currently visible this will return -1, otherwise
      * it'll always return a valid row.  If you need to test if the
      * returned object is exactly at x, y you should get the bounds for
      * the returned row and test x, y against that.
      */
    public abstract int getClosestRowForLocation(int x, int y);

    /**
      * Returns true if the tree is being edited.  The item that is being
      * edited can be returned by getEditingPath().
      */
    public abstract boolean isEditing();

    /**
      * Stops the current editing session.  This has no effect if the
      * tree isn't being edited.  Returns true if the editor allows the
      * editing session to stop.
      */
    public abstract boolean stopEditing();

    /**
      * Selects the last item in path and tries to edit it.  Editing will
      * fail if the CellEditor won't allow it for the selected item.
      */
    public abstract void startEditingAtPath(TreePath path);

    /**
     * Returns the path to the element that is being edited.
     */
    public abstract TreePath getEditingPath();
}
