/*
 * @(#)SplitPaneUI.java	1.6 97/09/29
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf;

import com.sun.java.swing.JSplitPane;
import java.awt.Graphics;

/**
 * Pluggable look and feel interface for JSplitPane.
 * 
 * @version 1.6 09/29/97
 * @author Scott Violet
 */
public abstract class SplitPaneUI extends ComponentUI
{
    /**
      * Messaged to relayout the JSplitPane based on the preferred size
      * of the children components.
      */
    public abstract void resetToPreferredSizes();

    /**
      * Sets the location of the divider to location.
      */
    public abstract void setDividerLocation(int location);

    /**
      * Returns the location of the divider.
      */
    public abstract int getDividerLocation();

    /**
      * Returns the minimum possible location of the divider.
      */
    public abstract int getMinimumDividerLocation();

    /**
      * Returns the maximum possible location of the divider.
      */
    public abstract int getMaximumDividerLocation();

    /**
     * Messaged after the JSplitPane the receiver is providing the look
     * and feel for paints its children.
     */
    public abstract void finishedPaintingChildren(JSplitPane jc, Graphics g);
}
