/*
 * @(#)ScrollPaneUI.java	1.8 97/10/06
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf;

import java.awt.Component;
import com.sun.java.swing.*;

/**
 * Pluggable look and feel interface for JScrollPane.
 *
 * @version 1.8 10/06/97
 * @author Hans Muller
 */

public abstract class ScrollPaneUI extends ComponentUI
{
    // PENDING(hmuller) Warning: this interface will change

    public abstract int getVerticalScrollBarPolicy();
    public abstract void setVerticalScrollBarPolicy(int x);

    public abstract int getHorizontalScrollBarPolicy();
    public abstract void setHorizontalScrollBarPolicy(int x);

    public abstract JScrollBar getHorizontalScrollBar();
    public abstract JScrollBar getVerticalScrollBar();

    public abstract JViewport getViewport();
    public abstract void setViewport(JViewport x);

    public abstract JViewport getRowHeader();
    public abstract void setRowHeader(JViewport x);

    public abstract JViewport getColumnHeader();
    public abstract void setColumnHeader(JViewport x);
    
    public abstract Component getCorner(String key);
    public abstract void setCorner(String key, Component x);
}
