/*
 * @(#)ListUI.java	1.3 97/09/29
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf;

import com.sun.java.swing.JList;
import java.awt.Point;
import java.awt.Rectangle;


/**
 * The JList pluggable look and feel delegate.  This interface adds
 * methods that allow the JList component to map locations, e.g. mouse
 * coordinates, to list cells and from cell indices to the bounds of 
 * the cell.
 *
 * @version 1.3 09/29/97
 * @author Hans Muller
 */

public abstract class ListUI extends ComponentUI
{
    /** 
     * Convert a point in JList coordinates to the index
     * of the cell at that location.  Returns -1 if there's no
     * cell the specified location.  
     * 
     * @param location The JList relative coordinates of the cell
     * @return The index of the cell at location, or -1.
     */
    public abstract int locationToIndex(JList list, Point location);


    /** 
     * Returns the origin of the specified item in JList
     * coordinates, null if index isn't valid.
     * 
     * @param index The index of the JList cell.
     * @return The origin of the index'th cell.
     */
    public abstract Point indexToLocation(JList list, int index);


    /** 
     * Returns the bounds of the specified item in JList
     * coordinates, null if index isn't valid.
     * 
     * @param index The index of the JList cell.
     * @return The bounds of the index'th cell.
     */
    public abstract Rectangle getCellBounds(JList list, int index1, int index2);
}
