/*
 * @(#)ComboBoxUI.java	1.9 98/04/10
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf;

import com.sun.java.swing.JList;

/**
 * Pluggable look and feel interface for JComboBox.
 *
 * @version 1.9 04/10/98
 * @author Arnaud Weber
 * @author Tom Santos
 */
public abstract class ComboBoxUI extends ComponentUI {
    /** This method request the UI to show the popup **/
    public abstract void showPopup();

    /** This method request the UI to hide the popup **/
    public abstract void hidePopup();

    /** This method determines if the popup is visible **/
    public abstract boolean popupIsVisible();

    /** This method determines whether or not the combo box itself is traversable **/
    public abstract boolean isFocusTraversable();

    /** 
     * This method asks the UI for the JList is using to display the
     * contents of the ComboBox.  The return value is meant to be used
     * for read-only values -- any modification to the JList is 
     * unsupported.
     */
    public abstract JList getList();
}
