/*
 * @(#)BorderUIResource.java	1.6 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Graphics;
import java.io.Serializable;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.UIResource;


/*
 * A Border wrapper class which implements UIResource.  UI
 * classes which set border properties should use this class
 * to wrap any borders specified as defaults.
 *
 * This class delegates all method invocations to the
 * Border "delegate" object specified at construction.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @see com.sun.java.swing.plaf.UIResource
 * @version 1.6 02/02/98
 * @author Amy Fowler
 * 
 */
public class BorderUIResource implements Border, UIResource, Serializable
{
    static BorderUIResource etched;
    static BorderUIResource loweredBevel;
    static BorderUIResource raisedBevel;
    static BorderUIResource blackLine;

    public static BorderUIResource getEtchedBorderUIResource() {
        if (etched == null) {
            etched = new BorderUIResource(BorderFactory.createEtchedBorder());
        }
        return etched;
    }

    public static BorderUIResource getLoweredBevelBorderUIResource() {
        if (loweredBevel == null) {
            loweredBevel = new BorderUIResource(
                                   BorderFactory.createLoweredBevelBorder());
        }
        return loweredBevel;
    }

    public static BorderUIResource getRaisedBevelBorderUIResource() {
        if (raisedBevel == null) {
            raisedBevel = new BorderUIResource(
                                   BorderFactory.createRaisedBevelBorder());
        }
        return raisedBevel;
    }

    public static BorderUIResource getBlackLineBorderUIResource() {
        if (blackLine == null) {
            blackLine = new BorderUIResource(
                                   LineBorder.createBlackLineBorder());
        }
        return blackLine;
    }

    private Border delegate;

    /**
     * Creates a UIResource border object which wraps
     * an existing Border instance.
     * @param delegate the border being wrapped
     */
    public BorderUIResource(Border delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("null border delegate argument");
        }
        this.delegate = delegate;
    }

    public void paintBorder(Component c, Graphics g, int x, int y,
                            int width, int height) {        
        delegate.paintBorder(c, g, x, y, width, height);
    }

    public Insets getBorderInsets(Component c)       {
        return delegate.getBorderInsets(c);
    }

    public boolean isBorderOpaque() { 
        return delegate.isBorderOpaque();
    }
 
}
