/*
 * @(#)TextPreview.java	1.5 01/28/98
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not disclose
 * such Confidential Information and shall use it only in accordance with the
 * terms of the license agreement you entered into with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
 * ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import com.sun.java.swing.event.*;

/** A component to preview a text file, intended to fit into the
 *  preview slot of a FileChooser.  In normal usage, only the
 *  ask method is of interest: it pops up a dialog box with
 *  a FileChooser containing an instance of this previewer and
 *  filtering for appropriate files.
 *  @author James Gosling
 */
public class TextPreview extends Component implements FilePreview {
    private String txt[] = new String[10];
    private boolean blank;


    private static FileChooserFilter dfcf;

    /** Convenience method to prompt for the name of a text file.
	For example:
	<pre>File f = ImagePreview.ask(null,"Open file",previousFile,
	&nbsp;               null,new FileChooserFilter("Config file (cfg)"));
	</pre>
	@param fparent the parent frame for the dialog box.
		fparent may be null if a default parent has
		been established with StandardDialog
	@param description a description string that will be shown
		to the user to indicate what is being requested
	@param initial the initial value for the string
	@param columns the default width (in 'm's) of the TextField
	@param target the ChangeListener that will be informed if the
			OK or Apply buttons are hit.
	@param fcf	a FileChooserFilter for selecting the
			file names to be presented in the dialog box.
	@return If target is null,
		the dialog box will be modal and the method
		will return the final result, or null if canceled.
		Otherwise, the
		dialog box is non-modal, the method returns null
		immediatly, and the listener is informed when
		appropriate.  The source of the change event will
		be a FileChooser.
	@see StandardDialog
     */
    public static File ask(Component parent, String title, File dfc,
			        ChangeListener target,
			        FileChooserFilter fcf) {
	StandardDialog d;
	FileChooser c;
	if (dfcf == null && fcf == null) {
	    dfcf = new FileChooserFilter();
	    dfcf.add("Text file (txt,exc,dic)");
	    dfcf.add("Hypertext file (html,htm)");
	    dfcf.add("Java source (java)");
	    dfcf.add("System file (ini,cfg,dat)");
	    dfcf.add("C program (c,cpp)");
	}
	c = new FileChooser();
	c.setPreview(new TextPreview ());
	d = new StandardDialog(parent,
			       c, target == null);
	c.setFilter(fcf != null ? fcf : dfcf);
	if (dfc != null)
	    c.getModel().setFile(dfc);
	if (title != null)
	    d.setTitle(title);
	if (target != null)
	    d.addChangeListener(target);
	d.start();
	return d.isCanceled() || target != null ? null
	    : c.getModel().getFile();
    }

    public TextPreview () {
    }
    public void setPreviewFile(File f) {
	if (f == null) {
	    if (!blank) {
		blank = true;
		repaint();
	    }
	    return;
	}
	blank = false;
	for (int i = txt.length; --i >= 0;)
	    txt[i] = null;
	try {
	    Reader in = new BufferedReader(new FileReader(f));
	    char [] ln = new char[40];
	    int c;
	    int nc = 2000;
	    int l = 0;
	    int p = 0;
	    while ((c = in.read()) >= 0 && --nc >= 0) {
		if (c == '\t')
		    c = ' ';
		if ((c == '\n' || c == '\r') && p > 0) {
		    if (p > ln.length)
			p = ln.length;
		    String s = new String(ln, 0, p);
		    if (!s.startsWith("//") && !s.startsWith("import")) {
			txt[l++] = s;
			if (l >= txt.length)
			    break;
		    }
		    p = 0;
		    continue;
		}
		if (c >= 0177 || c == 0) {
		    blank = true;
		    break;
		}
		if (c > 040 || c == 040 && p > 0)
		    if (p < ln.length)
			ln[p++] = (char) c;
	    }
	    in.close();
	} catch(Throwable e) {
	    txt[0] = "Error: " + e;
	}
	repaint();
    }
    private Dimension isize = new Dimension(120, 120);
    public void setSize(int w, int h) {
	if (w != isize.width || h != isize.height) {
	    isize.width = w;
	    isize.height = h;
	    invalidate();
	}
    }
    public void setBounds(int x, int y, int width, int height) {
	super.setBounds(x, y, width, height);
	setSize(width, height);
    }
    public Dimension getPreferredSize() {
	return isize;
    }
    public Dimension getMinimumSize() {
	return getPreferredSize();
    }
    public void paint(Graphics g) {
	if (!blank) {
	    FontMetrics fm = g.getFontMetrics();
	    int y0 = fm.getAscent();
	    int dy = fm.getHeight();
	    for (int i = 0; i < txt.length; i++)
		if (txt[i] != null)
		    g.drawString(txt[i], 0, i * dy + y0);
	}
    }
}
