/*
 * @(#)StringChooser.java	1.9 01/28/98
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * @author James Gosling
 */
 
package com.sun.java.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import com.sun.java.swing.event.*;

public class StringChooser {
    /** Convenience method to prompt for a String.
	@param parent the parent component for the dialog box.
		parent may be null if a default parent has
		been established with StandardDialog
	@param description a description string that will be shown
		to the user to indicate what is being requested
	@param initial the initial value for the string
	@param columns the default width (in 'm's) of the TextField
	@param target the ChangeListener that will be informed if the
			OK or Apply buttons are hit.
	@return If target is null,
		the dialog box will be modal and the method
		will return the final result, or null if canceled.
		Otherwise, the
		dialog box is non-modal, the method returns null
		immediatly, and the listener is informed when
		appropriate.  The source of the change event will
		be a JTextField.
	@see StandardDialog
     */
    public static String ask(Component parent, String description,
				          String initial, int columns,
					  ChangeListener target) {
	if (columns <= 0)
	    columns = 10;
	JTextField t = new JTextField(initial, columns);
	StandardDialog d = new StandardDialog (parent, t, target==null);
	d.setDescription(description);
	d.setStyle(StandardDialog.QuestionStyle);
	if (target != null)
	    d.addChangeListener(target);
	t.selectAll();
	d.start();
	if (target != null) return null;
	String r = t.getText();
	d.dispose();
	return d.isCanceled() ? null : r;
    }
    /** Convenience method to prompt for a String from a set of Strings.
	@param parent the parent component for the dialog box.
		parent may be null if a default parent has
		been established with StandardDialog
	@param description a description string that will be shown
		to the user to indicate what is being requested
	@param set the set of strings
	@param initial the default choice from the set
	@param target the ChangeListener that will be informed if the
			OK or Apply buttons are hit.
	@return If target is null,
		the dialog box will be modal and the method
		will return the index of string from the set, or -1 if canceled.
		Otherwise, the
		dialog box is non-modal, the method returns 0
		immediatly, and the listener is informed when
		appropriate.  The source of the change event will
		be a JComboBox.
	@see StandardDialog
     */
    public static int ask(Component parent, String description,
				          final String set[], final int initial,
					  ChangeListener target) {
	if (set==null || set.length==0) return -1;
	JComboBox t = new JComboBox(new ComboBoxModel() {
		int inx = initial;
		public Object getCurrentValue() { return set[inx]; }
		public void setCurrentValue(Object o) {
		    for (int i = set.length; --i>=0; )
			if (o.equals(set[i])) {
			    inx = i;
			    return;
			}
		}
		public int getSize() { return set.length;}
		public Object getElementAt(int i) { return set[i]; }
		public void addListDataListener(ListDataListener l) {}
		public void removeListDataListener(ListDataListener l) {}
	});
	t.setCurrentValueIndex(initial);
	StandardDialog d = new StandardDialog (parent, t, target==null);
	d.setDescription(description);
	d.setStyle(StandardDialog.QuestionStyle);
	if (target != null)
	    d.addChangeListener(target);
	d.start();
	if (target != null) return 0;
	int r = t.getCurrentValueIndex();
	d.dispose();
	return d.isCanceled() ? -1 : r;
    }
}
