/*
 * @(#)PopupButton.java	1.2 97/08/26
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;


/** A button with an attached menu that sends a message to an Adjustable
 * when a value is picked.  Generally connected to a Spinner.
 * @author James Gosling
 * @author Brian Gerhold
 */
public class PopupButton extends Component {
  private Dimension d;
  private JPopupMenu popup;
  public PopupButton(JPopupMenu popup) 
  {
    this.popup = popup;
    enableEvents(AWTEvent.MOUSE_MOTION_EVENT_MASK
		 |AWTEvent.MOUSE_EVENT_MASK);
  }
  public Dimension getMinimumSize() {
    if (d == null)
      {
	d = new Dimension(14,8);
      }
    return d;
  }
  
  protected void processMouseEvent(MouseEvent e){
    if (e.getID()==e.MOUSE_PRESSED) 
      {
	popup.show(this,e.getX(),e.getY());
      }
    
  }
  protected void processMouseMotionEvent(MouseEvent e)
  {}
 
  public Dimension getPreferredSize() 
  {
    return getMinimumSize();
  }
  private int xp[]=new int[4];
  private int yp[]=new int[4];
  public void paint(Graphics g) {
    g.setColor(Color.black);
    Dimension d = getSize();
    int h = d.height;
    int w = d.width-6;
    xp[0] = 0; yp[0] = 0;
    xp[1] = w-1; yp[1] = 0;
    xp[2] = w>>1; yp[2] = h-1;
    g.fillPolygon(xp,yp,3);
  }
  public void update(Graphics g) {
    paint(g);
  }
  
}
