/*
 * @(#)PaintRef.java	1.6  98/01/30
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not disclose
 * such Confidential Information and shall use it only in accordance with the
 * terms of the license agreement you entered into with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
 * ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing;

import java.io.File;
import java.awt.*;
import java.awt.image.*;

/**
 * PaintRef that can be used for filling a region.  Can be either a
 * color or an image.
 * @author James Gosling
 */
public class PaintRef implements ImageObserver {
    private Color clr;
    private Image img;
    private int imWidth, imHeight;

    public PaintRef () {
    }
    public PaintRef (Color c) {
	setColor(c);
    }
    public PaintRef (Image i) {
	setTile(i);
    }
    public String toString() {
	String s = clr != null ? clr.toString() : null;
	if (img != null)
	    if (s != null)
		s = s + "," + img;
	    else
		s = img.toString();
	return "PaintRef[" + s + "]";
    }
    public void setTile(Image tile) {
	if (tile == null)
	    return;
	img = tile;
	imWidth = img.getWidth(this);
	imHeight = img.getHeight(this);
    }
    public Image getTile() { return img; }
    public void setColor(Color c) {
	if (c == null)
	    return;
	clr = c;
    }
    public boolean imageUpdate(Image img,
			       int infoflags,
			       int x, int y,
			       int width, int height) {
	if ((infoflags & (ERROR | ABORT)) != 0) {
	    img = null;
	    return false;
	}
	if ((infoflags & WIDTH) != 0)
	    imWidth = img.getWidth(this);
	if ((infoflags & HEIGHT) != 0)
	    imHeight = img.getHeight(this);
	return (infoflags & ALLBITS) == 0;
    }
    public Color getColor() {
	return clr;
    }
    public void fillRect(Graphics g, int X, int Y, int W, int H, ImageObserver o) {
	if (img != null
		&& imWidth > 0
		&& imHeight > 0) {
	    int x0 = X / imWidth * imWidth;
	    int xlim = X + W;
	    int ylim = Y + H;
	    for (int y = Y / imHeight * imHeight; y < ylim; y += imHeight)
		for (int x = x0; x < xlim; x += imWidth)
		    g.drawImage(img,
				x, y,
				imWidth, imHeight,
				o);
	} else {
	    Color c = g.getColor();
	    g.setColor(clr == null ? SystemColor.window : clr);
	    g.fillRect(X, Y, W, H);
	    g.setColor(c);
	}
    }
    public void fillRect(Graphics g, Rectangle r, ImageObserver o) {
	fillRect(g, r.x, r.y, r.width, r.height, o);
    }
    public void fill(Graphics g, ImageObserver o) {
	fillRect(g, g.getClipBounds(), o);
    }
    /** Finds a named color from the defined SystemColors */
    public static PaintRef findNamed(String s) {
	for (int i = ls.length; --i >= 0;)
	    if (s.equalsIgnoreCase(ls[i])) {
		if (lp == null)
		    lp = new PaintRef[SystemColor.NUM_COLORS];
		PaintRef r = lp[i];
		if (r == null) lp[i] = r = new PaintRef(cl[i]);
		return r;
	    }
	return null;
    }

    private static PaintRef[] lp;
    private static String[] ls = new String[SystemColor.NUM_COLORS];
    static {
	ls[SystemColor.DESKTOP] = "desktop";
	ls[SystemColor.ACTIVE_CAPTION] = "active_caption";
	ls[SystemColor.ACTIVE_CAPTION_TEXT] = "active_caption_text";
	ls[SystemColor.ACTIVE_CAPTION_BORDER] = "active_caption_border";
	ls[SystemColor.INACTIVE_CAPTION] = "inactive_caption";
	ls[SystemColor.INACTIVE_CAPTION_TEXT] = "inactive_caption_text";
	ls[SystemColor.INACTIVE_CAPTION_BORDER] = "inactive_caption_border";
	ls[SystemColor.WINDOW] = "window";
	ls[SystemColor.WINDOW_BORDER] = "window_border";
	ls[SystemColor.WINDOW_TEXT] = "window_text";
	ls[SystemColor.MENU] = "menu";
	ls[SystemColor.MENU_TEXT] = "menu_text";
	ls[SystemColor.TEXT] = "text";
	ls[SystemColor.TEXT_TEXT] = "text_text";
	ls[SystemColor.TEXT_HIGHLIGHT] = "text_highlight";
	ls[SystemColor.TEXT_HIGHLIGHT_TEXT] = "text_highlight_text";
	ls[SystemColor.TEXT_INACTIVE_TEXT] = "text_inactive_text";
	ls[SystemColor.CONTROL] = "control";
	ls[SystemColor.CONTROL_TEXT] = "control_text";
	ls[SystemColor.CONTROL_HIGHLIGHT] = "control_highlight";
	ls[SystemColor.CONTROL_LT_HIGHLIGHT] = "control_lt_highlight";
	ls[SystemColor.CONTROL_SHADOW] = "control_shadow";
	ls[SystemColor.CONTROL_DK_SHADOW] = "control_dk_shadow";
	ls[SystemColor.SCROLLBAR] = "scrollbar";
	ls[SystemColor.INFO] = "info";
	ls[SystemColor.INFO_TEXT] = "info_text";
    }

    private static Color[] cl = new Color[SystemColor.NUM_COLORS];
    static {
	cl[SystemColor.DESKTOP] = SystemColor.desktop;
	cl[SystemColor.ACTIVE_CAPTION] = SystemColor.activeCaption;
	cl[SystemColor.ACTIVE_CAPTION_TEXT] = SystemColor.activeCaptionText;
	cl[SystemColor.ACTIVE_CAPTION_BORDER] = SystemColor.activeCaptionBorder;
	cl[SystemColor.INACTIVE_CAPTION] = SystemColor.inactiveCaption;
	cl[SystemColor.INACTIVE_CAPTION_TEXT] = SystemColor.inactiveCaptionText;
	cl[SystemColor.INACTIVE_CAPTION_BORDER] = SystemColor.inactiveCaptionBorder;
	cl[SystemColor.WINDOW] = SystemColor.window;
	cl[SystemColor.WINDOW_BORDER] = SystemColor.windowBorder;
	cl[SystemColor.WINDOW_TEXT] = SystemColor.windowText;
	cl[SystemColor.MENU] = SystemColor.menu;
	cl[SystemColor.MENU_TEXT] = SystemColor.menuText;
	cl[SystemColor.TEXT] = SystemColor.text;
	cl[SystemColor.TEXT_TEXT] = SystemColor.textText;
	cl[SystemColor.TEXT_HIGHLIGHT] = SystemColor.textHighlight;
	cl[SystemColor.TEXT_HIGHLIGHT_TEXT] = SystemColor.textHighlightText;
	cl[SystemColor.TEXT_INACTIVE_TEXT] = SystemColor.textInactiveText;
	cl[SystemColor.CONTROL] = SystemColor.control;
	cl[SystemColor.CONTROL_TEXT] = SystemColor.controlText;
	cl[SystemColor.CONTROL_HIGHLIGHT] = SystemColor.controlHighlight;
	cl[SystemColor.CONTROL_LT_HIGHLIGHT] = SystemColor.controlLtHighlight;
	cl[SystemColor.CONTROL_SHADOW] = SystemColor.controlShadow;
	cl[SystemColor.CONTROL_DK_SHADOW] = SystemColor.controlDkShadow;
	cl[SystemColor.SCROLLBAR] = SystemColor.scrollbar;
	cl[SystemColor.INFO] = SystemColor.info;
	cl[SystemColor.INFO_TEXT] = SystemColor.infoText;
    }
}
