/*
 * @(#)MouseEventMulticaster.java	1.2 97/07/25
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
package com.sun.java.swing;

import java.awt.Container;
import java.awt.event.*;
import java.awt.*;
import java.util.*;

/**
 * MouseEventMulticaster
 *
 * @version 1.2 07/25/97
 * @author Dave Moore
 */

import java.util.*;

class MouseEventMulticaster extends Vector implements MouseListener, MouseMotionListener {

    private MouseEvent currentMouseEvent(Component component, Point oldLocation, MouseEvent event) {
        Point newLocation = component.getLocationOnScreen();

        if (newLocation.equals(oldLocation)) {
            return event;
        } else {
            return new MouseEvent(component, event.getID(),
                                  event.getWhen(), event.getModifiers(),
                                  event.getX() + oldLocation.x - newLocation.x,
                                  event.getY() + oldLocation.y - newLocation.y,
                                  event.getClickCount(), event.isPopupTrigger());
        }
    }

    /**
     * Handles the mouseClicked event by invoking the
     * mouseClicked methods on listener-a and listener-b.
     * @param e the mouse event
     */
    public void mouseClicked(MouseEvent e) {
        int count = size();

        if (count == 1) {
            ((MouseListener)elementAt(0)).mouseClicked(e);
        } else {
            Component component = e.getComponent();
            Point oldLocation = component.getLocationOnScreen(), newLocation;

            while (count-- > 0) {
                ((MouseListener)elementAt(count)).mouseClicked(
                    currentMouseEvent(component, oldLocation, e));
            }
        }
    }

    /**
     * Handles the mousePressed event by invoking the
     * mousePressed methods on listener-a and listener-b.
     * @param e the mouse event
     */
    public void mousePressed(MouseEvent e) {
        int count = size();

        if (count == 1) {
            ((MouseListener)elementAt(0)).mousePressed(e);
        } else {
            Component component = e.getComponent();
            Point oldLocation = component.getLocationOnScreen(), newLocation;

            while (count-- > 0) {
                ((MouseListener)elementAt(count)).mousePressed(
                    currentMouseEvent(component, oldLocation, e));
            }
        }
    }

    /**
     * Handles the mouseReleased event by invoking the
     * mouseReleased methods on listener-a and listener-b.
     * @param e the mouse event
     */
    public void mouseReleased(MouseEvent e) {
        int count = size();

        if (count == 1) {
            ((MouseListener)elementAt(0)).mouseReleased(e);
        } else {
            Component component = e.getComponent();
            Point oldLocation = component.getLocationOnScreen(), newLocation;

            while (count-- > 0) {
                ((MouseListener)elementAt(count)).mouseReleased(
                    currentMouseEvent(component, oldLocation, e));
            }
        }
    }

    /**
     * Handles the mouseEntered event by invoking the
     * mouseEntered methods on listener-a and listener-b.
     * @param e the mouse event
     */
    public void mouseEntered(MouseEvent e) {
        int count = size();

        if (count == 1) {
            ((MouseListener)elementAt(0)).mouseEntered(e);
        } else {
            Component component = e.getComponent();
            Point oldLocation = component.getLocationOnScreen(), newLocation;

            while (count-- > 0) {
                ((MouseListener)elementAt(count)).mouseEntered(
                    currentMouseEvent(component, oldLocation, e));
            }
        }
    }

    /**
     * Handles the mouseExited event by invoking the
     * mouseExited methods on listener-a and listener-b.
     * @param e the mouse event
     */
    public void mouseExited(MouseEvent e) {
        int count = size();

        if (count == 1) {
            ((MouseListener)elementAt(0)).mouseExited(e);
        } else {
            Component component = e.getComponent();
            Point oldLocation = component.getLocationOnScreen(), newLocation;

            while (count-- > 0) {
                ((MouseListener)elementAt(count)).mouseExited(
                    currentMouseEvent(component, oldLocation, e));
            }
        }
    }

    /**
     * Handles the mouseDragged event by invoking the
     * mouseDragged methods on listener-a and listener-b.
     * @param e the mouse event
     */
    public void mouseDragged(MouseEvent e) {
        int count = size();

        if (count == 1) {
            ((MouseMotionListener)elementAt(0)).mouseDragged(e);
        } else {
            Component component = e.getComponent();
            Point oldLocation = component.getLocationOnScreen();

            while (count-- > 0) {
                MouseEvent newEvent = currentMouseEvent(component, oldLocation, e);

                ((MouseMotionListener)elementAt(count)).mouseDragged(newEvent);
            }
        }
    }

    /**
     * Handles the mouseMoved event by invoking the
     * mouseMoved methods on listener-a and listener-b.
     * @param e the mouse event
     */
    public void mouseMoved(MouseEvent e) {
        int count = size();

        if (count == 1) {
            ((MouseMotionListener)elementAt(0)).mouseMoved(e);
        } else {
            Component component = e.getComponent();
            Point oldLocation = component.getLocationOnScreen(), newLocation;

            while (count-- > 0) {
                ((MouseMotionListener)elementAt(count)).mouseMoved(
                    currentMouseEvent(component, oldLocation, e));
            }
        }
    }
}
