package com.sun.java.swing;

import com.sun.java.swing.border.*;
import com.sun.java.swing.basic.*;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.text.*;
import com.sun.java.swing.plaf.*;

public class MoneyChooser extends Container implements ActionListener
{
  protected JButton calc;
  protected JPopupMenu popup;
  protected Locale myLocale;
  protected NumberFormat myFormat;
  protected Calculator calculator;
  //  protected MoneyField moneyfield;
  protected SpinnerHolder inputfield;
  protected double totalCash = 0;
  
  
  protected GridBagLayout layout = new GridBagLayout();
  protected GridBagConstraints cons = new GridBagConstraints();
  
  public MoneyChooser()
  {
    intialize(4,Locale.getDefault());
  }
  public MoneyChooser(int digits)
  {
    intialize(digits,Locale.getDefault());
    
  }
  public MoneyChooser(int digits, Locale aLocale)
  {
    intialize(digits,aLocale);
  }

  private void intialize(int digits, Locale aLocale)
  {
    if((digits >15) || (digits < 0))
      {
	throw new IllegalArgumentException("int argument must be in the range 0<int<16");
      }
    myLocale = aLocale;
    myFormat = NumberFormat.getCurrencyInstance(myLocale);
    
//     cons.gridx = 0;
//     cons.gridy = 0;
//     cons.weightx = 1;
//     cons.weighty = 1;
//     cons.insets = new Insets(10,10,10,10);
//     setLayout(layout);

//     GridBagConstraints cons = this.cons;
//     cons.insets = new Insets(0,0,0,0);
//     cons.gridx = GridBagConstraints.RELATIVE;

    calc = new JButton("Calc");
    calc.addActionListener(this);

    setLayout(new FlowLayout());
    //moneyfield = new MoneyField(digits); 
    //add(moneyfield);
    inputfield = new SpinnerHolder(digits);
    add(inputfield);
    add(calc);
  }

  //  public void getCalculatorInfo()
  //{
 //    int pounds;
//     int pennies;
//     //totalCash = ((Calculator)(popup.getComponent(0))).convertOutput();
//     Float floater = new Float(totalCash*100);
//     pounds = floater.intValue()/100;
//     pennies = floater.intValue()%100;
//     dollars.setValue(pounds);
//     if(cents != null)
//       {
// 	cents.setValue(pennies);
//       }
  // }

  public void setCalculatorEnable(boolean enable)
  {
    if(enable)
      {
	if(calc == null)
	  {
	    calc = new JButton("Calc");
	    calc.addActionListener(this);
	    add(calc,cons);
	  }
      }
    else
      {
	if(calc != null)
	  {
	    remove(calc);
	    calc = null;
	  }
	popup = null;
      }
  }
  public void setValue(double newValue)
  {
    totalCash = newValue;
    inputfield.setNewInput(totalCash);
  }
  public double getValue() {return totalCash;}
  public void actionPerformed(ActionEvent e) 
  {
    if(e.getActionCommand().equals("Calc"))
      {
	if(popup == null)
	  {
	    popup = new JPopupMenu();
	    calculator = new Calculator();
	    calculator.getOKButton().addActionListener(this);
	    popup.add(calculator);
	    
	    //Point p = calc.getLocationOnScreen();
	    //popup.setLocation(p.x,p.y);
	    //popup.setVisible(true);
	  }
	popup.show(calc,0,0);
      }
    else if(e.getSource() == calculator.getOKButton())
      {
	popup.setVisible(false);
	totalCash = calculator.convertOutput();
	inputfield.setNewInput(totalCash);
      }
  }
//   class MoneyField extends Component
//   {
//     private int digits;
//     private int digitsTyped = 0;
//     private double maxValue;
//     private int ascent;
//     private Dimension d;
//     private FontMetrics fm;
//     private boolean haveFocus= false;
//     private int[][] splitArray;
//     private int splitArrayLength = 0;
//     private int currentRegion = -1;
//     private int tempRegion = -1;
//     private int maxChars = 0;
//     private char splitter = '.';
    

//     public MoneyField(int digits)
//     {
//       this.digits = digits;
//       enableEvents(AWTEvent.FOCUS_EVENT_MASK|AWTEvent.KEY_EVENT_MASK
// 		   |AWTEvent.MOUSE_EVENT_MASK|AWTEvent.MOUSE_MOTION_EVENT_MASK);
//     }

//     public Dimension getPreferredSize() 
//     {
//       return getMinimumSize();
//     }
//     public Dimension getMinimumSize() 
//     {
//       if (d == null) 
// 	{
// 	  fm = getFontMetrics(getFont());
// 	  int w = 0;
// 	  maxValue = Math.pow(10,digits)-.01;
	  
// 	  //totalCash = 987654.32;
// 	  String s = myFormat.format(maxValue);
// 	  w= fm.stringWidth(s);	  
// 	  d = new Dimension(w+8, fm.getHeight()+8);
// 	  ascent = fm.getAscent();
// 	  maxChars = s.length();

// 	  int tempArray[][] = new int[s.length()][2];
// 	  int i,j;
// 	  j = 0;
// 	  for(i=0; i<s.length(); i++)
// 	    {
// 	      if('0'>s.charAt(i) || s.charAt(i)>'9')
// 		{
// 		  i++;
// 		  if(i<s.length())
// 		    {
// 		      while('0'>s.charAt(i) || s.charAt(i)>'9') 
// 			{
// 			  i++;
// 			  if(i>=s.length()) {break;}
// 			}
// 		    }
// 		  i--;
// 		  tempArray[j][0] = 4+fm.stringWidth(s.substring(0,i+1));
// 		  tempArray[j][1] = i;
// 		  j++;
// 		}
// 	      else if(j == 0)
// 		{
// 		  //System.out.println("set pre-split");
// 		  tempArray[0][0] = 4;
// 		  tempArray[0][1] = -1;
// 		  j++;
// 		}
// 	      else if(s.charAt(i) == '4') 
// 		{
// 		  if(i+1 <s.length()) {splitter = s.charAt(i+1);}
// 		}
// 	    }
// 	  splitArray = new int[j][2];
// 	  for(i=0; i<j; i++)
// 	    {
// 	      splitArray[i][0] = tempArray[i][0];
// 	      splitArray[i][1] = tempArray[i][1];
// 	    }
// 	  splitArrayLength = j;
// 	}
//       return d;
//     }
//     public void paint(Graphics g) 
//     {
//       if (d == null) getMinimumSize(); //Force computation of ascent
      
//       g.setColor(Color.white);
//       g.drawRect(0,0,d.width-1,d.height-1);
//       g.setColor(Color.black);
//       g.drawLine(0,0,0,d.height-1);
//       g.drawLine(1,0,1,d.height-3); 
//       g.drawLine(1,0,d.width,0);
//       g.drawLine(1,1,d.width-2,1);
//       g.setColor(Color.white);
//       g.fillRect(3,3,d.width-5,d.height-5);
//       g.setColor(Color.black);
      
      
//       String s = myFormat.format(totalCash);
//       g.drawString(s, getSize().width-fm.stringWidth(s) - 4, ascent + 4);

//       if (haveFocus) 
// 	{
// 	  g.setColor(new Color(0,0,150));
// 	  if(currentRegion > -1)
// 	    {
	      
	      
// 	      int startPointX = splitArray[currentRegion][0];
// 	      int stopPointX = 0;
// 	      int startIndex = splitArray[currentRegion][1];
// 	      int offset = maxChars - s.length();
// 	      if(startIndex > -1)
// 		{
// 		  while(startIndex-offset < 0 ) 
// 		    {
// 		      startIndex++;
// 		      startPointX = startPointX + fm.charWidth('0');
// 		    }
// 		}
// 	      int stopIndex = 0;
// 	      if(currentRegion == splitArrayLength -1)
// 		{
// 		  stopPointX = d.width-4;
// 		  stopIndex = maxChars-1;
// 		}
// 	      else
// 		{
// 		  stopPointX = splitArray[currentRegion+1][0];
// 		  stopIndex = splitArray[currentRegion+1][1];
// 		}
// 	      if(stopIndex-offset+1 > 0)
// 		{
// 		  while(startIndex-offset+1 < 0) 
// 		    {
// 		      startIndex++;
// 		      startPointX = startPointX + fm.charWidth('0');
// 		    }
// 		  g.fillRect(startPointX,4, stopPointX-startPointX,d.height-7);
// 		  g.setColor(Color.white);
// 		  g.drawString(s.substring(startIndex-offset+1,
// 					   stopIndex-offset+1),startPointX,ascent+4);
// 		}	      
// 	    }
// 	  else
// 	    {
// 	      g.fillRect(4,4, d.width-7,d.height-7);
// 	      g.setColor(Color.white);
// 	      g.drawString(s,getSize().width-fm.stringWidth(s) - 4,ascent+4);	      
// 	    }
// 	  g.setColor(Color.black);
// 	}
//     } 
//     public void update(Graphics g) {
//       paint(g);
//     }
//     protected void processFocusEvent(FocusEvent e)
//     {
//       if ((e.getID()==e.FOCUS_GAINED)!=haveFocus) {
// 	haveFocus = !haveFocus;
// 	if(haveFocus)
// 	  {
// 	    digitsTyped = 0;
// 	    currentRegion = -1;
// 	  }
// 	repaint();
//       }
//     }
//     protected void  processKeyEvent(KeyEvent e)
//     {
//       int c = 0;
//       if (e.getID() != e.KEY_PRESSED) return;
//       if (e.isActionKey())
// 	switch(e.getKeyCode()) {
// 	case e.VK_DOWN:
// 	  totalCash = totalCash - Math.pow(10,getWeight(firstIntIndex(maxValue)));
// 	  repaint();
// 	  break;
// 	case e.VK_LEFT:
// 	  digitsTyped = 0;
// 	  if(currentRegion >0)
// 	    {
// 	      currentRegion--;
// 	      repaint();
// 	    }
// 	  else
// 	    {
// 	      if(splitArray[splitArrayLength-1][1] != maxChars-1) {c = 1;}
// 	      else {c = 2;}
// 	      currentRegion = splitArrayLength-c;
// 	      repaint();
// 	    }
// 	  break;
// 	case e.VK_UP:
// 	  totalCash = totalCash + Math.pow(10,getWeight(firstIntIndex(maxValue)));
// 	  repaint();
// 	  break;
// 	case e.VK_RIGHT:
	  
// 	  if(splitArray[splitArrayLength-1][1] != maxChars-1) {c = 1;}
// 	  else {c = 2;}
// 	  if(currentRegion == splitArrayLength-c)
// 	    {
// 	      currentRegion = 0;
// 	    }
// 	  else {currentRegion ++;}
// 	  digitsTyped = 0;
// 	  repaint();
// 	  break;
// 	}
//       else {
// 	c = e.getKeyChar();
// 	if ('0'<=c && c<='9') {
// 	  //System.out.println(digitsTyped);
// 	  //System.out.println(intsInRegion(maxValue));
// 	  if(digitsTyped < intsInRegion(maxValue))
// 	    {
// 	      int i;
// 	      if (digitsTyped == 0)
// 		{
// 		  if(currentRegion >-1)
// 		    {
// 		      int index = firstIntIndex(totalCash);
// 		      int weightIndex = firstIntIndex(maxValue);
// 		      int len = intsInRegion(totalCash);
// 		      String s = myFormat.format(totalCash);
// 		      //System.out.println(s);
// 		      for(i=0; i<len; i++)
// 			{
// 			  //System.out.println((double)(s.charAt(index)-'0'));
// 			  totalCash = totalCash - ((double)(s.charAt(index)-'0'))*Math.pow(10,getWeight(weightIndex));
// 			  //System.out.println(myFormat.format(totalCash));
// 			  index--;
// 			  weightIndex--;
// 			}
// 		    }
// 		  else {totalCash = 0.00;}
  
// 		}
// 	      double nv = getThisRegion();
// 	      nv = totalCash -nv + nv*10;
// 	      nv = nv +(((double)(c-'0'))*Math.pow(10,getWeight(firstIntIndex(maxValue))));
// 	      if ((nv<=maxValue) && (nv>=0))
// 		{
// 		  totalCash = nv;
// 		  digitsTyped++;
// 		  repaint();
// 		}
// 	    }
// 	}
// 	else switch(c) {
// 	case 0177:
// 	case '\b': 
// 	  //totalCash = totalCash/10; 
// 	  //repaint();
// 	  break;
// 	case '-': //setValue(-value); break;
// 	  //case '\t': transferFocus(); break;
// 	}
//       }
//       return;
//     }
//     protected void processMouseEvent(MouseEvent e)
//     {
//       if (e.getID()==e.MOUSE_PRESSED) requestFocus();
//       return;
//     }
//     protected void processMouseMotionEvent(MouseEvent e)
//     {
//       if(haveFocus)
// 	{
// 	  int i = findSelectedRegion(e.getX());
// 	  if (currentRegion < 0) {if(tempRegion <0) {tempRegion = i;}}
// 	  else {tempRegion = currentRegion;}
// 	  if(i != tempRegion)
// 	    {
// 	      currentRegion = i;
// 	      digitsTyped = 0;
// 	      repaint();
// 	    }
// 	}
//       return;
//     }

//     private int findSelectedRegion(int x)
//     {
//       int i;
//       for(i=1; i<splitArrayLength; i++)
// 	{
// 	  if(x <= splitArray[i][0])
// 	    {
// 	      return i-1;
// 	    }
// 	}
//       return splitArrayLength-1;
//     }
//     private int getWeight(int index)
//     {
//       String s = myFormat.format(maxValue);
//       int i,j, len;
//       char ch;
//       j = index;
//       String stripped = "";
//       len = s.length();
//       for(i=0; i<len; i++)
// 	{
// 	  ch = s.charAt(i);
// 	  if(('0'>ch || ch>'9') && (ch != splitter))
// 	    {
// 	      if(i< index){j--;}
// 	    }
// 	  else
// 	    {
// 	      stripped = stripped + s.substring(i,i+1);
// 	    }
// 	}
//       i = stripped.indexOf(splitter);
//       if(i>-1)
// 	{
// 	  if(i-j > 0) {return i-j-1;}
// 	  return  i-j;
// 	}
//       return stripped.length() - j - 1;
      
//     }
//     private int firstIntIndex(double value)
//     {
//       String s = myFormat.format(value);
//       char ch;
//       int index;
//       if(currentRegion > -1)
// 	{
// 	  if(currentRegion == splitArrayLength -1) {return s.length()-1;}
// 	  index = splitArray[currentRegion+1][1] - (myFormat.format(maxValue).length()-s.length());
	  
	  
// 	}
//       else {index = s.length() -1;}
//       if(index<0) {return -1;}
//       ch = s.charAt(index);
//       while('0'>ch || ch>'9')
// 	{
// 	  index--;
// 	  if(index<0) {return -1;}
// 	  ch = s.charAt(index);
// 	}
//       return index;
//     }
//     private int intsInRegion(double value)
//     {
//       if(currentRegion > -1)
// 	{
// 	  String s =  myFormat.format(value);
// 	  char ch;
// 	  int total = 0;
// 	  int index = firstIntIndex(value);
	  
// 	  if(index<0) {return 0;}
// 	  ch = s.charAt(index);
// 	  while('0'<=ch && ch<='9' && index>=0)
// 	    {
// 	      total++;
// 	      index--;
// 	      if(index>=0) {ch = s.charAt(index);}
// 	    }
// 	  return total;
// 	}
//       return this.digits+2;
//     }
//     private double getThisRegion()
//     {
//       if(currentRegion >-1)
// 	{
// 	  String s =  myFormat.format(totalCash);
// 	  char ch;
// 	  double total = 0.00;
// 	  int index = firstIntIndex(totalCash);
// 	  int weightIndex = firstIntIndex(maxValue);
// 	  int i, len;
// 	  len = intsInRegion(totalCash);
// 	  for(i=0; i<len; i++)
// 	    {
// 	      ch = s.charAt(index);
// 	      if('0'<=ch && ch<='9') 
// 		{
// 		  total= total +((double)(ch-'0'))*Math.pow(10,getWeight(weightIndex));
// 		  index--;
// 		  weightIndex--;
// 		}
// 	    }
// 	  return total;
// 	}
//       return totalCash;
//     }
//     public void setNewInput()
//     {
//       digitsTyped = 0;
//       haveFocus= true;
//       requestFocus();
//       currentRegion = -1;
//       tempRegion = -1;
//       repaint();
//     }
//   }
  protected JPanel createJPanel()
  {
    JPanel bp = new JPanel();
    bp.setLayout(new FlowLayout(FlowLayout.CENTER,0,0));
    bp.setBorder(BorderFactory.createEtchedBorder());
    return bp;
  }

  class SpinnerHolder extends JPanel
  {
    int digits;
    boolean stringFirst;
    MoneySpinner[] mySpinners;
    TextBlock[] myStrings;
    
    public SpinnerHolder(int nDigits)
    {
      //this = createJPanel();  
      super();
      setLayout(new FlowLayout(FlowLayout.CENTER,0,0));
      setBorder(BorderFactory.createEtchedBorder());
      this.digits = nDigits;
      ParseCM();
      LayTheBattery();
    }
    public boolean isDigit(char ch)
    {
      if('0'<=ch && ch<='9') {return true;}
      return false;
    }
    public void ParseCM()
    {
      int numSpinners=0;
      int numStrings=0;
      int counter,i,j,weight;
      String s = myFormat.format(Math.pow(10,digits)-.01);
      if(isDigit(s.charAt(0))) {stringFirst = false;}
      else {stringFirst=true;}
      counter=-1;
      j=s.length();
      for(i=0; i<j; i++)
	{
	  if(isDigit(s.charAt(i)))
	    {
	      if(counter != 0) {numSpinners++;}
	      counter=0;
	    }
	  else
	    {
	      if(counter !=1) {numStrings++;}
	      counter=1;
	    }
	}
      mySpinners = new MoneySpinner[numSpinners];
      myStrings = new TextBlock[numStrings];
      numSpinners=0;
      numStrings=0;
      weight=digits;
      
      for(i=0; i<j; i++)
	{
	  if(isDigit(s.charAt(i)))
	    {
	      counter=0;
	      while((i<j) && (isDigit(s.charAt(i))))
		{
		  counter++;
		  i++;
		}
	      i--;
	      weight=weight-counter;
	      mySpinners[numSpinners]=new MoneySpinner();
	      mySpinners[numSpinners].setDigits(counter);
	      mySpinners[numSpinners].setMaximum((int)(Math.pow(10,counter)-1));
	      mySpinners[numSpinners].setBorder(new EmptyBorder(0,0,0,0));
	      mySpinners[numSpinners].setWrap(true);
	      mySpinners[numSpinners].setWeight(weight);
	      mySpinners[numSpinners].setIndex(numSpinners);
	      if(weight < 0) {mySpinners[numSpinners].setLeadingPad(0);}
	      numSpinners++;
	    }
	  else
	    {
	      counter=0;
	      while((i+counter<j) && !(isDigit(s.charAt(i+counter))))
		{
		  counter++;
		}
	      myStrings[numStrings]=new TextBlock(s.substring(i,i+counter),numStrings);
	      i=i+counter-1;
	      numStrings++;
	    }
	}
      if(numSpinners > 1)
	{
	  ChainLinker cl = new ChainLinker(mySpinners[0], mySpinners[numSpinners-1], mySpinners[1]);
	  cl = new ChainLinker(mySpinners[numSpinners-1], mySpinners[numSpinners-2], mySpinners[0]);
	  for(i=1; i<numSpinners-1; i++)
	  {
	      cl = new ChainLinker(mySpinners[i], mySpinners[i-1], mySpinners[i+1]);
	  }
	}
    }
    public void LayTheBattery()
    {
      int stringsIndex=0;
      int spinnersIndex=0;
      if(stringFirst) {add(myStrings[0]); stringsIndex++;}
      while((stringsIndex<myStrings.length) || (spinnersIndex<mySpinners.length))
      while(spinnersIndex<mySpinners.length)
	{
	  if(spinnersIndex<mySpinners.length) {add(mySpinners[spinnersIndex]); spinnersIndex++;}
	  if(stringsIndex<myStrings.length) {add(myStrings[stringsIndex]); stringsIndex++;}
	}
    }
    public void setNewInput(double newValue)
    {
      int valWeight = digits;
      while(newValue/Math.pow(10,valWeight) < 1) {valWeight--;}
      if(valWeight == digits) {throw new IllegalArgumentException("Value is too large");}
      if(valWeight < mySpinners[mySpinners.length-1].getWeight())
	{
	  throw new IllegalArgumentException("Value is too small"); 
	}
      int i=0;
      while(mySpinners[i].getWeight() > valWeight) 
	{
	  mySpinners[i].setValue(0);
	  i++;
	}
      valWeight=i;
      for(i=i; i<mySpinners.length; i++)
	{
	  mySpinners[i].setValue((int)(newValue/Math.pow(10,mySpinners[i].getWeight())));
	  newValue = newValue%Math.pow(10,mySpinners[i].getWeight());
	}
      mySpinners[valWeight].requestFocus();
    }
	    
      
    //public FontMetrics getUIFontMetrics() {return (new MoneySpinnerUI()).getUIFontMetrics();}
    class MoneySpinner extends Spinner
    {
      int weight;
      int index;
      public MoneySpinner()
      {
	super(0,"");
	setUI(new MoneySpinnerUI());
      }
      public void setWeight(int newWeight) {weight=newWeight;}
      public int getWeight() {return weight;}
      public void setIndex(int newIndex) {index=newIndex;}
      public int getIndex() {return index;}
      public int getDigitsTyped() {return digitsTyped;}
    }

    class MoneySpinnerUI extends BasicSpinnerUI
    {
      public void paint(Graphics g, JComponent c)
      {
	MoneySpinner spinner = ((MoneySpinner)(c));	
	getMinimumSize(c); //Force computation of dimension
	Insets bi = spinner.getBorder().getBorderInsets(spinner);
	g.setColor(spinner.getBackgroundColor());
	g.fillRect(bi.left,bi.top,d.width-(bi.left+bi.right),d.height-(bi.top+bi.bottom));
// 	if(spinner.getBorder() != null) 
// 	  {
// 	    spinner.getBorder().paintBorder(g,0,0,d.width-1,d.height-1);
// 	  } 
	if((spinner.getIndex()>0) && (spinner.getWeight() >-1))
	  {
	    if((mySpinners[spinner.getIndex()-1].getValue()>0) || 
	       (mySpinners[spinner.getIndex()-1].getLeadingPad()==0) ||
	       (mySpinners[spinner.getIndex()-1].hasFocus()))
	      {
		spinner.setLeadingPad(0);
	      }
	    else 
	      {
		spinner.setLeadingPad(-1);
	      }
	  }
	if (spinner.hasFocus()) 
	  {
	    g.setColor(new Color(0,0,150));
	    g.fillRect(bi.left+2, bi.top+2, d.width-(bi.left+bi.right+4), d.height-(bi.top+bi.bottom+4));
	    g.setColor(Color.white);
	  }
	else
	  {
	    g.setColor(Color.black);
	  }
	String s;
	s = Integer.toString(spinner.getValue());
	if(spinner.getLeadingPad() != -1)
	  {
	    int j = spinner.getDigits()-s.length();
	    String lp = Integer.toString(spinner.getLeadingPad());
	    for(int i=0; i<j; i++) { s = lp +s;}
	  }
	
	if((spinner.getWeight()  < 1) || (spinner.getValue()>0) || (spinner.hasFocus()) ||
	   (spinner.getLeadingPad()==0))
	  {
	    g.drawString(s, d.width-fm.stringWidth(s) - bi.right-2, ascent + bi.bottom+2);	
	  }
      }
    }
    class TextBlock extends JComponent
    {
      //frosty man, frosty
      String myString;
      Dimension d = new Dimension(0,0);
      FontMetrics fm;
      int textIndex;

      public TextBlock(String s, int ind)
      {
	myString = s;
	textIndex = ind;
      }
      public Dimension getPreferredSize()
      {
	return getMinimumSize();
      }
      public Dimension getMinimumSize()
      {
	if(fm == null) {fm = getFontMetrics(getFont());}
	d.width = fm.stringWidth(myString) + 2;
	d.height = fm.getHeight()+4;
	return d;
      }
      public void paint(Graphics g)
      {
	if(d==null) {getMinimumSize();}
	g.setColor(mySpinners[0].getBackgroundColor());
	g.fillRect(0,0,d.width,d.height);
	g.setColor(Color.black);

	int offset=0;
	boolean showString= false;
	if(stringFirst) {offset=1;}
	if((stringFirst) && (textIndex==0)) {showString = true;}
	if(!showString)
	  {
	    if((mySpinners[textIndex-offset].getValue()>0) || (mySpinners[textIndex-offset].getLeadingPad()>=0) 
	      || (mySpinners[textIndex-offset].hasFocus()) || (mySpinners[textIndex-offset].getWeight()<2)) 
	      {showString=true;}
	  }
	if(showString) {g.drawString(myString,1,fm.getAscent()+2);}
      }
      public void setFont(Font f) 
      {
	if (f != getFont()) 
	  {
	    super.setFont(f);
	    d = null;
	    invalidate();
	  }
      }
      public int getIndex() {return textIndex;}
    }
    class ChainLinker implements KeyListener, FocusListener
    {
      MoneySpinner watcher;
      MoneySpinner previous;
      MoneySpinner next;
      int digitsTyped=0;
      int maxTyped=0;

      public ChainLinker(MoneySpinner toWatch, MoneySpinner prev, MoneySpinner nex)
      {
	watcher = toWatch;
	previous = prev;
	next = nex;
	watcher.addKeyListener(this);
	watcher.addFocusListener(this);
      }
      public void keyTyped(KeyEvent e){}
      public void keyPressed(KeyEvent e)
      {
	if (e.isActionKey())
	  switch(e.getKeyCode()) 
	    {
	    case e.VK_LEFT:    
	      previous.requestFocus();
	      break;
	    case e.VK_RIGHT:   
	      next.requestFocus();
	      break;
	    }
	else if(isDigit(e.getKeyChar()))
	  {
	    digitsTyped++;
	    int ind = watcher.getIndex();
	    if((digitsTyped > watcher.getDigits()) && (ind !=0) && (digitsTyped<=maxTyped))
	       {
		 int k,l;		 
		 l = e.getKeyChar()-'0';
		 
		 while(ind>0)
		   {
		     k = mySpinners[ind].getValue()/((int)(Math.pow(10,mySpinners[ind].getDigits()-1))); 
		     mySpinners[ind].setValue((mySpinners[ind].getValue()-k*
					       ((int)(Math.pow(10,mySpinners[ind].getDigits()-1))))*10+l);
		     if(mySpinners[ind-1].getValue()*10+k <= mySpinners[ind-1].getMaximum()) 
		       {
			 mySpinners[ind-1].setValue(mySpinners[ind-1].getValue()*10+k);
			 ind = 0;
		       }
		     l=k;
		     ind--;
		   }
	       }
	  }
      }
      public void keyReleased(KeyEvent e){}

      public void focusGained(FocusEvent e) 
      {
	digitsTyped = 0;
	maxTyped = watcher.getDigits();
	for(int i=watcher.getIndex()-1; i>=0; i--)
	  {
	    if(mySpinners[i].getValue() == 0)
	      {
		maxTyped = maxTyped+mySpinners[i].getDigits();
	      }
	    else
	      {
		maxTyped = watcher.getDigits();
		i = -1;
	      }
	  }
	//int k = ((MoneySpinner)(e.getSource())).getIndex()+1;
	int j = mySpinners.length;
	//if(k==j) {k=0;}
	for(int i=0; i<j; i++)
	  {
	    mySpinners[i].paint(mySpinners[i].getGraphics()); 
	  }
      }
      public void focusLost(FocusEvent e){}

//       public void adjustmentValueChanged(AdjustmentEvent e)
//       {

// 	j= myStrings.length;
// 	if(!stringFirst) {k--;}
// 	for(int i=k; i<j; i++)
// 	  {
// 	    myStrings[i].repaint();
// 	  }
//      }
    }
  }
}

