/*
 * @(#)ImagePreview.java	1.6 01/28/98
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not disclose
 * such Confidential Information and shall use it only in accordance with the
 * terms of the license agreement you entered into with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
 * ITS DERIVATIVES.
 * 
 * @author James Gosling
 * @author Ray Ryan
 */

package com.sun.java.swing;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.File;

import com.sun.java.swing.event.*;

/** A component to preview an image file, intended to serve as
 *  an accessory to a JFileChooser.
 */
public class JImagePreviewer extends JComponent implements ActionListener {
    private Image img;
    private boolean imgKnown;
    private long lastUpdateTime = 0;
    private static Dimension isize = new Dimension(120, 120);
    private boolean blank;

//     private static FileChooserFilter fcf;

//     /** Convenience method to prompt for the name of an image file.
// 	@param fparent the parent frame for the dialog box.
// 		fparent may be null if a default parent has
// 		been established with StandardDialog
// 	@param description a description string that will be shown
// 		to the user to indicate what is being requested
// 	@param initial the initial value for the string
// 	@param columns the default width (in 'm's) of the TextField
// 	@param target the ChangeListener that will be informed if the
// 			OK or Apply buttons are hit.
// 	@return If target is null,
// 		the dialog box will be modal and the method
// 		will return the final result, or null if canceled.
// 		Otherwise, the
// 		dialog box is non-modal, the method returns null
// 		immediatly, and the listener is informed when
// 		appropriate.  The source of the change event will
// 		be a FileChooser.
// 	@see StandardDialog
//      */
//     public static File ask(Component parent, String title, File dfc,
// 			        ChangeListener target) {
// 	StandardDialog tDialog;
// 	FileChooser tChooser;
// 	tChooser = new FileChooser();
// 	tDialog = new StandardDialog(parent, tChooser, target == null);
// 	if (fcf == null) {
// 	    fcf = new FileChooserFilter();
// 	    fcf.add("Web images (gif,jpg,jpeg)");
// 	}
// 	tChooser.setFilter(fcf);
// 	tChooser.setPreview(new JImagePreviewer ());
// 	if (target != null)
// 	    tDialog.addChangeListener(target);
// 	if (title != null)
// 	    tDialog.setTitle(title);
// 	tChooser.getModel().setFile(dfc);
// 	tDialog.start();
// 	File r = tDialog.isCanceled() || target != null ? null
// 	: tChooser.getModel().getFile();
// 	if (target == null)
// 	    tDialog.dispose();
// 	return r;
//     }

    public JImagePreviewer () {
    }

    public void setPreviewFile(File f) {
	System.out.println("Let's preview file " + f);
	if (f == null) {
	    if (!blank) {
		blank = true;
		repaint();
	    }
	    return;
	}
	blank = false;
	img = getToolkit().getImage(f.getPath());
	this.img = img;
	if (isShowing())
	    repaint(10);
    }

    public void actionPerformed(ActionEvent evt) {
	Object source = evt.getSource();
	if (source instanceof JDirectoryPane) {
	    this.setPreviewFile(((JDirectoryPane)source).getSelectedFile());
	}
    }

    public Dimension getPreferredSize() {
	return isize;
    }

    public Dimension getMinimumSize() {
	return getPreferredSize();
    }

    public synchronized boolean imageUpdate(Image img,
					    int infoflags,
					    int x, int y,
					    int width, int height) {
	if (img != this.img)
	    return false;
	long t = System.currentTimeMillis();
	if (lastUpdateTime + 500 < t || (infoflags & (ALLBITS | FRAMEBITS | ERROR | ABORT)) != 0) {
	    repaint(10);
	    lastUpdateTime = t;
	}
	if ((infoflags & (ERROR | ABORT)) != 0) {
	    img = null;
	    return false;
	}
	return (infoflags & ALLBITS) == 0;
    }

    public void paint(Graphics g) {
	if (blank) 
	    return;

	Image i = img;
	Dimension d = getSize();
	if (i == null)
	    return;
	int w = i.getWidth(this);
	int h = i.getHeight(this);
	int iw, ih;
	float aspect = (float) w / (float) h;
	int dh = (int) (d.width / aspect);
	int dw = (int) (d.height * aspect);
	if (dh > d.height) {
	    iw = dw;
	    ih = d.height;
	} else {
	    iw = d.width;
	    ih = dh;
	}
	if (iw >= w && ih >= h) {
	    iw = w;
	    ih = h;
	}
	if (w < 0 || h < 0)
	    return;
	g.drawImage(i, (d.width - iw) >> 1, (d.height - ih) >> 1, iw, ih, this);
    }
}
