/*
 * @(#)DefaultCellRenderer.java	1.17 98/01/12
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing;

import java.awt.Component;
import java.awt.Color;
import java.lang.Boolean;
import com.sun.java.swing.table.*;
import com.sun.java.swing.*;
import java.io.Serializable;

/**
 * @version 1.17 01/12/98
 * @author Hans Muller
 * @author Alan Chung
 * @see JTable
 */

public class DefaultCellRenderer implements TableCellRenderer, Serializable {

    // PENDING(alan): Should use system selection color
    protected final static Color selectionColor = new Color(0,0,128);

//
// Instance Variables
//

    protected JComponent component;
    protected ValueProperty value;

    protected Color backgroundColor;
    protected Color foregroundColor;
    protected Color selectedBackgroundColor;
    protected Color selectedForegroundColor;

//
// Constructors
//

    public DefaultCellRenderer(JLabel x) {
        this.component = x;
	x.setOpaque(true);
        this.value = new ValueProperty() {
            public void setValue(Object x) {
		// Set value to empty string so it will display a
		// blank cell, and not cause an exception
		if (x == null)
		    x = "";

                super.setValue(x);
		if (x instanceof Icon)
		    ((JLabel)component).setIcon((Icon)x);
		else
		    ((JLabel)component).setText(x.toString());
            }
        };

	// Default label colors
	/*
	setBackgroundColor(Color.white);
	setForegroundColor(Color.black);
	setSelectedBackgroundColor(selectionColor);
	setSelectedForegroundColor(Color.white);
	*/
    }

    public DefaultCellRenderer(JButton x) {
        this.component = x;
        this.value = new ValueProperty() {
            public void setValue(Object x) {
		// Set value to empty string so it will display a
		// blank button, and not cause an exception
		if (x == null)
		    x = "";

                super.setValue(x);
                ((JButton)component).setText(x.toString());
            }
        };

	// Default button colors
	/*
	setBackgroundColor(Color.lightGray);
	setForegroundColor(Color.black);
	setSelectedBackgroundColor(Color.darkGray);
	setSelectedForegroundColor(Color.white);
        */
    }

    public DefaultCellRenderer(JCheckBox x) {
        this.component = x;
        this.value = new ValueProperty() {
            public void setValue(Object x) {
		// Set value to empty string so it will not
		// cause an exception
		if (x == null)
		    x = "";

                super.setValue(x);

		// Try my best to do the right thing with x
		if (x instanceof Boolean) {
		    ((JCheckBox)component).setSelected(((Boolean)x).booleanValue());
		}
		else if (x instanceof String) {
		    Boolean b = new Boolean((String)x);
		    ((JCheckBox)component).setSelected(b.booleanValue());
		}
		else {
		    ((JCheckBox)component).setSelected(false);
		}
            }
        };

	// Default checkbox colors
	/*
	setBackgroundColor(Color.white);
	setForegroundColor(Color.black);
	setSelectedBackgroundColor(selectionColor);
	setSelectedForegroundColor(Color.white);
	*/
    }

//
// Modifying and Querying
//

    public void setBackgroundColor(Color newColor) {
	backgroundColor = newColor;
    }

    public Color getBackgroundColor() {
	return backgroundColor;
    }

    public void setForegroundColor(Color newColor) {
	foregroundColor = newColor;
    }

    public Color getForegroundColor() {
	return foregroundColor;
    }

    public void setSelectedBackgroundColor(Color newColor) {
	selectedBackgroundColor = newColor;
    }

    public Color getSelectedBackgroundColor() {
	return selectedBackgroundColor;
    }

    public void setSelectedForegroundColor(Color newColor) {
	selectedForegroundColor = newColor;
    }

    public Color getSelectedForegroundColor() {
	return selectedForegroundColor;
    }

    public void setToolTipText(String text) {
	if (component instanceof JComponent)
	    ((JComponent)component).setToolTipText(text);
    }

    public Component getComponent() {
	return component;
    }

//
// Implementing TableCellRenderer
//

    public Component getTableCellRendererComponent(JTable table, Object value,
						   boolean isSelected, boolean hasFocus,
						   int row, int column) {
        // PENDING(philip): Hacks for Motif L&F.
	// The muddle of if clauses below are minimal hacks that were included
	// to make the motif L&F table use the correct selection colors
	// for the for the first motif L&F release.
	// This all needs to be redone.
	if (isSelected) {
	    if (selectedBackgroundColor == null) {
	        component.setBackground(UIManager.getColor("textHighlight"));
	    }
	    else {
	        component.setBackground(selectedBackgroundColor);
	    }
	    if (selectedForegroundColor == null) {
	        component.setForeground(UIManager.getColor("textHighlightText"));
	    }
	    else {
	        component.setForeground(selectedForegroundColor);
	    }
	}
	else {
	//    if (backgroundColor != null) {
	        component.setBackground(backgroundColor);
	//    } 
	//    else {
	//        component.setBackground(Color.white);
	//    }
	//    if (foregroundColor != null) { 
	        component.setForeground(foregroundColor);
	//    }
	//    else {
	//        component.setForeground(Color.black);
	//    }
	}

        this.value.setValue(value);
        return component;
    }


    protected class ValueProperty implements Serializable {
        protected Object value;

        public void setValue(Object x) {
            this.value = x;
        }
    }


}


