package com.sun.java.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.text.*;

public class Calculator extends Container implements ActionListener
{
  private JLabel output;
  private JLabel memDisplay;
  private TextField opDisplay;
  private int digitsTyped = 0;
 
  private double numMemory;
  private int operatorMemory = -1;
  private boolean decimalOn = false;
  private JButton OK;

  public boolean useValue;
  
  protected GridBagLayout layout = new GridBagLayout();
  protected GridBagConstraints cons = new GridBagConstraints();
   
  public Calculator()
  {
    setLayout(new BorderLayout());
    output = new JLabel("0");
    output.setHorizontalAlignment(output.RIGHT);
    JPanel panel1 = new JPanel();
    JPanel panel2 = new JPanel();
    JPanel panel3 = new JPanel();
    panel1.setLayout(new GridLayout(4,3));
    indexedButton tempElt;
    JButton tempButton;
    numArrayListener numListener = new numArrayListener();
    opArrayListener opListener = new opArrayListener();
    int i,j;
    
    for(i=3; i>0; i--)
    {
	for(j=2; j>=0; j--)
	  {
	    
	    tempElt = new indexedButton(Integer.toString(3*i - j),3*i-j);
	    tempElt.setMargin(new Insets(1,1,1,1));
	    panel1.add(tempElt);
	    tempElt.addActionListener(numListener);
	  }
    }
    tempElt = new indexedButton("0",0);
    panel1.add(tempElt);
    tempElt.addActionListener(numListener);
    
    tempButton = new JButton(".");
    panel1.add(tempButton);
    tempButton.addActionListener(this);
    tempButton = new JButton("=");
    panel1.add(tempButton);
    tempButton.addActionListener(this);
    
    panel2.setLayout(new GridLayout(4,1));
    tempElt = new indexedButton("*",0);
    panel2.add(tempElt);
    tempElt.addActionListener(opListener);
    tempElt = new indexedButton("/",1);
    panel2.add(tempElt);
    tempElt.addActionListener(opListener);
    tempElt = new indexedButton("+",2);
    panel2.add(tempElt);
    tempElt.addActionListener(opListener);
    tempElt = new indexedButton("-",3);
    panel2.add(tempElt);
    tempElt.addActionListener(opListener);

    panel3.setLayout(new GridLayout(1,3));
    tempButton = new JButton("Clear");
    panel3.add(tempButton);
    tempButton.addActionListener(this);
    tempButton = new JButton("Cancel");
    panel3.add(tempButton);
    tempButton.addActionListener(this);

    OK = new JButton("OK");
    panel3.add(OK);

    cons.gridx = 0;
    cons.gridy = 0;
    cons.weightx = 1;
    cons.weighty = 1;
    cons.insets = new Insets(10,10,10,10);
    JPanel panel4 = new JPanel();
    //panel4.setLayout(layout);
    panel4.setLayout(new BorderLayout());
    GridBagConstraints cons = this.cons;
    cons.insets = new Insets(0,0,0,0);
    cons.gridx = GridBagConstraints.RELATIVE; 
    memDisplay = new JLabel("(Memory empty)");
    opDisplay = new TextField(1);
    opDisplay.setEditable(false);
    
    panel4.add(memDisplay, BorderLayout.WEST);
    panel4.add(opDisplay, BorderLayout.EAST);
    panel4.add(output, BorderLayout.SOUTH);

    add(panel4, BorderLayout.NORTH);
    add(panel1, BorderLayout.WEST);
    add(panel2, BorderLayout.EAST);
    add(panel3, BorderLayout.SOUTH);
    
  }
  public double convertOutput()
  {
    double num;
    if(!(decimalOn))
    //if(output.getText().indexOf('.') == -1)
      {
	num = (double)(Integer.parseInt(output.getText()));
      }
    else
      {
	num = (Double.valueOf(output.getText())).doubleValue();	
      }
    return num;
  }
  public void clear()
  {
    decimalOn = false;
    opDisplay.setText(" ");
    memDisplay.setText("(Memory empty)");
    numMemory = 0;
    operatorMemory = -1;
    digitsTyped = 0;
  }
  public void actionPerformed(ActionEvent e) 
  {
 
    if((e.getActionCommand().equals(".")) && (!(decimalOn)))
      {
	decimalOn = true;
	output.setText(output.getText() + ".");	
      }
    else if(e.getActionCommand().equals("Clear"))
      {
	output.setText("0");
	clear();
      }
    else if(e.getActionCommand().equals("Cancel"))
      {
	useValue = false;
	(getParent()).setVisible(false);
      }
    // else if(e.getActionCommand().equals("OK"))
//       {
// 	useValue = true;
// 	(getParent()).setVisible(false);
	
// 	// this is a TEMPORARY fix! the Calculator class is intended to be a four function
// 	// calculator for use in any application that needs it, not necceassrily tied to a
// 	// MoneyChooser. this is how it is for now because i need WindowListeners on 
// 	// JPopupMenus.
	
// 	myMoneyChooser.getCalculatorInfo();	
//       }
    else if(e.getActionCommand().equals("="))
      {
	double temp = convertOutput();
	switch(operatorMemory)
	  {
	  case 0:
	    output.setText(Double.toString(temp*numMemory));
	    clear();
	    break;
	  case 1:
	    output.setText(Double.toString(numMemory/temp));
	    clear();
	    break;
	  case 2:
	    output.setText(Double.toString(temp+numMemory));
	    clear();
	    break;
	  case 3:
	    output.setText(Double.toString(numMemory-temp));
	    clear();
	    break;
	  }
	if(output.getText().indexOf('.') != -1)
	  {
	    decimalOn = true;
	  }
      }
  }
  public JButton getOKButton()
  {
    return OK;
  }

  class numArrayListener implements ActionListener
  {
    public numArrayListener(){}
    public void actionPerformed(ActionEvent e) 
    {
      if(((!(decimalOn)) && (digitsTyped < 9)) || ((decimalOn) && (digitsTyped <15)))
	{
	  digitsTyped++;
	  if(output.getText() == "0")
	    {
	      output.setText(Integer.toString(((indexedButton)(e.getSource())).index));
	    }
	  else
	    {
	      output.setText(output.getText() + Integer.toString(((indexedButton)(e.getSource())).index));
	    }
	  
	}
    }
  } 
  class opArrayListener implements ActionListener
  {
    public opArrayListener(){}
    public void actionPerformed(ActionEvent e)
    {     
      operatorMemory =((indexedButton)(e.getSource())).index; 
      opDisplay.setText(((indexedButton)(e.getSource())).getText());
      memDisplay.setText(output.getText());
      numMemory = convertOutput();
      output.setText("");
      decimalOn = false;
      digitsTyped = 0;
    }  
  }
  class indexedButton extends JButton
  {
    public int index;
    public indexedButton(String txt, int ind)
    {
      super(txt);
      index = ind;
    }
  }
}




