/*
 * @(#)AudioPreview.java	1.5 01/28/98
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * @author James Gosling
 */
 
package com.sun.java.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import sun.audio.*;

import com.sun.java.swing.event.*;

/** A component to preview an audio file, intended to fit into the
 *  preview slot of a FileChooser.  In normal usage, only the
 *  ask method is of interest: it pops up a dialog box with
 *  a FileChooser containing an instance of this previewer and
 *  filtering for appropriate files.
 *  @author James Gosling
 */
public class AudioPreview extends Component implements FilePreview {
    private String txt[] = new String[10];
    private boolean blank;
    private AudioStream audiostream;

    private static FileChooserFilter fcf;
    /** Convenience method to prompt for the name of an audio file.
	@param fparent the parent frame for the dialog box.
		fparent may be null if a default parent has
		been established with StandardDialog
	@param description a description string that will be shown
		to the user to indicate what is being requested
	@param initial the initial value for the string
	@param columns the default width (in 'm's) of the TextField
	@param target the ChangeListener that will be informed if the
			OK or Apply buttons are hit.
	@return If target is null,
		the dialog box will be modal and the method
		will return the final result, or null if canceled.
		Otherwise, the
		dialog box is non-modal, the method returns null
		immediatly, and the listener is informed when
		appropriate.  The source of the change event will
		be a FileChooser.
	@see StandardDialog
     */
    public static File ask(Component parent, String title, File dfc,
			        ChangeListener target) {
    	StandardDialog tDialog;
    	FileChooser tChooser;
    	tChooser = new FileChooser ();
    	tDialog = new StandardDialog(parent, tChooser, target == null);
    	tChooser.getModel().setFile(dfc);
    	if (fcf == null) {
    	    fcf = new FileChooserFilter();
    	    fcf.add("Internet audio (au)");
    	}
    	tChooser.setFilter(fcf);
    	tChooser.setPreview(new AudioPreview());
    	if (target != null)
    	    tDialog.addChangeListener(target);
    	if (title != null)
    	    tDialog.setTitle(title);
    	tDialog.start();
    	File r = tDialog.isCanceled() || target != null ? null
    	: tChooser.getModel().getFile();
    	if (target == null)
    	    tDialog.dispose();
    	return r;
    }


    public AudioPreview(){}
    public void setPreviewFile(File f) {
        if (f == null) {
            if (audiostream != null) {
                try {
                    AudioPlayer.player.stop(audiostream);
                    audiostream.close();
                }
                catch(Throwable e){}
                audiostream = null;
            }
            if (!blank) {
                blank = true;
                repaint();
            }
            return;
        }
        blank = false;
        boolean playing = audiostream != null;
        if (audiostream != null) {
            AudioPlayer.player.stop(audiostream);
            try { audiostream.close(); }
            catch(IOException e){}
            audiostream = null;
        }
        InputStream in = null;
        try {
            in = new FileInputStream(f);
            audiostream = new AudioStream(in);
            AudioPlayer.player.start(audiostream);
        } catch(Throwable e) {
            try { if (in != null) in.close(); }
            catch(IOException err){}
            audiostream = null;
        }
        if ((audiostream!=null)!=playing) repaint();
    }
    private Dimension isize = new Dimension(120,120);
    public void setSize(int w, int h) {
        if (w!=isize.width || h!=isize.height) {
            isize.width = w;
            isize.height = h;
            invalidate();
        }
    }
    public void setBounds(int x, int y,int width, int height) {
        super.setBounds(x, y, width, height);
        setSize(width, height);
    }
    public Dimension getPreferredSize() {
        return isize;
    }
    public Dimension getMinimumSize() {
        return getPreferredSize();
    }
    public void paint(Graphics g) {
        if (!blank && audiostream != null) {
            Dimension d = getSize();
            int w = d.width;
            int h = d.height;
            for (int i = 1; i<30; i+=4)
                g.drawArc(i,i,w-i*2,h-i*2,45,-90);
        }
    }
}
