/*
 * @(#)TreeModelEvent.java	1.15 98/04/14
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.event;

import java.util.EventObject;
import com.sun.java.swing.tree.TreePath;


/**
 * Encapsulates information describing changes to a tree model, and
 * used to notify tree model listeners of the change.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.15 04/14/98
 * @author Rob Davis
 * @author Ray Ryan
 * @author Scott Violet
 */
public class TreeModelEvent extends EventObject {
    /** Path to the parent of the nodes that have changed. */
    protected TreePath	path;
    /** Indices identifying the position of where the children were. */
    protected int[]	childIndices;
    /** Children that have been removed. */
    protected Object[]  children;

    /**
     * Used to create an event when nodes have been changed, inserted, or
     * removed; identifying the path to the parent of the modified items as
     * an array of Objects.
     * All of the modified objects are siblings which are direct descendents
     * (not grandchildren) of the specified parent.
     * ----TO BE VERIFIED---(eta)
     * ---TO BE DETERMINED: INDICES SPECIFIED AS "1,3,5" for a 5-child list
     *    or as "1,2,3" ??
     *
     * @param source the Object responsible for generating the event (typically
     *               the creator of the event object passes <code>this</code>
     *               for its value)
     * @param path   an array of Object identifying the path to the
     *               parent of the removed item(s), where the first element
     *               of the array is the Object stored at the root node and
     *               the last element is the Object stored at the parent node
     * @param childIndices an array of <code>int</code> that specifies the 
     *               index values of the removed items
     * @param children an array of Object the orphaned child objects 
     */
    public TreeModelEvent(Object source, Object[] path, int[] childIndices,
			  Object[] children)
    {
	this(source, new TreePath(path), childIndices, children);
    }

    /**
     * Used to create an event when nodes have been removed, identifying
     * the path to the parent of the removed items as a TreePath object.
     * All of the removed objects must have been direct descendents (not
     * grandchildren) of the specified parent.
     * ----TO BE VERIFIED---(eta)
     *
     * @param source the Object responsible for generating the event (typically
     *               the creator of the event object passes <code>this</code>
     *               for its value)
     * @param path   a TreePath object that identifies the path to the
     *               parent of the removed item(s). In the DefaultTreeModel,
     *               this object contains an array of user-data objects, 
     *               but a subclass of TreePath could use some totally
     *               different mechanism -- for example, a node ID number
     * @param childIndices an array of <code>int</code> that specifies the 
     *               index values of the removed items
     * @param children an array of Object the orphaned child objects
     *
     * @see #TreeModelEvent(Object,Object[],int[],Object[])
     * @see TreePath
     */
    public TreeModelEvent(Object source, TreePath path, int[] childIndices,
			  Object[] children)
    {
	super(source);
	this.path = path;
	this.childIndices = childIndices;
	this.children = children;
    }

    /**
     * Used to create an event when nodes have been inserted, a node has
     * changed, or the node structure has changed in some way, identifying
     * the path to the change as an array of Objects.
     * ----TO BE VERIFIED---(eta)
     * <p>
     * When the object data at a node has changed, the path points to the
     * changed item. When nodes have been inserted or the tree's structure
     * has changed, the path points to the parent of the changes. A
     * "structure change" might involve nodes swapping position, for
     * example, or it might encapsulate multiple inserts and deletes 
     * (without identifying which nodes have been removed).
     *
     * @param source the Object responsible for generating the event (typically
     *               the creator of the event object passes <code>this</code>
     *               for its value)
     * @param path   an array of Object identifying the path to the
     *               change, where the first element of the array is the 
     *               object stored at the root node and the last element
     *               is the object stored at the changed node
     */
    public TreeModelEvent(Object source, Object[] path)
    {
	this(source, new TreePath(path));
    }

    /**
     * Used to create an event when nodes have been inserted, a node has
     * changed, or the node structure has changed in some way, identifying
     * the path to the change as a TreePath object.
     * ----TO BE VERIFIED---(eta)
     * <p>
     * When the object data at a node has changed, the path points to the
     * changed item. When nodes have been inserted or the tree's structure
     * has changed, the path points to the parent of the changes. A
     * "structure change" might involve nodes swapping position, for
     * example, or it might encapsulate multiple inserts and deletes 
     * (without identifying which nodes have been removed).
     *
     * @param source the Object responsible for generating the event (typically
     *               the creator of the event object passes <code>this</code>
     *               for its value)
     * @param path   a TreePath object that identifies the path to the
     *               change. In the DefaultTreeModel,
     *               this object contains an array of user-data objects, 
     *               but a subclass of TreePath could use some totally
     *               different mechanism -- for example, a node ID number
     *
     * @see #TreeModelEvent(Object,Object[])
     * @see TreePath
     */
    public TreeModelEvent(Object source, TreePath path) 
    {
	super(source);
	this.path = path;
	this.childIndices = new int[0];
    }

    /**
     * Returns the TreePath object identifying the changed node.
     * Use <code>getLastPathComponent</code> on that object to
     * get the data stored at that node.
     *
     * @return the TreePath object identifying the changed node
     * @see TreePath#getLastPathComponent
     */
    public TreePath getTreePath() { return path; }

    /**
     * Convenience method to get the array of objects from the TreePath
     * instance that this event wraps.
     *
     * @return an array of Objects, where the first Object is the one
     *         stored at the root and the last object is the one
     *         stored at the node identified by the path
     */
    public Object[] getPath() {
	if(path != null)
	    return path.getPath();
	return null;
    }

    /**
     * Returns the objects that are children of the node identified by
     * <code>getPath</code> at the locations specified by <code>getChildIndices</code>.
     * If this is a removal event the returned objects are no longer 
     * children of the parent node.
     *
     * @return an array of Object containing the children specified by
     *         the event
     * @see #getPath
     * @see #getChildIndices
     */
    public Object[] getChildren() {
	if(children != null) {
	    int            cCount = children.length;
	    Object[]       retChildren = new Object[cCount];

	    System.arraycopy(children, 0, retChildren, 0, cCount);
	    return retChildren;
	}
	return null;
    }

    /**
     * Returns the values of the child indexes. If this is a removal event
     * the indexes point to locations in the initial list where items 
     * were removed. If it is an insert, the indices point to locations
     * in the final list where the items were added. For node changes,
     * the indices point to the locations of the modified nodes.
     *
     * @return an array of <code>int</code> containing index locations for
     *         the children specified by the event
     */
    public int[] getChildIndices() {
	if(childIndices != null) {
	    int            cCount = childIndices.length;
	    int[]          retArray = new int[cCount];

	    System.arraycopy(childIndices, 0, retArray, 0, cCount);
	    return retArray;
	}
	return null;
    }

    /**
     * Returns a string that displays and identifies this object's
     * properties.
     *
     * @return a String representation of this object
     */
    public String toString() {
	StringBuffer   retBuffer = new StringBuffer();

	retBuffer.append(getClass().getName() + " " +
			 Integer.toString(hashCode()));
	if(path != null)
	    retBuffer.append(" path " + path);
	if(childIndices != null) {
	    retBuffer.append(" indicices [ ");
	    for(int counter = 0; counter < childIndices.length; counter++)
		retBuffer.append(Integer.toString(childIndices[counter])+ " ");
	    retBuffer.append("]");
	}
	if(children != null) {
	    retBuffer.append(" children [ ");
	    for(int counter = 0; counter < children.length; counter++)
		retBuffer.append(children[counter] + " ");
	    retBuffer.append("]");
	}
	return retBuffer.toString();
    }
}
