/*
 * @(#)ListSelectionEvent.java	1.9 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.event;

import java.util.EventObject;
import com.sun.java.swing.*;


/** 
 * An event that characterizes a change in the current
 * selection.  The change is limited to a row interval.
 * ListSelectionListeners will generally query the source of
 * the event for the new selected status of each potentially
 * changed row.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.9 02/02/98
 * @author Hans Muller
 * @author Ray Ryan
 * @see ListSelectionModel
 */
public class ListSelectionEvent extends EventObject
{
    private int firstIndex;
    private int lastIndex;
    private boolean isAdjusting;

    /** 
     * Represents a change in selection status between firstIndex
     * and lastIndex inclusive (firstIndex is less than or equal to 
     * lastIndex).  Atleast one of the rows within the range will
     * have changed, a good ListSelectionModel implementation will
     * keep the range as small as possible.
     * 
     * @param firstIndex The first index that changed.
     * @param lastIndex The last index that changed, lastIndex >= firstIndex.
     * @param isAdjusting An indication that this is one of rapid a series of events
     */
    public ListSelectionEvent(Object source, int firstIndex, int lastIndex,
			      boolean isAdjusting)
    {
	super(source);
	this.firstIndex = firstIndex;
	this.lastIndex = lastIndex;
	this.isAdjusting = isAdjusting;
    }

    /**
     * @return The first row whose selection value may have changed.
     */
    public int getFirstIndex() { return firstIndex; }

    /**
     * @return The last row whose selection value may have changed.
     */
    public int getLastIndex() { return lastIndex; }

    /**
     * @return True if this is one of a rapid series of events
     */
    public boolean getValueIsAdjusting() { return isAdjusting; }

    public String toString() {
	String properties = 
	    " source=" + getSource() +  
            " firstIndex= " + firstIndex + 
            " lastIndex= " + lastIndex + 
	    " isAdjusting= " + isAdjusting +
            " ";
        return getClass().getName() + "[" + properties + "]";
    }
}

