/*
 * @(#)ViewportLayout.java	1.16 98/03/16
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import java.awt.LayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Point;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;

/**
 * The default layout manager for JViewport.  JViewportLayout defines 
 * a policy for layout that should be useful for most applications.
 * The viewport makes its view the same size as the viewport, 
 * however it will not make the view smaller than its minimum size.
 * As the viewport grows the view is kept bottom justified until 
 * the entire view is visible, subsequently the view is kept top
 * justified.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.16 03/16/98
 * @author unknown
 */
public class ViewportLayout implements LayoutManager, Serializable
{
    /**
     * Adds the specified component to the layout. Not used by this class.
     * @param name the name of the component
     * @param comp the the component to be added
     */
    public void addLayoutComponent(String name, Component c) { }

    /**
     * Removes the specified component from the layout. Not used by
     * this class.  
     * @param comp the component to remove
     */
    public void removeLayoutComponent(Component c) { }


    /**
     * Returns the preferred dimensions for this layout given the components
     * in the specified target container.
     * @param target the component which needs to be laid out
     * @return a Dimension object containing the preferred dimensions
     * @see target the Container to be laid out
     * @see #minimumLayoutSize
     */
    public Dimension preferredLayoutSize(Container parent) {
	Component view = ((JViewport)parent).getView();
	if (view == null) {
	    return new Dimension(0, 0);
	}
	else if (view instanceof Scrollable) {
	    return ((Scrollable)view).getPreferredScrollableViewportSize();
	} 
	else {
	    return view.getPreferredSize();
	} 
    }


    /**
     * Returns the minimum dimensions needed to layout the components
     * contained in the specified target container.
     *
     * @param target the component which needs to be laid out
     * @return a Dimension object containing the minimum dimensions
     * @see #preferredLayoutSize
     */
    public Dimension minimumLayoutSize(Container parent) {
	return new Dimension(4, 4);
    }


    /**
     * Called by the AWT when the specified container needs to be laid out.
     *
     * @param parent  the container to lay out
     *
     * @exception AWTError  if the target isn't the container specified to the
     *                      BoxLayout constructor
     */
    public void layoutContainer(Container parent) 
    {
	JViewport vp = (JViewport)parent;
	Component view = vp.getView();
	Scrollable scrollableView = null;

	if (view == null) {
	    return;
	} 
	else if (view instanceof Scrollable) {
	    scrollableView = (Scrollable) view;
	}

	/* All of the dimensions below are in view coordinates, except
	 * vpSize which we're converting.
	 */

	Insets insets = vp.getInsets();
	Dimension viewPrefSize = view.getPreferredSize();
	Dimension vpSize = vp.getSize();
	Dimension extentSize = vp.toViewCoordinates(vpSize);
	Dimension viewSize = viewPrefSize; 

	if (scrollableView != null) {
	    if (scrollableView.getScrollableTracksViewportWidth()) {
		viewSize.width = vpSize.width;
	    }
	    if (scrollableView.getScrollableTracksViewportHeight()) {
		viewSize.height = vpSize.height;
	    }
	}

	Point viewPosition = vp.getViewPosition();

	/* If the new viewport size would leave empty space below the
	 * view, top justify the view.
	 */

	if ((viewPosition.y + extentSize.height) > viewSize.height) {
	    viewPosition.y = 0;
	}
	
	/* If the new viewport size would leave empty space to the
	 * right of the view, left justify the view.
	 */

	if ((viewPosition.x + extentSize.width) > viewSize.width) {
	    viewPosition.x = 0;
	}

	/* If the orgin of the view is showing and the viewport is 
	 * bigger than the views preferred size, then make the view
	 * the same size as the viewport.  
	 */
	
	if ((viewPosition.y == 0) && (vpSize.height > viewPrefSize.height)) {
	    viewPrefSize.height = vpSize.height;
	}
	
	if ((viewPosition.x == 0) && (vpSize.width > viewPrefSize.width)) {
	    viewPrefSize.width = vpSize.width;
	}

	vp.setViewPosition(viewPosition);
	vp.setViewSize(viewPrefSize);
    }
}

